package org.hl7.fhir.dstu2016may.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Sun, May 8, 2016 03:05+1000 for FHIR v1.4.0

import org.hl7.fhir.exceptions.FHIRException;

public enum SelectionBehavior {

  /**
   * Any number of the items in the group may be chosen, from zero to all
   */
  ANY,
  /**
   * All the items in the group must be selected as a single unit
   */
  ALL,
  /**
   * All the items in the group are meant to be chosen as a single unit: either
   * all must be selected by the end user, or none may be selected
   */
  ALLORNONE,
  /**
   * The end user must choose one and only one of the selectable items in the
   * group. The user may not choose none of the items in the group
   */
  EXACTLYONE,
  /**
   * The end user may choose zero or at most one of the items in the group
   */
  ATMOSTONE,
  /**
   * The end user must choose a minimum of one, and as many additional as desired
   */
  ONEORMORE,
  /**
   * added to help the parsers
   */
  NULL;

  public static SelectionBehavior fromCode(String codeString) throws FHIRException {
    if (codeString == null || "".equals(codeString))
      return null;
    if ("any".equals(codeString))
      return ANY;
    if ("all".equals(codeString))
      return ALL;
    if ("all-or-none".equals(codeString))
      return ALLORNONE;
    if ("exactly-one".equals(codeString))
      return EXACTLYONE;
    if ("at-most-one".equals(codeString))
      return ATMOSTONE;
    if ("one-or-more".equals(codeString))
      return ONEORMORE;
    throw new FHIRException("Unknown SelectionBehavior code '" + codeString + "'");
  }

  public String toCode() {
    switch (this) {
    case ANY:
      return "any";
    case ALL:
      return "all";
    case ALLORNONE:
      return "all-or-none";
    case EXACTLYONE:
      return "exactly-one";
    case ATMOSTONE:
      return "at-most-one";
    case ONEORMORE:
      return "one-or-more";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getSystem() {
    return "http://hl7.org/fhir/selection-behavior";
  }

  public String getDefinition() {
    switch (this) {
    case ANY:
      return "Any number of the items in the group may be chosen, from zero to all";
    case ALL:
      return "All the items in the group must be selected as a single unit";
    case ALLORNONE:
      return "All the items in the group are meant to be chosen as a single unit: either all must be selected by the end user, or none may be selected";
    case EXACTLYONE:
      return "The end user must choose one and only one of the selectable items in the group. The user may not choose none of the items in the group";
    case ATMOSTONE:
      return "The end user may choose zero or at most one of the items in the group";
    case ONEORMORE:
      return "The end user must choose a minimum of one, and as many additional as desired";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getDisplay() {
    switch (this) {
    case ANY:
      return "Any";
    case ALL:
      return "All";
    case ALLORNONE:
      return "All Or None";
    case EXACTLYONE:
      return "Exactly One";
    case ATMOSTONE:
      return "At Most One";
    case ONEORMORE:
      return "One Or More";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

}