/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu2016may.formats.ParserBase;
import org.hl7.fhir.dstu2016may.formats.XmlParser;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.utils.ResourceUtilities;
import org.hl7.fhir.dstu2016may.utils.client.EFhirClientException;
import org.hl7.fhir.dstu2016may.utils.client.ResourceAddress;
import org.hl7.fhir.dstu2016may.utils.client.ResourceFormat;
import org.hl7.fhir.dstu2016may.utils.client.ResourceRequest;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class ClientUtils {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String HEADER_LOCATION = "location";
    private static boolean debugging = false;
    private HttpHost proxy;
    private int timeout = 5000;
    private String username;
    private String password;
    private ToolingClientLogger logger;
    private int retryCount;

    public HttpHost getProxy() {
        return this.proxy;
    }

    public void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public <T extends Resource> ResourceRequest<T> issueOptionsRequest(URI optionsUri, String resourceFormat, int timeoutLoading) {
        HttpOptions options = new HttpOptions(optionsUri);
        return this.issueResourceRequest(resourceFormat, (HttpUriRequest)options, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issueGetResourceRequest(URI resourceUri, String resourceFormat, int timeoutLoading) {
        HttpGet httpget = new HttpGet(resourceUri);
        return this.issueResourceRequest(resourceFormat, (HttpUriRequest)httpget, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, List<Header> headers, int timeoutLoading) {
        HttpPut httpPut = new HttpPut(resourceUri);
        return this.issueResourceRequest(resourceFormat, (HttpUriRequest)httpPut, payload, headers, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, int timeoutLoading) {
        HttpPut httpPut = new HttpPut(resourceUri);
        return this.issueResourceRequest(resourceFormat, (HttpUriRequest)httpPut, payload, null, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, List<Header> headers, int timeoutLoading) {
        HttpPost httpPost = new HttpPost(resourceUri);
        return this.issueResourceRequest(resourceFormat, (HttpUriRequest)httpPost, payload, headers, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, int timeoutLoading) {
        return this.issuePostRequest(resourceUri, payload, resourceFormat, null, timeoutLoading);
    }

    public Bundle issueGetFeedRequest(URI resourceUri, String resourceFormat) {
        HttpGet httpget = new HttpGet(resourceUri);
        this.configureFhirRequest((HttpRequest)httpget, resourceFormat);
        HttpResponse response = this.sendRequest((HttpUriRequest)httpget);
        return (Bundle)this.unmarshalReference(response, resourceFormat);
    }

    private void setAuth(HttpRequest httpget) {
        if (this.password != null) {
            try {
                byte[] b = Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes("ASCII"));
                String b64 = new String(b, StandardCharsets.US_ASCII);
                httpget.setHeader("Authorization", "Basic " + b64);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public Bundle postBatchRequest(URI resourceUri, byte[] payload, String resourceFormat, int timeoutLoading) {
        HttpPost httpPost = new HttpPost(resourceUri);
        this.configureFhirRequest((HttpRequest)httpPost, resourceFormat);
        HttpResponse response = this.sendPayload((HttpEntityEnclosingRequestBase)httpPost, payload, this.proxy, timeoutLoading);
        return this.unmarshalFeed(response, resourceFormat);
    }

    public boolean issueDeleteRequest(URI resourceUri) {
        HttpDelete deleteRequest = new HttpDelete(resourceUri);
        HttpResponse response = this.sendRequest((HttpUriRequest)deleteRequest);
        int responseStatusCode = response.getStatusLine().getStatusCode();
        boolean deletionSuccessful = false;
        if (responseStatusCode == 204) {
            deletionSuccessful = true;
        }
        return deletionSuccessful;
    }

    protected <T extends Resource> ResourceRequest<T> issueResourceRequest(String resourceFormat, HttpUriRequest request, int timeoutLoading) {
        return this.issueResourceRequest(resourceFormat, request, null, timeoutLoading);
    }

    protected <T extends Resource> ResourceRequest<T> issueResourceRequest(String resourceFormat, HttpUriRequest request, byte[] payload, int timeoutLoading) {
        return this.issueResourceRequest(resourceFormat, request, payload, null, timeoutLoading);
    }

    protected <T extends Resource> ResourceRequest<T> issueResourceRequest(String resourceFormat, HttpUriRequest request, byte[] payload, List<Header> headers, int timeoutLoading) {
        this.configureFhirRequest((HttpRequest)request, resourceFormat, headers);
        HttpResponse response = null;
        if (request instanceof HttpEntityEnclosingRequest && payload != null) {
            response = this.sendPayload((HttpEntityEnclosingRequestBase)request, payload, this.proxy, timeoutLoading);
        } else {
            if (request instanceof HttpEntityEnclosingRequest && payload == null) {
                throw new EFhirClientException("PUT and POST requests require a non-null payload");
            }
            response = this.sendRequest(request);
        }
        T resource = this.unmarshalReference(response, resourceFormat);
        return new ResourceRequest<T>(resource, response.getStatusLine().getStatusCode(), this.getLocationHeader(response));
    }

    protected void configureFhirRequest(HttpRequest request, String format) {
        this.configureFhirRequest(request, format, null);
    }

    protected void configureFhirRequest(HttpRequest request, String format, List<Header> headers) {
        request.addHeader("User-Agent", "Java FHIR Client for FHIR");
        if (format != null) {
            request.addHeader("Accept", format);
            request.addHeader("Content-Type", format + ";charset=UTF-8");
        }
        if (headers != null) {
            for (Header header : headers) {
                request.addHeader(header);
            }
        }
        this.setAuth(request);
    }

    protected HttpResponse sendPayload(HttpEntityEnclosingRequestBase request, byte[] payload, HttpHost proxy, int timeoutLoading) {
        HttpResponse response = null;
        boolean ok = false;
        long t = System.currentTimeMillis();
        int tryCount = 0;
        while (!ok) {
            try {
                ++tryCount;
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpParams params = httpclient.getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.timeout);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)(this.timeout * timeoutLoading));
                if (proxy != null) {
                    httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                }
                request.setEntity((HttpEntity)new ByteArrayEntity(payload));
                this.log(request);
                response = httpclient.execute((HttpUriRequest)request);
                ok = true;
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage() + " (" + (System.currentTimeMillis() - t) + "ms / " + Utilities.describeSize((int)payload.length) + ")");
                if (tryCount <= this.retryCount || tryCount < 3 && ioe instanceof ConnectTimeoutException) {
                    ok = false;
                    continue;
                }
                throw new EFhirClientException("Error sending HTTP Post/Put Payload: " + ioe.getMessage(), ioe);
            }
        }
        return response;
    }

    protected HttpResponse sendRequest(HttpUriRequest request) {
        HttpResponse response = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            this.log(request);
            HttpParams params = httpclient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.timeout);
            if (this.proxy != null) {
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)this.proxy);
            }
            response = httpclient.execute(request);
        }
        catch (IOException ioe) {
            if (debugging) {
                ioe.printStackTrace();
            }
            throw new EFhirClientException("Error sending Http Request: " + ioe.getMessage(), ioe);
        }
        return response;
    }

    protected <T extends Resource> T unmarshalReference(HttpResponse response, String format) {
        Resource resource = null;
        OperationOutcome error = null;
        byte[] cnt = this.log(response);
        if (cnt != null) {
            try {
                resource = this.getParser(format).parse(cnt);
                if (resource instanceof OperationOutcome && this.hasError((OperationOutcome)resource)) {
                    error = (OperationOutcome)resource;
                }
            }
            catch (IOException ioe) {
                throw new EFhirClientException("Error reading Http Response: " + ioe.getMessage(), ioe);
            }
            catch (Exception e) {
                throw new EFhirClientException("Error parsing response message: " + e.getMessage(), e);
            }
        }
        if (error != null) {
            throw new EFhirClientException("Error from server: " + ResourceUtilities.getErrorDescription(error), error);
        }
        return (T)resource;
    }

    protected Bundle unmarshalFeed(HttpResponse response, String format) {
        OperationOutcome error;
        Bundle feed;
        block6: {
            feed = null;
            byte[] cnt = this.log(response);
            String contentType = response.getHeaders("Content-Type")[0].getValue();
            error = null;
            try {
                if (cnt == null || !contentType.contains(ResourceFormat.RESOURCE_XML.getHeader()) && !contentType.contains("text/xml+fhir")) break block6;
                Resource rf = this.getParser(format).parse(cnt);
                if (rf instanceof Bundle) {
                    feed = (Bundle)rf;
                    break block6;
                }
                if (rf instanceof OperationOutcome && this.hasError((OperationOutcome)rf)) {
                    error = (OperationOutcome)rf;
                    break block6;
                }
                throw new EFhirClientException("Error reading server response: a resource was returned instead");
            }
            catch (IOException ioe) {
                throw new EFhirClientException("Error reading Http Response", ioe);
            }
            catch (Exception e) {
                throw new EFhirClientException("Error parsing response message", e);
            }
        }
        if (error != null) {
            throw new EFhirClientException("Error from server: " + ResourceUtilities.getErrorDescription(error), error);
        }
        return feed;
    }

    private boolean hasError(OperationOutcome oo) {
        for (OperationOutcome.OperationOutcomeIssueComponent t : oo.getIssue()) {
            if (t.getSeverity() != OperationOutcome.IssueSeverity.ERROR && t.getSeverity() != OperationOutcome.IssueSeverity.FATAL) continue;
            return true;
        }
        return false;
    }

    protected String getLocationHeader(HttpResponse response) {
        String location = null;
        if (response.getHeaders(HEADER_LOCATION).length > 0) {
            location = response.getHeaders(HEADER_LOCATION)[0].getValue();
        } else if (response.getHeaders("content-location").length > 0) {
            location = response.getHeaders("content-location")[0].getValue();
        }
        return location;
    }

    public HttpURLConnection buildConnection(URI baseServiceUri, String tail) {
        try {
            HttpURLConnection client = (HttpURLConnection)baseServiceUri.resolve(tail).toURL().openConnection();
            return client;
        }
        catch (MalformedURLException mue) {
            throw new EFhirClientException("Invalid Service URL", mue);
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Unable to establish connection to server: " + baseServiceUri.toString() + tail, ioe);
        }
    }

    public HttpURLConnection buildConnection(URI baseServiceUri, ResourceType resourceType, String id) {
        return this.buildConnection(baseServiceUri, ResourceAddress.buildRelativePathFromResourceType(resourceType, id));
    }

    public <T extends Resource> byte[] getResourceAsByteArray(T resource, boolean pretty, boolean isJson) {
        ByteArrayOutputStream baos = null;
        byte[] byteArray = null;
        try {
            baos = new ByteArrayOutputStream();
            ParserBase parser = null;
            parser = isJson ? new JsonParser() : new XmlParser();
            parser.setOutputStyle(pretty ? IParser.OutputStyle.PRETTY : IParser.OutputStyle.NORMAL);
            parser.compose(baos, resource);
            baos.close();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            try {
                baos.close();
            }
            catch (Exception ex) {
                throw new EFhirClientException("Error closing output stream", ex);
            }
            throw new EFhirClientException("Error converting output stream to byte array", e);
        }
        return byteArray;
    }

    public byte[] getFeedAsByteArray(Bundle feed, boolean pretty, boolean isJson) {
        ByteArrayOutputStream baos = null;
        byte[] byteArray = null;
        try {
            baos = new ByteArrayOutputStream();
            ParserBase parser = null;
            parser = isJson ? new JsonParser() : new XmlParser();
            parser.setOutputStyle(pretty ? IParser.OutputStyle.PRETTY : IParser.OutputStyle.NORMAL);
            parser.compose(baos, feed);
            baos.close();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            try {
                baos.close();
            }
            catch (Exception ex) {
                throw new EFhirClientException("Error closing output stream", ex);
            }
            throw new EFhirClientException("Error converting output stream to byte array", e);
        }
        return byteArray;
    }

    public Calendar getLastModifiedResponseHeaderAsCalendarObject(URLConnection serverConnection) {
        String dateTime = null;
        try {
            dateTime = serverConnection.getHeaderField("Last-Modified");
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", new Locale("en", "US"));
            Date lastModifiedTimestamp = format.parse(dateTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastModifiedTimestamp);
            return calendar;
        }
        catch (ParseException pe) {
            throw new EFhirClientException("Error parsing Last-Modified response header " + dateTime, pe);
        }
    }

    protected IParser getParser(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = ResourceFormat.RESOURCE_XML.getHeader();
        }
        if (format.equalsIgnoreCase("json") || format.equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader()) || format.equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader())) {
            return new JsonParser();
        }
        if (format.equalsIgnoreCase("xml") || format.equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader()) || format.equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader())) {
            return new XmlParser();
        }
        throw new EFhirClientException("Invalid format: " + format);
    }

    public Bundle issuePostFeedRequest(URI resourceUri, Map<String, String> parameters, String resourceName, Resource resource, String resourceFormat) throws IOException {
        HttpPost httppost = new HttpPost(resourceUri);
        String boundary = "----WebKitFormBoundarykbMUo6H8QaUnYtRy";
        httppost.addHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        httppost.addHeader("Accept", resourceFormat);
        this.configureFhirRequest((HttpRequest)httppost, null);
        HttpResponse response = this.sendPayload((HttpEntityEnclosingRequestBase)httppost, this.encodeFormSubmission(parameters, resourceName, resource, boundary));
        return this.unmarshalFeed(response, resourceFormat);
    }

    private byte[] encodeFormSubmission(Map<String, String> parameters, String resourceName, Resource resource, String boundary) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)b, DEFAULT_CHARSET);
        for (String name : parameters.keySet()) {
            w.write("--");
            w.write(boundary);
            w.write("\r\nContent-Disposition: form-data; name=\"" + name + "\"\r\n\r\n");
            w.write(parameters.get(name) + "\r\n");
        }
        w.write("--");
        w.write(boundary);
        w.write("\r\nContent-Disposition: form-data; name=\"" + resourceName + "\"\r\n\r\n");
        w.close();
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.NORMAL);
        json.compose(b, resource);
        b.close();
        w = new OutputStreamWriter((OutputStream)b, DEFAULT_CHARSET);
        w.write("\r\n--");
        w.write(boundary);
        w.write("--");
        w.close();
        return b.toByteArray();
    }

    protected HttpResponse sendPayload(HttpEntityEnclosingRequestBase request, byte[] payload) {
        HttpResponse response = null;
        try {
            this.log(request);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            request.setEntity((HttpEntity)new ByteArrayEntity(payload));
            response = httpclient.execute((HttpUriRequest)request);
            this.log(response);
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Error sending HTTP Post/Put Payload: " + ioe.getMessage(), ioe);
        }
        return response;
    }

    private void log(HttpUriRequest request) {
        if (this.logger != null) {
            ArrayList<String> headers = new ArrayList<String>();
            for (Header h : request.getAllHeaders()) {
                headers.add(h.toString());
            }
            this.logger.logRequest(request.getMethod(), request.getURI().toString(), headers, null);
        }
    }

    private void log(HttpEntityEnclosingRequestBase request) {
        if (this.logger != null) {
            ArrayList<String> headers = new ArrayList<String>();
            for (Header h : request.getAllHeaders()) {
                headers.add(h.toString());
            }
            byte[] cnt = null;
            try {
                InputStream s = request.getEntity().getContent();
                cnt = IOUtils.toByteArray((InputStream)s);
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.logRequest(request.getMethod(), request.getURI().toString(), headers, cnt);
        }
    }

    private byte[] log(HttpResponse response) {
        byte[] cnt = null;
        try {
            InputStream s = response.getEntity().getContent();
            cnt = IOUtils.toByteArray((InputStream)s);
            s.close();
        }
        catch (Exception s) {
            // empty catch block
        }
        if (this.logger != null) {
            ArrayList<String> headers = new ArrayList<String>();
            for (Header h : response.getAllHeaders()) {
                headers.add(h.toString());
            }
            this.logger.logResponse(response.getStatusLine().toString(), headers, cnt, 0L);
        }
        return cnt;
    }

    public ToolingClientLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ToolingClientLogger logger) {
        this.logger = logger;
    }

    protected String writeInputStreamAsString(InputStream instream) {
        String value = null;
        try {
            value = IOUtils.toString((InputStream)instream, (String)DEFAULT_CHARSET);
            System.out.println(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }
}

