/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcClinicalAssertStatus {
    _1797,
    _69074,
    NULL;


    public static HspcClinicalAssertStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1797".equals(codeString)) {
            return _1797;
        }
        if ("69074".equals(codeString)) {
            return _69074;
        }
        throw new FHIRException("Unknown HspcClinicalAssertStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1797: {
                return "1797";
            }
            case _69074: {
                return "69074";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/hspc-clinicalassertstatus";
    }

    public String getDefinition() {
        switch (this) {
            case _1797: {
                return "Indication that a symptom or condition is subsided or healed.";
            }
            case _69074: {
                return "The state of being mistaken.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1797: {
                return "Resolved";
            }
            case _69074: {
                return "Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

