/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EncounterAdmitSource {
    HOSPTRANS,
    EMD,
    OUTP,
    BORN,
    GP,
    MP,
    NURSING,
    PSYCH,
    REHAB,
    OTHER,
    NULL;


    public static EncounterAdmitSource fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("hosp-trans".equals(codeString)) {
            return HOSPTRANS;
        }
        if ("emd".equals(codeString)) {
            return EMD;
        }
        if ("outp".equals(codeString)) {
            return OUTP;
        }
        if ("born".equals(codeString)) {
            return BORN;
        }
        if ("gp".equals(codeString)) {
            return GP;
        }
        if ("mp".equals(codeString)) {
            return MP;
        }
        if ("nursing".equals(codeString)) {
            return NURSING;
        }
        if ("psych".equals(codeString)) {
            return PSYCH;
        }
        if ("rehab".equals(codeString)) {
            return REHAB;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown EncounterAdmitSource code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HOSPTRANS: {
                return "hosp-trans";
            }
            case EMD: {
                return "emd";
            }
            case OUTP: {
                return "outp";
            }
            case BORN: {
                return "born";
            }
            case GP: {
                return "gp";
            }
            case MP: {
                return "mp";
            }
            case NURSING: {
                return "nursing";
            }
            case PSYCH: {
                return "psych";
            }
            case REHAB: {
                return "rehab";
            }
            case OTHER: {
                return "other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/admit-source";
    }

    public String getDefinition() {
        switch (this) {
            case HOSPTRANS: {
                return "";
            }
            case EMD: {
                return "";
            }
            case OUTP: {
                return "";
            }
            case BORN: {
                return "";
            }
            case GP: {
                return "";
            }
            case MP: {
                return "";
            }
            case NURSING: {
                return "";
            }
            case PSYCH: {
                return "";
            }
            case REHAB: {
                return "";
            }
            case OTHER: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HOSPTRANS: {
                return "Transferred from other hospital";
            }
            case EMD: {
                return "From accident/emergency department";
            }
            case OUTP: {
                return "From outpatient department";
            }
            case BORN: {
                return "Born in hospital";
            }
            case GP: {
                return "General Practitioner referral";
            }
            case MP: {
                return "Medical Practitioner/physician referral";
            }
            case NURSING: {
                return "From nursing home";
            }
            case PSYCH: {
                return "From psychiatric hospital";
            }
            case REHAB: {
                return "From rehabilitation facility";
            }
            case OTHER: {
                return "Other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

