/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.HealthcareService;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Practitioner", profile="http://hl7.org/fhir/Profile/Practitioner")
public class Practitioner
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A identifier for the person as this agent", formalDefinition="An identifier that applies to this person in this role.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this practitioner's record is in active use", formalDefinition="Whether this practitioner's record is in active use.")
    protected BooleanType active;
    @Child(name="name", type={HumanName.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The name(s) associated with the practitioner", formalDefinition="The name(s) associated with the practitioner.")
    protected List<HumanName> name;
    @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A contact detail for the practitioner (that apply to all roles)", formalDefinition="A contact detail for the practitioner, e.g. a telephone number or an email address.")
    protected List<ContactPoint> telecom;
    @Child(name="address", type={Address.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Address(es) of the practitioner that are not role specific (typically home address)", formalDefinition="Address(es) of the practitioner that are not role specific (typically home address). \nWork addresses are not typically entered in this property as they are usually role dependent.")
    protected List<Address> address;
    @Child(name="gender", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
    protected Enumeration<Enumerations.AdministrativeGender> gender;
    @Child(name="birthDate", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date  on which the practitioner was born", formalDefinition="The date of birth for the practitioner.")
    protected DateType birthDate;
    @Child(name="photo", type={Attachment.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Image of the person", formalDefinition="Image of the person.")
    protected List<Attachment> photo;
    @Child(name="practitionerRole", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Roles/organizations the practitioner is associated with", formalDefinition="The list of roles/organizations that the practitioner is associated with.")
    protected List<PractitionerPractitionerRoleComponent> practitionerRole;
    @Child(name="qualification", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Qualifications obtained by training and certification", formalDefinition="Qualifications obtained by training and certification.")
    protected List<PractitionerQualificationComponent> qualification;
    @Child(name="communication", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A language the practitioner is able to use in patient communication", formalDefinition="A language the practitioner is able to use in patient communication.")
    protected List<CodeableConcept> communication;
    private static final long serialVersionUID = 2137859974L;
    @SearchParamDefinition(name="phone", path="Practitioner.telecom.where(system='phone') or Practitioner.practitionerRole.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="phonetic", path="Practitioner.name", description="A portion of either family or given name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="location", path="Practitioner.practitionerRole.location", description="One of the locations at which this practitioner provides care", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Practitioner:location").toLocked();
    @SearchParamDefinition(name="communication", path="Practitioner.communication", description="One of the languages that the practitioner can communicate with", type="token")
    public static final String SP_COMMUNICATION = "communication";
    public static final TokenClientParam COMMUNICATION = new TokenClientParam("communication");
    @SearchParamDefinition(name="address-country", path="Practitioner.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="organization", path="Practitioner.practitionerRole.organization", description="The identity of the organization the practitioner represents / acts on behalf of", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Practitioner:organization").toLocked();
    @SearchParamDefinition(name="address-city", path="Practitioner.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-state", path="Practitioner.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="given", path="Practitioner.name.given", description="A portion of the given name", type="string")
    public static final String SP_GIVEN = "given";
    public static final StringClientParam GIVEN = new StringClientParam("given");
    @SearchParamDefinition(name="email", path="Practitioner.telecom.where(system='email') or Practitioner.practitionerRole.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="address", path="Practitioner.address", description="An address in any kind of address/part", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-use", path="Practitioner.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="family", path="Practitioner.name.family", description="A portion of the family name", type="string")
    public static final String SP_FAMILY = "family";
    public static final StringClientParam FAMILY = new StringClientParam("family");
    @SearchParamDefinition(name="name", path="Practitioner.name", description="A portion of either family or given name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="telecom", path="Practitioner.telecom | Practitioner.practitionerRole.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="role", path="Practitioner.practitionerRole.role", description="The practitioner can perform this role at for the organization", type="token")
    public static final String SP_ROLE = "role";
    public static final TokenClientParam ROLE = new TokenClientParam("role");
    @SearchParamDefinition(name="gender", path="Practitioner.gender", description="Gender of the practitioner", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="specialty", path="Practitioner.practitionerRole.specialty", description="The practitioner has this specialty at an organization", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="identifier", path="Practitioner.identifier | Practitioner.practitionerRole.identifier", description="A practitioner's Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="address-postalcode", path="Practitioner.address.postalCode", description="A postalCode specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Practitioner addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Practitioner.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Practitioner setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Practitioner setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public List<HumanName> getName() {
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        return this.name;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (HumanName item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HumanName addName() {
        HumanName t = new HumanName();
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return t;
    }

    public Practitioner addName(HumanName t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Practitioner addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public Practitioner addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Practitioner.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
        }
        return this.gender;
    }

    public boolean hasGenderElement() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public Practitioner setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
        this.gender = value;
        return this;
    }

    public Enumerations.AdministrativeGender getGender() {
        return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
    }

    public Practitioner setGender(Enumerations.AdministrativeGender value) {
        if (value == null) {
            this.gender = null;
        } else {
            if (this.gender == null) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
            this.gender.setValue((Object)value);
        }
        return this;
    }

    public DateType getBirthDateElement() {
        if (this.birthDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Practitioner.birthDate");
            }
            if (Configuration.doAutoCreate()) {
                this.birthDate = new DateType();
            }
        }
        return this.birthDate;
    }

    public boolean hasBirthDateElement() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public boolean hasBirthDate() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public Practitioner setBirthDateElement(DateType value) {
        this.birthDate = value;
        return this;
    }

    public Date getBirthDate() {
        return this.birthDate == null ? null : (Date)this.birthDate.getValue();
    }

    public Practitioner setBirthDate(Date value) {
        if (value == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateType();
            }
            this.birthDate.setValue(value);
        }
        return this;
    }

    public List<Attachment> getPhoto() {
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        return this.photo;
    }

    public boolean hasPhoto() {
        if (this.photo == null) {
            return false;
        }
        for (Attachment item : this.photo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPhoto() {
        Attachment t = new Attachment();
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return t;
    }

    public Practitioner addPhoto(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return this;
    }

    public List<PractitionerPractitionerRoleComponent> getPractitionerRole() {
        if (this.practitionerRole == null) {
            this.practitionerRole = new ArrayList<PractitionerPractitionerRoleComponent>();
        }
        return this.practitionerRole;
    }

    public boolean hasPractitionerRole() {
        if (this.practitionerRole == null) {
            return false;
        }
        for (PractitionerPractitionerRoleComponent item : this.practitionerRole) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PractitionerPractitionerRoleComponent addPractitionerRole() {
        PractitionerPractitionerRoleComponent t = new PractitionerPractitionerRoleComponent();
        if (this.practitionerRole == null) {
            this.practitionerRole = new ArrayList<PractitionerPractitionerRoleComponent>();
        }
        this.practitionerRole.add(t);
        return t;
    }

    public Practitioner addPractitionerRole(PractitionerPractitionerRoleComponent t) {
        if (t == null) {
            return this;
        }
        if (this.practitionerRole == null) {
            this.practitionerRole = new ArrayList<PractitionerPractitionerRoleComponent>();
        }
        this.practitionerRole.add(t);
        return this;
    }

    public List<PractitionerQualificationComponent> getQualification() {
        if (this.qualification == null) {
            this.qualification = new ArrayList<PractitionerQualificationComponent>();
        }
        return this.qualification;
    }

    public boolean hasQualification() {
        if (this.qualification == null) {
            return false;
        }
        for (PractitionerQualificationComponent item : this.qualification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PractitionerQualificationComponent addQualification() {
        PractitionerQualificationComponent t = new PractitionerQualificationComponent();
        if (this.qualification == null) {
            this.qualification = new ArrayList<PractitionerQualificationComponent>();
        }
        this.qualification.add(t);
        return t;
    }

    public Practitioner addQualification(PractitionerQualificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.qualification == null) {
            this.qualification = new ArrayList<PractitionerQualificationComponent>();
        }
        this.qualification.add(t);
        return this;
    }

    public List<CodeableConcept> getCommunication() {
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        return this.communication;
    }

    public boolean hasCommunication() {
        if (this.communication == null) {
            return false;
        }
        for (CodeableConcept item : this.communication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCommunication() {
        CodeableConcept t = new CodeableConcept();
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        this.communication.add(t);
        return t;
    }

    public Practitioner addCommunication(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        this.communication.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "An identifier that applies to this person in this role.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("active", "boolean", "Whether this practitioner's record is in active use.", 0, Integer.MAX_VALUE, this.active));
        childrenList.add(new Property(SP_NAME, "HumanName", "The name(s) associated with the practitioner.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_TELECOM, "ContactPoint", "A contact detail for the practitioner, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property(SP_ADDRESS, "Address", "Address(es) of the practitioner that are not role specific (typically home address). \nWork addresses are not typically entered in this property as they are usually role dependent.", 0, Integer.MAX_VALUE, this.address));
        childrenList.add(new Property(SP_GENDER, "code", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        childrenList.add(new Property("birthDate", "date", "The date of birth for the practitioner.", 0, Integer.MAX_VALUE, this.birthDate));
        childrenList.add(new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo));
        childrenList.add(new Property("practitionerRole", "", "The list of roles/organizations that the practitioner is associated with.", 0, Integer.MAX_VALUE, this.practitionerRole));
        childrenList.add(new Property("qualification", "", "Qualifications obtained by training and certification.", 0, Integer.MAX_VALUE, this.qualification));
        childrenList.add(new Property(SP_COMMUNICATION, "CodeableConcept", "A language the practitioner is able to use in patient communication.", 0, Integer.MAX_VALUE, this.communication));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -1147692044: {
                return this.address == null ? new Base[]{} : this.address.toArray(new Base[this.address.size()]);
            }
            case -1249512767: {
                Base[] baseArray;
                if (this.gender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.gender;
                }
                return baseArray;
            }
            case -1210031859: {
                Base[] baseArray;
                if (this.birthDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.birthDate;
                }
                return baseArray;
            }
            case 106642994: {
                return this.photo == null ? new Base[]{} : this.photo.toArray(new Base[this.photo.size()]);
            }
            case 221717168: {
                return this.practitionerRole == null ? new Base[]{} : this.practitionerRole.toArray(new Base[this.practitionerRole.size()]);
            }
            case -631333393: {
                return this.qualification == null ? new Base[]{} : this.qualification.toArray(new Base[this.qualification.size()]);
            }
            case -1035284522: {
                return this.communication == null ? new Base[]{} : this.communication.toArray(new Base[this.communication.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                break;
            }
            case 3373707: {
                this.getName().add(this.castToHumanName(value));
                break;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                break;
            }
            case -1147692044: {
                this.getAddress().add(this.castToAddress(value));
                break;
            }
            case -1249512767: {
                this.gender = new Enumerations.AdministrativeGenderEnumFactory().fromType(value);
                break;
            }
            case -1210031859: {
                this.birthDate = this.castToDate(value);
                break;
            }
            case 106642994: {
                this.getPhoto().add(this.castToAttachment(value));
                break;
            }
            case 221717168: {
                this.getPractitionerRole().add((PractitionerPractitionerRoleComponent)value);
                break;
            }
            case -631333393: {
                this.getQualification().add((PractitionerQualificationComponent)value);
                break;
            }
            case -1035284522: {
                this.getCommunication().add(this.castToCodeableConcept(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("active")) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_NAME)) {
            this.getName().add(this.castToHumanName(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(this.castToAddress(value));
        } else if (name.equals(SP_GENDER)) {
            this.gender = new Enumerations.AdministrativeGenderEnumFactory().fromType(value);
        } else if (name.equals("birthDate")) {
            this.birthDate = this.castToDate(value);
        } else if (name.equals("photo")) {
            this.getPhoto().add(this.castToAttachment(value));
        } else if (name.equals("practitionerRole")) {
            this.getPractitionerRole().add((PractitionerPractitionerRoleComponent)value);
        } else if (name.equals("qualification")) {
            this.getQualification().add((PractitionerQualificationComponent)value);
        } else if (name.equals(SP_COMMUNICATION)) {
            this.getCommunication().add(this.castToCodeableConcept(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                throw new FHIRException("Cannot make property active as it is not a complex type");
            }
            case 3373707: {
                return this.addName();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -1147692044: {
                return this.addAddress();
            }
            case -1249512767: {
                throw new FHIRException("Cannot make property gender as it is not a complex type");
            }
            case -1210031859: {
                throw new FHIRException("Cannot make property birthDate as it is not a complex type");
            }
            case 106642994: {
                return this.addPhoto();
            }
            case 221717168: {
                return this.addPractitionerRole();
            }
            case -631333393: {
                return this.addQualification();
            }
            case -1035284522: {
                return this.addCommunication();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("active")) {
            throw new FHIRException("Cannot call addChild on a singleton property Practitioner.active");
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals(SP_GENDER)) {
            throw new FHIRException("Cannot call addChild on a singleton property Practitioner.gender");
        }
        if (name.equals("birthDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Practitioner.birthDate");
        }
        if (name.equals("photo")) {
            return this.addPhoto();
        }
        if (name.equals("practitionerRole")) {
            return this.addPractitionerRole();
        }
        if (name.equals("qualification")) {
            return this.addQualification();
        }
        if (name.equals(SP_COMMUNICATION)) {
            return this.addCommunication();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Practitioner";
    }

    @Override
    public Practitioner copy() {
        Practitioner dst = new Practitioner();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        BooleanType booleanType = dst.active = this.active == null ? null : this.active.copy();
        if (this.name != null) {
            dst.name = new ArrayList<HumanName>();
            for (HumanName humanName : this.name) {
                dst.name.add(humanName.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        dst.gender = this.gender == null ? null : this.gender.copy();
        DateType dateType = dst.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        if (this.photo != null) {
            dst.photo = new ArrayList<Attachment>();
            for (Attachment attachment : this.photo) {
                dst.photo.add(attachment.copy());
            }
        }
        if (this.practitionerRole != null) {
            dst.practitionerRole = new ArrayList<PractitionerPractitionerRoleComponent>();
            for (PractitionerPractitionerRoleComponent practitionerPractitionerRoleComponent : this.practitionerRole) {
                dst.practitionerRole.add(practitionerPractitionerRoleComponent.copy());
            }
        }
        if (this.qualification != null) {
            dst.qualification = new ArrayList<PractitionerQualificationComponent>();
            for (PractitionerQualificationComponent practitionerQualificationComponent : this.qualification) {
                dst.qualification.add(practitionerQualificationComponent.copy());
            }
        }
        if (this.communication != null) {
            dst.communication = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.communication) {
                dst.communication.add(codeableConcept.copy());
            }
        }
        return dst;
    }

    protected Practitioner typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Practitioner)) {
            return false;
        }
        Practitioner o = (Practitioner)other;
        return Practitioner.compareDeep(this.identifier, o.identifier, true) && Practitioner.compareDeep(this.active, o.active, true) && Practitioner.compareDeep(this.name, o.name, true) && Practitioner.compareDeep(this.telecom, o.telecom, true) && Practitioner.compareDeep(this.address, o.address, true) && Practitioner.compareDeep(this.gender, o.gender, true) && Practitioner.compareDeep(this.birthDate, o.birthDate, true) && Practitioner.compareDeep(this.photo, o.photo, true) && Practitioner.compareDeep(this.practitionerRole, o.practitionerRole, true) && Practitioner.compareDeep(this.qualification, o.qualification, true) && Practitioner.compareDeep(this.communication, o.communication, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Practitioner)) {
            return false;
        }
        Practitioner o = (Practitioner)other;
        return Practitioner.compareValues(this.active, o.active, true) && Practitioner.compareValues(this.gender, o.gender, true) && Practitioner.compareValues(this.birthDate, o.birthDate, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.active != null && !this.active.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.address != null && !this.address.isEmpty() || this.gender != null && !this.gender.isEmpty() || this.birthDate != null && !this.birthDate.isEmpty() || this.photo != null && !this.photo.isEmpty() || this.practitionerRole != null && !this.practitionerRole.isEmpty() || this.qualification != null && !this.qualification.isEmpty() || this.communication != null && !this.communication.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Practitioner;
    }

    @Block
    public static class PractitionerQualificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An identifier for this qualification for the practitioner", formalDefinition="An identifier that applies to this person's qualification in this role.")
        protected List<Identifier> identifier;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Coded representation of the qualification", formalDefinition="Coded representation of the qualification.")
        protected CodeableConcept code;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period during which the qualification is valid", formalDefinition="Period during which the qualification is valid.")
        protected Period period;
        @Child(name="issuer", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization that regulates and issues the qualification", formalDefinition="Organization that regulates and issues the qualification.")
        protected Reference issuer;
        protected Organization issuerTarget;
        private static final long serialVersionUID = 1095219071L;

        public PractitionerQualificationComponent() {
        }

        public PractitionerQualificationComponent(CodeableConcept code) {
            this.code = code;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public PractitionerQualificationComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerQualificationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public PractitionerQualificationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerQualificationComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public PractitionerQualificationComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public Reference getIssuer() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerQualificationComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new Reference();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public PractitionerQualificationComponent setIssuer(Reference value) {
            this.issuer = value;
            return this;
        }

        public Organization getIssuerTarget() {
            if (this.issuerTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerQualificationComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuerTarget = new Organization();
                }
            }
            return this.issuerTarget;
        }

        public PractitionerQualificationComponent setIssuerTarget(Organization value) {
            this.issuerTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Practitioner.SP_IDENTIFIER, "Identifier", "An identifier that applies to this person's qualification in this role.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("code", "CodeableConcept", "Coded representation of the qualification.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("period", "Period", "Period during which the qualification is valid.", 0, Integer.MAX_VALUE, this.period));
            childrenList.add(new Property("issuer", "Reference(Organization)", "Organization that regulates and issues the qualification.", 0, Integer.MAX_VALUE, this.issuer));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.issuer;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    break;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    break;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    break;
                }
                case -1179159879: {
                    this.issuer = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Practitioner.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("issuer")) {
                this.issuer = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case -1179159879: {
                    return this.getIssuer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Practitioner.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("issuer")) {
                this.issuer = new Reference();
                return this.issuer;
            }
            return super.addChild(name);
        }

        @Override
        public PractitionerQualificationComponent copy() {
            PractitionerQualificationComponent dst = new PractitionerQualificationComponent();
            this.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
            dst.code = this.code == null ? null : this.code.copy();
            dst.period = this.period == null ? null : this.period.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PractitionerQualificationComponent)) {
                return false;
            }
            PractitionerQualificationComponent o = (PractitionerQualificationComponent)other;
            return PractitionerQualificationComponent.compareDeep(this.identifier, o.identifier, true) && PractitionerQualificationComponent.compareDeep(this.code, o.code, true) && PractitionerQualificationComponent.compareDeep(this.period, o.period, true) && PractitionerQualificationComponent.compareDeep(this.issuer, o.issuer, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PractitionerQualificationComponent)) {
                return false;
            }
            PractitionerQualificationComponent o = (PractitionerQualificationComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.code != null && !this.code.isEmpty() || this.period != null && !this.period.isEmpty() || this.issuer != null && !this.issuer.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Practitioner.qualification";
        }
    }

    @Block
    public static class PractitionerPractitionerRoleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="organization", type={Organization.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization where the roles are performed", formalDefinition="The organization where the Practitioner performs the roles associated.")
        protected Reference organization;
        protected Organization organizationTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Roles which this practitioner may perform", formalDefinition="Roles which this practitioner is authorized to perform for the organization.")
        protected CodeableConcept role;
        @Child(name="specialty", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Specific specialty of the practitioner", formalDefinition="Specific specialty of the practitioner.")
        protected List<CodeableConcept> specialty;
        @Child(name="identifier", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Business Identifiers that are specific to a role/location", formalDefinition="Business Identifiers that are specific to a role/location.")
        protected List<Identifier> identifier;
        @Child(name="telecom", type={ContactPoint.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details that are specific to the role/location/service", formalDefinition="Contact details that are specific to the role/location/service.")
        protected List<ContactPoint> telecom;
        @Child(name="period", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The period during which the practitioner is authorized to perform in these role(s)", formalDefinition="The period during which the person is authorized to act as a practitioner in these role(s) for the organization.")
        protected Period period;
        @Child(name="location", type={Location.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The location(s) at which this practitioner provides care", formalDefinition="The location(s) at which this practitioner provides care.")
        protected List<Reference> location;
        protected List<Location> locationTarget;
        @Child(name="healthcareService", type={HealthcareService.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s)", formalDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s).")
        protected List<Reference> healthcareService;
        protected List<HealthcareService> healthcareServiceTarget;
        private static final long serialVersionUID = -2082448551L;

        public Reference getOrganization() {
            if (this.organization == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerPractitionerRoleComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organization = new Reference();
                }
            }
            return this.organization;
        }

        public boolean hasOrganization() {
            return this.organization != null && !this.organization.isEmpty();
        }

        public PractitionerPractitionerRoleComponent setOrganization(Reference value) {
            this.organization = value;
            return this;
        }

        public Organization getOrganizationTarget() {
            if (this.organizationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerPractitionerRoleComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organizationTarget = new Organization();
                }
            }
            return this.organizationTarget;
        }

        public PractitionerPractitionerRoleComponent setOrganizationTarget(Organization value) {
            this.organizationTarget = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerPractitionerRoleComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public PractitionerPractitionerRoleComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public List<CodeableConcept> getSpecialty() {
            if (this.specialty == null) {
                this.specialty = new ArrayList<CodeableConcept>();
            }
            return this.specialty;
        }

        public boolean hasSpecialty() {
            if (this.specialty == null) {
                return false;
            }
            for (CodeableConcept item : this.specialty) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSpecialty() {
            CodeableConcept t = new CodeableConcept();
            if (this.specialty == null) {
                this.specialty = new ArrayList<CodeableConcept>();
            }
            this.specialty.add(t);
            return t;
        }

        public PractitionerPractitionerRoleComponent addSpecialty(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.specialty == null) {
                this.specialty = new ArrayList<CodeableConcept>();
            }
            this.specialty.add(t);
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public PractitionerPractitionerRoleComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public PractitionerPractitionerRoleComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerPractitionerRoleComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public PractitionerPractitionerRoleComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<Reference> getLocation() {
            if (this.location == null) {
                this.location = new ArrayList<Reference>();
            }
            return this.location;
        }

        public boolean hasLocation() {
            if (this.location == null) {
                return false;
            }
            for (Reference item : this.location) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addLocation() {
            Reference t = new Reference();
            if (this.location == null) {
                this.location = new ArrayList<Reference>();
            }
            this.location.add(t);
            return t;
        }

        public PractitionerPractitionerRoleComponent addLocation(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.location == null) {
                this.location = new ArrayList<Reference>();
            }
            this.location.add(t);
            return this;
        }

        public List<Location> getLocationTarget() {
            if (this.locationTarget == null) {
                this.locationTarget = new ArrayList<Location>();
            }
            return this.locationTarget;
        }

        public Location addLocationTarget() {
            Location r = new Location();
            if (this.locationTarget == null) {
                this.locationTarget = new ArrayList<Location>();
            }
            this.locationTarget.add(r);
            return r;
        }

        public List<Reference> getHealthcareService() {
            if (this.healthcareService == null) {
                this.healthcareService = new ArrayList<Reference>();
            }
            return this.healthcareService;
        }

        public boolean hasHealthcareService() {
            if (this.healthcareService == null) {
                return false;
            }
            for (Reference item : this.healthcareService) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addHealthcareService() {
            Reference t = new Reference();
            if (this.healthcareService == null) {
                this.healthcareService = new ArrayList<Reference>();
            }
            this.healthcareService.add(t);
            return t;
        }

        public PractitionerPractitionerRoleComponent addHealthcareService(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.healthcareService == null) {
                this.healthcareService = new ArrayList<Reference>();
            }
            this.healthcareService.add(t);
            return this;
        }

        public List<HealthcareService> getHealthcareServiceTarget() {
            if (this.healthcareServiceTarget == null) {
                this.healthcareServiceTarget = new ArrayList<HealthcareService>();
            }
            return this.healthcareServiceTarget;
        }

        public HealthcareService addHealthcareServiceTarget() {
            HealthcareService r = new HealthcareService();
            if (this.healthcareServiceTarget == null) {
                this.healthcareServiceTarget = new ArrayList<HealthcareService>();
            }
            this.healthcareServiceTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Practitioner.SP_ORGANIZATION, "Reference(Organization)", "The organization where the Practitioner performs the roles associated.", 0, Integer.MAX_VALUE, this.organization));
            childrenList.add(new Property(Practitioner.SP_ROLE, "CodeableConcept", "Roles which this practitioner is authorized to perform for the organization.", 0, Integer.MAX_VALUE, this.role));
            childrenList.add(new Property(Practitioner.SP_SPECIALTY, "CodeableConcept", "Specific specialty of the practitioner.", 0, Integer.MAX_VALUE, this.specialty));
            childrenList.add(new Property(Practitioner.SP_IDENTIFIER, "Identifier", "Business Identifiers that are specific to a role/location.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(Practitioner.SP_TELECOM, "ContactPoint", "Contact details that are specific to the role/location/service.", 0, Integer.MAX_VALUE, this.telecom));
            childrenList.add(new Property("period", "Period", "The period during which the person is authorized to act as a practitioner in these role(s) for the organization.", 0, Integer.MAX_VALUE, this.period));
            childrenList.add(new Property(Practitioner.SP_LOCATION, "Reference(Location)", "The location(s) at which this practitioner provides care.", 0, Integer.MAX_VALUE, this.location));
            childrenList.add(new Property("healthcareService", "Reference(HealthcareService)", "The list of healthcare services that this worker provides for this role's Organization/Location(s).", 0, Integer.MAX_VALUE, this.healthcareService));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1178922291: {
                    Base[] baseArray;
                    if (this.organization == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.organization;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
                case -1694759682: {
                    return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
                }
                case 1289661064: {
                    return this.healthcareService == null ? new Base[]{} : this.healthcareService.toArray(new Base[this.healthcareService.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1178922291: {
                    this.organization = this.castToReference(value);
                    break;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    break;
                }
                case -1694759682: {
                    this.getSpecialty().add(this.castToCodeableConcept(value));
                    break;
                }
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    break;
                }
                case 1901043637: {
                    this.getLocation().add(this.castToReference(value));
                    break;
                }
                case 1289661064: {
                    this.getHealthcareService().add(this.castToReference(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Practitioner.SP_ORGANIZATION)) {
                this.organization = this.castToReference(value);
            } else if (name.equals(Practitioner.SP_ROLE)) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals(Practitioner.SP_SPECIALTY)) {
                this.getSpecialty().add(this.castToCodeableConcept(value));
            } else if (name.equals(Practitioner.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals(Practitioner.SP_TELECOM)) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else if (name.equals(Practitioner.SP_LOCATION)) {
                this.getLocation().add(this.castToReference(value));
            } else if (name.equals("healthcareService")) {
                this.getHealthcareService().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1178922291: {
                    return this.getOrganization();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -1694759682: {
                    return this.addSpecialty();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
                case -1429363305: {
                    return this.addTelecom();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 1901043637: {
                    return this.addLocation();
                }
                case 1289661064: {
                    return this.addHealthcareService();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Practitioner.SP_ORGANIZATION)) {
                this.organization = new Reference();
                return this.organization;
            }
            if (name.equals(Practitioner.SP_ROLE)) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals(Practitioner.SP_SPECIALTY)) {
                return this.addSpecialty();
            }
            if (name.equals(Practitioner.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals(Practitioner.SP_TELECOM)) {
                return this.addTelecom();
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals(Practitioner.SP_LOCATION)) {
                return this.addLocation();
            }
            if (name.equals("healthcareService")) {
                return this.addHealthcareService();
            }
            return super.addChild(name);
        }

        @Override
        public PractitionerPractitionerRoleComponent copy() {
            PractitionerPractitionerRoleComponent dst = new PractitionerPractitionerRoleComponent();
            this.copyValues(dst);
            dst.organization = this.organization == null ? null : this.organization.copy();
            CodeableConcept codeableConcept = dst.role = this.role == null ? null : this.role.copy();
            if (this.specialty != null) {
                dst.specialty = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.specialty) {
                    dst.specialty.add(codeableConcept2.copy());
                }
            }
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint contactPoint : this.telecom) {
                    dst.telecom.add(contactPoint.copy());
                }
            }
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.location != null) {
                dst.location = new ArrayList<Reference>();
                for (Reference reference : this.location) {
                    dst.location.add(reference.copy());
                }
            }
            if (this.healthcareService != null) {
                dst.healthcareService = new ArrayList<Reference>();
                for (Reference reference : this.healthcareService) {
                    dst.healthcareService.add(reference.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PractitionerPractitionerRoleComponent)) {
                return false;
            }
            PractitionerPractitionerRoleComponent o = (PractitionerPractitionerRoleComponent)other;
            return PractitionerPractitionerRoleComponent.compareDeep(this.organization, o.organization, true) && PractitionerPractitionerRoleComponent.compareDeep(this.role, o.role, true) && PractitionerPractitionerRoleComponent.compareDeep(this.specialty, o.specialty, true) && PractitionerPractitionerRoleComponent.compareDeep(this.identifier, o.identifier, true) && PractitionerPractitionerRoleComponent.compareDeep(this.telecom, o.telecom, true) && PractitionerPractitionerRoleComponent.compareDeep(this.period, o.period, true) && PractitionerPractitionerRoleComponent.compareDeep(this.location, o.location, true) && PractitionerPractitionerRoleComponent.compareDeep(this.healthcareService, o.healthcareService, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PractitionerPractitionerRoleComponent)) {
                return false;
            }
            PractitionerPractitionerRoleComponent o = (PractitionerPractitionerRoleComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.role != null && !this.role.isEmpty() || this.specialty != null && !this.specialty.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.period != null && !this.period.isEmpty() || this.location != null && !this.location.isEmpty() || this.healthcareService != null && !this.healthcareService.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Practitioner.practitionerRole";
        }
    }
}

