/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AllergyIntolerance", profile="http://hl7.org/fhir/Profile/AllergyIntolerance")
public class AllergyIntolerance
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External ids for this item", formalDefinition="This records identifiers associated with this allergy/intolerance concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | unconfirmed | confirmed | inactive | resolved | refuted | entered-in-error", formalDefinition="Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified Substance.")
    protected Enumeration<AllergyIntoleranceStatus> status;
    @Child(name="type", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="allergy | intolerance - Underlying mechanism (if known)", formalDefinition="Identification of the underlying physiological mechanism for the reaction risk.")
    protected Enumeration<AllergyIntoleranceType> type;
    @Child(name="category", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="food | medication | environment | other - Category of Substance", formalDefinition="Category of the identified Substance.")
    protected Enumeration<AllergyIntoleranceCategory> category;
    @Child(name="criticality", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="low | high | unable-to-assess", formalDefinition="Estimate of the potential clinical harm, or seriousness, of the reaction to the identified Substance.")
    protected Enumeration<AllergyIntoleranceCriticality> criticality;
    @Child(name="substance", type={CodeableConcept.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Substance, (or class) considered to be responsible for risk", formalDefinition="Identification of a substance, or a class of substances, that is considered to be responsible for the adverse reaction risk.")
    protected CodeableConcept substance;
    @Child(name="patient", type={Patient.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the sensitivity is for", formalDefinition="The patient who has the allergy or intolerance.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="recordedDate", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When recorded", formalDefinition="Date when the sensitivity was recorded.")
    protected DateTimeType recordedDate;
    @Child(name="recorder", type={Practitioner.class, Patient.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who recorded the sensitivity", formalDefinition="Individual who recorded the record and takes responsibility for its content.")
    protected Reference recorder;
    protected Resource recorderTarget;
    @Child(name="reporter", type={Patient.class, RelatedPerson.class, Practitioner.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Source of the information about the allergy", formalDefinition="The source of the information about the allergy that is recorded.")
    protected Reference reporter;
    protected Resource reporterTarget;
    @Child(name="onset", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date(/time) when manifestations showed", formalDefinition="Record of the date and/or time of the onset of the Allergy or Intolerance.")
    protected DateTimeType onset;
    @Child(name="lastOccurence", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date(/time) of last known occurrence of a reaction", formalDefinition="Represents the date and/or time of the last known occurrence of a reaction event.")
    protected DateTimeType lastOccurence;
    @Child(name="note", type={Annotation.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional text not captured in other fields", formalDefinition="Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.")
    protected List<Annotation> note;
    @Child(name="reaction", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Adverse Reaction Events linked to exposure to substance", formalDefinition="Details about each adverse reaction event linked to exposure to the identified Substance.")
    protected List<AllergyIntoleranceReactionComponent> reaction;
    private static final long serialVersionUID = 278089117L;
    @SearchParamDefinition(name="status", path="AllergyIntolerance.status", description="active | unconfirmed | confirmed | inactive | resolved | refuted | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="onset", path="AllergyIntolerance.reaction.onset", description="Date(/time) when manifestations showed", type="date")
    public static final String SP_ONSET = "onset";
    public static final DateClientParam ONSET = new DateClientParam("onset");
    @SearchParamDefinition(name="last-date", path="AllergyIntolerance.lastOccurence", description="Date(/time) of last known occurrence of a reaction", type="date")
    public static final String SP_LAST_DATE = "last-date";
    public static final DateClientParam LAST_DATE = new DateClientParam("last-date");
    @SearchParamDefinition(name="severity", path="AllergyIntolerance.reaction.severity", description="mild | moderate | severe (of event as a whole)", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="type", path="AllergyIntolerance.type", description="allergy | intolerance - Underlying mechanism (if known)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate", description="When recorded", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="reporter", path="AllergyIntolerance.reporter", description="Source of the information about the allergy", type="reference")
    public static final String SP_REPORTER = "reporter";
    public static final ReferenceClientParam REPORTER = new ReferenceClientParam("reporter");
    public static final Include INCLUDE_REPORTER = new Include("AllergyIntolerance:reporter").toLocked();
    @SearchParamDefinition(name="substance", path="AllergyIntolerance.substance | AllergyIntolerance.reaction.substance", description="Substance, (or class) considered to be responsible for risk", type="token")
    public static final String SP_SUBSTANCE = "substance";
    public static final TokenClientParam SUBSTANCE = new TokenClientParam("substance");
    @SearchParamDefinition(name="criticality", path="AllergyIntolerance.criticality", description="low | high | unable-to-assess", type="token")
    public static final String SP_CRITICALITY = "criticality";
    public static final TokenClientParam CRITICALITY = new TokenClientParam("criticality");
    @SearchParamDefinition(name="category", path="AllergyIntolerance.category", description="food | medication | environment | other - Category of Substance", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient", description="Who the sensitivity is for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AllergyIntolerance:patient").toLocked();
    @SearchParamDefinition(name="recorder", path="AllergyIntolerance.recorder", description="Who recorded the sensitivity", type="reference")
    public static final String SP_RECORDER = "recorder";
    public static final ReferenceClientParam RECORDER = new ReferenceClientParam("recorder");
    public static final Include INCLUDE_RECORDER = new Include("AllergyIntolerance:recorder").toLocked();
    @SearchParamDefinition(name="route", path="AllergyIntolerance.reaction.exposureRoute", description="How the subject was exposed to the substance", type="token")
    public static final String SP_ROUTE = "route";
    public static final TokenClientParam ROUTE = new TokenClientParam("route");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier", description="External ids for this item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="manifestation", path="AllergyIntolerance.reaction.manifestation", description="Clinical symptoms/signs associated with the Event", type="token")
    public static final String SP_MANIFESTATION = "manifestation";
    public static final TokenClientParam MANIFESTATION = new TokenClientParam("manifestation");

    public AllergyIntolerance() {
    }

    public AllergyIntolerance(CodeableConcept substance, Reference patient) {
        this.substance = substance;
        this.patient = patient;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public AllergyIntolerance addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<AllergyIntoleranceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<AllergyIntoleranceStatus>(new AllergyIntoleranceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public AllergyIntolerance setStatusElement(Enumeration<AllergyIntoleranceStatus> value) {
        this.status = value;
        return this;
    }

    public AllergyIntoleranceStatus getStatus() {
        return this.status == null ? null : (AllergyIntoleranceStatus)((Object)this.status.getValue());
    }

    public AllergyIntolerance setStatus(AllergyIntoleranceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<AllergyIntoleranceStatus>(new AllergyIntoleranceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<AllergyIntoleranceType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<AllergyIntoleranceType>(new AllergyIntoleranceTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public AllergyIntolerance setTypeElement(Enumeration<AllergyIntoleranceType> value) {
        this.type = value;
        return this;
    }

    public AllergyIntoleranceType getType() {
        return this.type == null ? null : (AllergyIntoleranceType)((Object)this.type.getValue());
    }

    public AllergyIntolerance setType(AllergyIntoleranceType value) {
        if (value == null) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new Enumeration<AllergyIntoleranceType>(new AllergyIntoleranceTypeEnumFactory());
            }
            this.type.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<AllergyIntoleranceCategory> getCategoryElement() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new Enumeration<AllergyIntoleranceCategory>(new AllergyIntoleranceCategoryEnumFactory());
            }
        }
        return this.category;
    }

    public boolean hasCategoryElement() {
        return this.category != null && !this.category.isEmpty();
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public AllergyIntolerance setCategoryElement(Enumeration<AllergyIntoleranceCategory> value) {
        this.category = value;
        return this;
    }

    public AllergyIntoleranceCategory getCategory() {
        return this.category == null ? null : (AllergyIntoleranceCategory)((Object)this.category.getValue());
    }

    public AllergyIntolerance setCategory(AllergyIntoleranceCategory value) {
        if (value == null) {
            this.category = null;
        } else {
            if (this.category == null) {
                this.category = new Enumeration<AllergyIntoleranceCategory>(new AllergyIntoleranceCategoryEnumFactory());
            }
            this.category.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<AllergyIntoleranceCriticality> getCriticalityElement() {
        if (this.criticality == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.criticality");
            }
            if (Configuration.doAutoCreate()) {
                this.criticality = new Enumeration<AllergyIntoleranceCriticality>(new AllergyIntoleranceCriticalityEnumFactory());
            }
        }
        return this.criticality;
    }

    public boolean hasCriticalityElement() {
        return this.criticality != null && !this.criticality.isEmpty();
    }

    public boolean hasCriticality() {
        return this.criticality != null && !this.criticality.isEmpty();
    }

    public AllergyIntolerance setCriticalityElement(Enumeration<AllergyIntoleranceCriticality> value) {
        this.criticality = value;
        return this;
    }

    public AllergyIntoleranceCriticality getCriticality() {
        return this.criticality == null ? null : (AllergyIntoleranceCriticality)((Object)this.criticality.getValue());
    }

    public AllergyIntolerance setCriticality(AllergyIntoleranceCriticality value) {
        if (value == null) {
            this.criticality = null;
        } else {
            if (this.criticality == null) {
                this.criticality = new Enumeration<AllergyIntoleranceCriticality>(new AllergyIntoleranceCriticalityEnumFactory());
            }
            this.criticality.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getSubstance() {
        if (this.substance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.substance");
            }
            if (Configuration.doAutoCreate()) {
                this.substance = new CodeableConcept();
            }
        }
        return this.substance;
    }

    public boolean hasSubstance() {
        return this.substance != null && !this.substance.isEmpty();
    }

    public AllergyIntolerance setSubstance(CodeableConcept value) {
        this.substance = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public AllergyIntolerance setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public AllergyIntolerance setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getRecordedDateElement() {
        if (this.recordedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.recordedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.recordedDate = new DateTimeType();
            }
        }
        return this.recordedDate;
    }

    public boolean hasRecordedDateElement() {
        return this.recordedDate != null && !this.recordedDate.isEmpty();
    }

    public boolean hasRecordedDate() {
        return this.recordedDate != null && !this.recordedDate.isEmpty();
    }

    public AllergyIntolerance setRecordedDateElement(DateTimeType value) {
        this.recordedDate = value;
        return this;
    }

    public Date getRecordedDate() {
        return this.recordedDate == null ? null : (Date)this.recordedDate.getValue();
    }

    public AllergyIntolerance setRecordedDate(Date value) {
        if (value == null) {
            this.recordedDate = null;
        } else {
            if (this.recordedDate == null) {
                this.recordedDate = new DateTimeType();
            }
            this.recordedDate.setValue(value);
        }
        return this;
    }

    public Reference getRecorder() {
        if (this.recorder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorder = new Reference();
            }
        }
        return this.recorder;
    }

    public boolean hasRecorder() {
        return this.recorder != null && !this.recorder.isEmpty();
    }

    public AllergyIntolerance setRecorder(Reference value) {
        this.recorder = value;
        return this;
    }

    public Resource getRecorderTarget() {
        return this.recorderTarget;
    }

    public AllergyIntolerance setRecorderTarget(Resource value) {
        this.recorderTarget = value;
        return this;
    }

    public Reference getReporter() {
        if (this.reporter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.reporter");
            }
            if (Configuration.doAutoCreate()) {
                this.reporter = new Reference();
            }
        }
        return this.reporter;
    }

    public boolean hasReporter() {
        return this.reporter != null && !this.reporter.isEmpty();
    }

    public AllergyIntolerance setReporter(Reference value) {
        this.reporter = value;
        return this;
    }

    public Resource getReporterTarget() {
        return this.reporterTarget;
    }

    public AllergyIntolerance setReporterTarget(Resource value) {
        this.reporterTarget = value;
        return this;
    }

    public DateTimeType getOnsetElement() {
        if (this.onset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.onset");
            }
            if (Configuration.doAutoCreate()) {
                this.onset = new DateTimeType();
            }
        }
        return this.onset;
    }

    public boolean hasOnsetElement() {
        return this.onset != null && !this.onset.isEmpty();
    }

    public boolean hasOnset() {
        return this.onset != null && !this.onset.isEmpty();
    }

    public AllergyIntolerance setOnsetElement(DateTimeType value) {
        this.onset = value;
        return this;
    }

    public Date getOnset() {
        return this.onset == null ? null : (Date)this.onset.getValue();
    }

    public AllergyIntolerance setOnset(Date value) {
        if (value == null) {
            this.onset = null;
        } else {
            if (this.onset == null) {
                this.onset = new DateTimeType();
            }
            this.onset.setValue(value);
        }
        return this;
    }

    public DateTimeType getLastOccurenceElement() {
        if (this.lastOccurence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.lastOccurence");
            }
            if (Configuration.doAutoCreate()) {
                this.lastOccurence = new DateTimeType();
            }
        }
        return this.lastOccurence;
    }

    public boolean hasLastOccurenceElement() {
        return this.lastOccurence != null && !this.lastOccurence.isEmpty();
    }

    public boolean hasLastOccurence() {
        return this.lastOccurence != null && !this.lastOccurence.isEmpty();
    }

    public AllergyIntolerance setLastOccurenceElement(DateTimeType value) {
        this.lastOccurence = value;
        return this;
    }

    public Date getLastOccurence() {
        return this.lastOccurence == null ? null : (Date)this.lastOccurence.getValue();
    }

    public AllergyIntolerance setLastOccurence(Date value) {
        if (value == null) {
            this.lastOccurence = null;
        } else {
            if (this.lastOccurence == null) {
                this.lastOccurence = new DateTimeType();
            }
            this.lastOccurence.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public AllergyIntolerance addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public List<AllergyIntoleranceReactionComponent> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        return this.reaction;
    }

    public boolean hasReaction() {
        if (this.reaction == null) {
            return false;
        }
        for (AllergyIntoleranceReactionComponent item : this.reaction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AllergyIntoleranceReactionComponent addReaction() {
        AllergyIntoleranceReactionComponent t = new AllergyIntoleranceReactionComponent();
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        this.reaction.add(t);
        return t;
    }

    public AllergyIntolerance addReaction(AllergyIntoleranceReactionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        this.reaction.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this allergy/intolerance concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified Substance.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_TYPE, "code", "Identification of the underlying physiological mechanism for the reaction risk.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_CATEGORY, "code", "Category of the identified Substance.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_CRITICALITY, "code", "Estimate of the potential clinical harm, or seriousness, of the reaction to the identified Substance.", 0, Integer.MAX_VALUE, this.criticality));
        childrenList.add(new Property(SP_SUBSTANCE, "CodeableConcept", "Identification of a substance, or a class of substances, that is considered to be responsible for the adverse reaction risk.", 0, Integer.MAX_VALUE, this.substance));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who has the allergy or intolerance.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("recordedDate", "dateTime", "Date when the sensitivity was recorded.", 0, Integer.MAX_VALUE, this.recordedDate));
        childrenList.add(new Property(SP_RECORDER, "Reference(Practitioner|Patient)", "Individual who recorded the record and takes responsibility for its content.", 0, Integer.MAX_VALUE, this.recorder));
        childrenList.add(new Property(SP_REPORTER, "Reference(Patient|RelatedPerson|Practitioner)", "The source of the information about the allergy that is recorded.", 0, Integer.MAX_VALUE, this.reporter));
        childrenList.add(new Property(SP_ONSET, "dateTime", "Record of the date and/or time of the onset of the Allergy or Intolerance.", 0, Integer.MAX_VALUE, this.onset));
        childrenList.add(new Property("lastOccurence", "dateTime", "Represents the date and/or time of the last known occurrence of a reaction event.", 0, Integer.MAX_VALUE, this.lastOccurence));
        childrenList.add(new Property("note", "Annotation", "Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("reaction", "", "Details about each adverse reaction event linked to exposure to the identified Substance.", 0, Integer.MAX_VALUE, this.reaction));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case -1608054609: {
                Base[] baseArray;
                if (this.criticality == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.criticality;
                }
                return baseArray;
            }
            case 530040176: {
                Base[] baseArray;
                if (this.substance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.substance;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.patient;
                }
                return baseArray;
            }
            case -1952893826: {
                Base[] baseArray;
                if (this.recordedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.recordedDate;
                }
                return baseArray;
            }
            case -799233858: {
                Base[] baseArray;
                if (this.recorder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.recorder;
                }
                return baseArray;
            }
            case -427039519: {
                Base[] baseArray;
                if (this.reporter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.reporter;
                }
                return baseArray;
            }
            case 105901603: {
                Base[] baseArray;
                if (this.onset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.onset;
                }
                return baseArray;
            }
            case 1307739841: {
                Base[] baseArray;
                if (this.lastOccurence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.lastOccurence;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -867509719: {
                return this.reaction == null ? new Base[]{} : this.reaction.toArray(new Base[this.reaction.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -892481550: {
                this.status = new AllergyIntoleranceStatusEnumFactory().fromType(value);
                break;
            }
            case 3575610: {
                this.type = new AllergyIntoleranceTypeEnumFactory().fromType(value);
                break;
            }
            case 50511102: {
                this.category = new AllergyIntoleranceCategoryEnumFactory().fromType(value);
                break;
            }
            case -1608054609: {
                this.criticality = new AllergyIntoleranceCriticalityEnumFactory().fromType(value);
                break;
            }
            case 530040176: {
                this.substance = this.castToCodeableConcept(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -1952893826: {
                this.recordedDate = this.castToDateTime(value);
                break;
            }
            case -799233858: {
                this.recorder = this.castToReference(value);
                break;
            }
            case -427039519: {
                this.reporter = this.castToReference(value);
                break;
            }
            case 105901603: {
                this.onset = this.castToDateTime(value);
                break;
            }
            case 1307739841: {
                this.lastOccurence = this.castToDateTime(value);
                break;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                break;
            }
            case -867509719: {
                this.getReaction().add((AllergyIntoleranceReactionComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new AllergyIntoleranceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = new AllergyIntoleranceTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = new AllergyIntoleranceCategoryEnumFactory().fromType(value);
        } else if (name.equals(SP_CRITICALITY)) {
            this.criticality = new AllergyIntoleranceCriticalityEnumFactory().fromType(value);
        } else if (name.equals(SP_SUBSTANCE)) {
            this.substance = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("recordedDate")) {
            this.recordedDate = this.castToDateTime(value);
        } else if (name.equals(SP_RECORDER)) {
            this.recorder = this.castToReference(value);
        } else if (name.equals(SP_REPORTER)) {
            this.reporter = this.castToReference(value);
        } else if (name.equals(SP_ONSET)) {
            this.onset = this.castToDateTime(value);
        } else if (name.equals("lastOccurence")) {
            this.lastOccurence = this.castToDateTime(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("reaction")) {
            this.getReaction().add((AllergyIntoleranceReactionComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case 50511102: {
                throw new FHIRException("Cannot make property category as it is not a complex type");
            }
            case -1608054609: {
                throw new FHIRException("Cannot make property criticality as it is not a complex type");
            }
            case 530040176: {
                return this.getSubstance();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1952893826: {
                throw new FHIRException("Cannot make property recordedDate as it is not a complex type");
            }
            case -799233858: {
                return this.getRecorder();
            }
            case -427039519: {
                return this.getReporter();
            }
            case 105901603: {
                throw new FHIRException("Cannot make property onset as it is not a complex type");
            }
            case 1307739841: {
                throw new FHIRException("Cannot make property lastOccurence as it is not a complex type");
            }
            case 3387378: {
                return this.addNote();
            }
            case -867509719: {
                return this.addReaction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.status");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.type");
        }
        if (name.equals(SP_CATEGORY)) {
            throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.category");
        }
        if (name.equals(SP_CRITICALITY)) {
            throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.criticality");
        }
        if (name.equals(SP_SUBSTANCE)) {
            this.substance = new CodeableConcept();
            return this.substance;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("recordedDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.recordedDate");
        }
        if (name.equals(SP_RECORDER)) {
            this.recorder = new Reference();
            return this.recorder;
        }
        if (name.equals(SP_REPORTER)) {
            this.reporter = new Reference();
            return this.reporter;
        }
        if (name.equals(SP_ONSET)) {
            throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.onset");
        }
        if (name.equals("lastOccurence")) {
            throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.lastOccurence");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("reaction")) {
            return this.addReaction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AllergyIntolerance";
    }

    @Override
    public AllergyIntolerance copy() {
        AllergyIntolerance dst = new AllergyIntolerance();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.criticality = this.criticality == null ? null : this.criticality.copy();
        dst.substance = this.substance == null ? null : this.substance.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.recordedDate = this.recordedDate == null ? null : this.recordedDate.copy();
        dst.recorder = this.recorder == null ? null : this.recorder.copy();
        dst.reporter = this.reporter == null ? null : this.reporter.copy();
        dst.onset = this.onset == null ? null : this.onset.copy();
        DateTimeType dateTimeType = dst.lastOccurence = this.lastOccurence == null ? null : this.lastOccurence.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.reaction != null) {
            dst.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
            for (AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : this.reaction) {
                dst.reaction.add(allergyIntoleranceReactionComponent.copy());
            }
        }
        return dst;
    }

    protected AllergyIntolerance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof AllergyIntolerance)) {
            return false;
        }
        AllergyIntolerance o = (AllergyIntolerance)other;
        return AllergyIntolerance.compareDeep(this.identifier, o.identifier, true) && AllergyIntolerance.compareDeep(this.status, o.status, true) && AllergyIntolerance.compareDeep(this.type, o.type, true) && AllergyIntolerance.compareDeep(this.category, o.category, true) && AllergyIntolerance.compareDeep(this.criticality, o.criticality, true) && AllergyIntolerance.compareDeep(this.substance, o.substance, true) && AllergyIntolerance.compareDeep(this.patient, o.patient, true) && AllergyIntolerance.compareDeep(this.recordedDate, o.recordedDate, true) && AllergyIntolerance.compareDeep(this.recorder, o.recorder, true) && AllergyIntolerance.compareDeep(this.reporter, o.reporter, true) && AllergyIntolerance.compareDeep(this.onset, o.onset, true) && AllergyIntolerance.compareDeep(this.lastOccurence, o.lastOccurence, true) && AllergyIntolerance.compareDeep(this.note, o.note, true) && AllergyIntolerance.compareDeep(this.reaction, o.reaction, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof AllergyIntolerance)) {
            return false;
        }
        AllergyIntolerance o = (AllergyIntolerance)other;
        return AllergyIntolerance.compareValues(this.status, o.status, true) && AllergyIntolerance.compareValues(this.type, o.type, true) && AllergyIntolerance.compareValues(this.category, o.category, true) && AllergyIntolerance.compareValues(this.criticality, o.criticality, true) && AllergyIntolerance.compareValues(this.recordedDate, o.recordedDate, true) && AllergyIntolerance.compareValues(this.onset, o.onset, true) && AllergyIntolerance.compareValues(this.lastOccurence, o.lastOccurence, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.type != null && !this.type.isEmpty() || this.category != null && !this.category.isEmpty() || this.criticality != null && !this.criticality.isEmpty() || this.substance != null && !this.substance.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.recordedDate != null && !this.recordedDate.isEmpty() || this.recorder != null && !this.recorder.isEmpty() || this.reporter != null && !this.reporter.isEmpty() || this.onset != null && !this.onset.isEmpty() || this.lastOccurence != null && !this.lastOccurence.isEmpty() || this.note != null && !this.note.isEmpty() || this.reaction != null && !this.reaction.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AllergyIntolerance;
    }

    @Block
    public static class AllergyIntoleranceReactionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific substance considered to be responsible for event", formalDefinition="Identification of the specific substance considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different to the substance identified as the cause of the risk, but must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite substance that includes the identified substance. It must be clinically safe to only process the AllergyIntolerance.substance and ignore the AllergyIntolerance.event.substance.")
        protected CodeableConcept substance;
        @Child(name="certainty", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="unlikely | likely | confirmed - clinical certainty about the specific substance", formalDefinition="Statement about the degree of clinical certainty that the specific substance was the cause of the manifestation in this reaction event.")
        protected Enumeration<AllergyIntoleranceCertainty> certainty;
        @Child(name="manifestation", type={CodeableConcept.class}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Clinical symptoms/signs associated with the Event", formalDefinition="Clinical symptoms and/or signs that are observed or associated with the adverse reaction event.")
        protected List<CodeableConcept> manifestation;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the event as a whole", formalDefinition="Text description about the reaction as a whole, including details of the manifestation if required.")
        protected StringType description;
        @Child(name="onset", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date(/time) when manifestations showed", formalDefinition="Record of the date and/or time of the onset of the Reaction.")
        protected DateTimeType onset;
        @Child(name="severity", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="mild | moderate | severe (of event as a whole)", formalDefinition="Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.")
        protected Enumeration<AllergyIntoleranceSeverity> severity;
        @Child(name="exposureRoute", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How the subject was exposed to the substance", formalDefinition="Identification of the route by which the subject was exposed to the substance.")
        protected CodeableConcept exposureRoute;
        @Child(name="note", type={Annotation.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Text about event not captured in other fields", formalDefinition="Additional text about the adverse reaction event not captured in other fields.")
        protected List<Annotation> note;
        private static final long serialVersionUID = -31700461L;

        public CodeableConcept getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableConcept();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setSubstance(CodeableConcept value) {
            this.substance = value;
            return this;
        }

        public Enumeration<AllergyIntoleranceCertainty> getCertaintyElement() {
            if (this.certainty == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.certainty");
                }
                if (Configuration.doAutoCreate()) {
                    this.certainty = new Enumeration<AllergyIntoleranceCertainty>(new AllergyIntoleranceCertaintyEnumFactory());
                }
            }
            return this.certainty;
        }

        public boolean hasCertaintyElement() {
            return this.certainty != null && !this.certainty.isEmpty();
        }

        public boolean hasCertainty() {
            return this.certainty != null && !this.certainty.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setCertaintyElement(Enumeration<AllergyIntoleranceCertainty> value) {
            this.certainty = value;
            return this;
        }

        public AllergyIntoleranceCertainty getCertainty() {
            return this.certainty == null ? null : (AllergyIntoleranceCertainty)((Object)this.certainty.getValue());
        }

        public AllergyIntoleranceReactionComponent setCertainty(AllergyIntoleranceCertainty value) {
            if (value == null) {
                this.certainty = null;
            } else {
                if (this.certainty == null) {
                    this.certainty = new Enumeration<AllergyIntoleranceCertainty>(new AllergyIntoleranceCertaintyEnumFactory());
                }
                this.certainty.setValue((Object)value);
            }
            return this;
        }

        public List<CodeableConcept> getManifestation() {
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableConcept>();
            }
            return this.manifestation;
        }

        public boolean hasManifestation() {
            if (this.manifestation == null) {
                return false;
            }
            for (CodeableConcept item : this.manifestation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addManifestation() {
            CodeableConcept t = new CodeableConcept();
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableConcept>();
            }
            this.manifestation.add(t);
            return t;
        }

        public AllergyIntoleranceReactionComponent addManifestation(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableConcept>();
            }
            this.manifestation.add(t);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public AllergyIntoleranceReactionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public DateTimeType getOnsetElement() {
            if (this.onset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.onset");
                }
                if (Configuration.doAutoCreate()) {
                    this.onset = new DateTimeType();
                }
            }
            return this.onset;
        }

        public boolean hasOnsetElement() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public boolean hasOnset() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setOnsetElement(DateTimeType value) {
            this.onset = value;
            return this;
        }

        public Date getOnset() {
            return this.onset == null ? null : (Date)this.onset.getValue();
        }

        public AllergyIntoleranceReactionComponent setOnset(Date value) {
            if (value == null) {
                this.onset = null;
            } else {
                if (this.onset == null) {
                    this.onset = new DateTimeType();
                }
                this.onset.setValue(value);
            }
            return this;
        }

        public Enumeration<AllergyIntoleranceSeverity> getSeverityElement() {
            if (this.severity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.severity");
                }
                if (Configuration.doAutoCreate()) {
                    this.severity = new Enumeration<AllergyIntoleranceSeverity>(new AllergyIntoleranceSeverityEnumFactory());
                }
            }
            return this.severity;
        }

        public boolean hasSeverityElement() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public boolean hasSeverity() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setSeverityElement(Enumeration<AllergyIntoleranceSeverity> value) {
            this.severity = value;
            return this;
        }

        public AllergyIntoleranceSeverity getSeverity() {
            return this.severity == null ? null : (AllergyIntoleranceSeverity)((Object)this.severity.getValue());
        }

        public AllergyIntoleranceReactionComponent setSeverity(AllergyIntoleranceSeverity value) {
            if (value == null) {
                this.severity = null;
            } else {
                if (this.severity == null) {
                    this.severity = new Enumeration<AllergyIntoleranceSeverity>(new AllergyIntoleranceSeverityEnumFactory());
                }
                this.severity.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getExposureRoute() {
            if (this.exposureRoute == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.exposureRoute");
                }
                if (Configuration.doAutoCreate()) {
                    this.exposureRoute = new CodeableConcept();
                }
            }
            return this.exposureRoute;
        }

        public boolean hasExposureRoute() {
            return this.exposureRoute != null && !this.exposureRoute.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setExposureRoute(CodeableConcept value) {
            this.exposureRoute = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public AllergyIntoleranceReactionComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(AllergyIntolerance.SP_SUBSTANCE, "CodeableConcept", "Identification of the specific substance considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different to the substance identified as the cause of the risk, but must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite substance that includes the identified substance. It must be clinically safe to only process the AllergyIntolerance.substance and ignore the AllergyIntolerance.event.substance.", 0, Integer.MAX_VALUE, this.substance));
            childrenList.add(new Property("certainty", "code", "Statement about the degree of clinical certainty that the specific substance was the cause of the manifestation in this reaction event.", 0, Integer.MAX_VALUE, this.certainty));
            childrenList.add(new Property(AllergyIntolerance.SP_MANIFESTATION, "CodeableConcept", "Clinical symptoms and/or signs that are observed or associated with the adverse reaction event.", 0, Integer.MAX_VALUE, this.manifestation));
            childrenList.add(new Property("description", "string", "Text description about the reaction as a whole, including details of the manifestation if required.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property(AllergyIntolerance.SP_ONSET, "dateTime", "Record of the date and/or time of the onset of the Reaction.", 0, Integer.MAX_VALUE, this.onset));
            childrenList.add(new Property(AllergyIntolerance.SP_SEVERITY, "code", "Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.", 0, Integer.MAX_VALUE, this.severity));
            childrenList.add(new Property("exposureRoute", "CodeableConcept", "Identification of the route by which the subject was exposed to the substance.", 0, Integer.MAX_VALUE, this.exposureRoute));
            childrenList.add(new Property("note", "Annotation", "Additional text about the adverse reaction event not captured in other fields.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case -1404142937: {
                    Base[] baseArray;
                    if (this.certainty == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.certainty;
                    }
                    return baseArray;
                }
                case 1115984422: {
                    return this.manifestation == null ? new Base[]{} : this.manifestation.toArray(new Base[this.manifestation.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case 105901603: {
                    Base[] baseArray;
                    if (this.onset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.onset;
                    }
                    return baseArray;
                }
                case 1478300413: {
                    Base[] baseArray;
                    if (this.severity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.severity;
                    }
                    return baseArray;
                }
                case 421286274: {
                    Base[] baseArray;
                    if (this.exposureRoute == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.exposureRoute;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = this.castToCodeableConcept(value);
                    break;
                }
                case -1404142937: {
                    this.certainty = new AllergyIntoleranceCertaintyEnumFactory().fromType(value);
                    break;
                }
                case 1115984422: {
                    this.getManifestation().add(this.castToCodeableConcept(value));
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case 105901603: {
                    this.onset = this.castToDateTime(value);
                    break;
                }
                case 1478300413: {
                    this.severity = new AllergyIntoleranceSeverityEnumFactory().fromType(value);
                    break;
                }
                case 421286274: {
                    this.exposureRoute = this.castToCodeableConcept(value);
                    break;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AllergyIntolerance.SP_SUBSTANCE)) {
                this.substance = this.castToCodeableConcept(value);
            } else if (name.equals("certainty")) {
                this.certainty = new AllergyIntoleranceCertaintyEnumFactory().fromType(value);
            } else if (name.equals(AllergyIntolerance.SP_MANIFESTATION)) {
                this.getManifestation().add(this.castToCodeableConcept(value));
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals(AllergyIntolerance.SP_ONSET)) {
                this.onset = this.castToDateTime(value);
            } else if (name.equals(AllergyIntolerance.SP_SEVERITY)) {
                this.severity = new AllergyIntoleranceSeverityEnumFactory().fromType(value);
            } else if (name.equals("exposureRoute")) {
                this.exposureRoute = this.castToCodeableConcept(value);
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case -1404142937: {
                    throw new FHIRException("Cannot make property certainty as it is not a complex type");
                }
                case 1115984422: {
                    return this.addManifestation();
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case 105901603: {
                    throw new FHIRException("Cannot make property onset as it is not a complex type");
                }
                case 1478300413: {
                    throw new FHIRException("Cannot make property severity as it is not a complex type");
                }
                case 421286274: {
                    return this.getExposureRoute();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AllergyIntolerance.SP_SUBSTANCE)) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("certainty")) {
                throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.certainty");
            }
            if (name.equals(AllergyIntolerance.SP_MANIFESTATION)) {
                return this.addManifestation();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.description");
            }
            if (name.equals(AllergyIntolerance.SP_ONSET)) {
                throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.onset");
            }
            if (name.equals(AllergyIntolerance.SP_SEVERITY)) {
                throw new FHIRException("Cannot call addChild on a singleton property AllergyIntolerance.severity");
            }
            if (name.equals("exposureRoute")) {
                this.exposureRoute = new CodeableConcept();
                return this.exposureRoute;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public AllergyIntoleranceReactionComponent copy() {
            AllergyIntoleranceReactionComponent dst = new AllergyIntoleranceReactionComponent();
            this.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            Enumeration<AllergyIntoleranceCertainty> enumeration = dst.certainty = this.certainty == null ? null : this.certainty.copy();
            if (this.manifestation != null) {
                dst.manifestation = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.manifestation) {
                    dst.manifestation.add(codeableConcept.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.onset = this.onset == null ? null : this.onset.copy();
            dst.severity = this.severity == null ? null : this.severity.copy();
            CodeableConcept codeableConcept = dst.exposureRoute = this.exposureRoute == null ? null : this.exposureRoute.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AllergyIntoleranceReactionComponent)) {
                return false;
            }
            AllergyIntoleranceReactionComponent o = (AllergyIntoleranceReactionComponent)other;
            return AllergyIntoleranceReactionComponent.compareDeep(this.substance, o.substance, true) && AllergyIntoleranceReactionComponent.compareDeep(this.certainty, o.certainty, true) && AllergyIntoleranceReactionComponent.compareDeep(this.manifestation, o.manifestation, true) && AllergyIntoleranceReactionComponent.compareDeep(this.description, o.description, true) && AllergyIntoleranceReactionComponent.compareDeep(this.onset, o.onset, true) && AllergyIntoleranceReactionComponent.compareDeep(this.severity, o.severity, true) && AllergyIntoleranceReactionComponent.compareDeep(this.exposureRoute, o.exposureRoute, true) && AllergyIntoleranceReactionComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AllergyIntoleranceReactionComponent)) {
                return false;
            }
            AllergyIntoleranceReactionComponent o = (AllergyIntoleranceReactionComponent)other;
            return AllergyIntoleranceReactionComponent.compareValues(this.certainty, o.certainty, true) && AllergyIntoleranceReactionComponent.compareValues(this.description, o.description, true) && AllergyIntoleranceReactionComponent.compareValues(this.onset, o.onset, true) && AllergyIntoleranceReactionComponent.compareValues(this.severity, o.severity, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.substance != null && !this.substance.isEmpty() || this.certainty != null && !this.certainty.isEmpty() || this.manifestation != null && !this.manifestation.isEmpty() || this.description != null && !this.description.isEmpty() || this.onset != null && !this.onset.isEmpty() || this.severity != null && !this.severity.isEmpty() || this.exposureRoute != null && !this.exposureRoute.isEmpty() || this.note != null && !this.note.isEmpty());
        }

        @Override
        public String fhirType() {
            return "AllergyIntolerance.reaction";
        }
    }

    public static class AllergyIntoleranceSeverityEnumFactory
    implements EnumFactory<AllergyIntoleranceSeverity> {
        @Override
        public AllergyIntoleranceSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mild".equals(codeString)) {
                return AllergyIntoleranceSeverity.MILD;
            }
            if ("moderate".equals(codeString)) {
                return AllergyIntoleranceSeverity.MODERATE;
            }
            if ("severe".equals(codeString)) {
                return AllergyIntoleranceSeverity.SEVERE;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceSeverity> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mild".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.MILD);
            }
            if ("moderate".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.MODERATE);
            }
            if ("severe".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.SEVERE);
            }
            throw new FHIRException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceSeverity code) {
            if (code == AllergyIntoleranceSeverity.NULL) {
                return null;
            }
            if (code == AllergyIntoleranceSeverity.MILD) {
                return "mild";
            }
            if (code == AllergyIntoleranceSeverity.MODERATE) {
                return "moderate";
            }
            if (code == AllergyIntoleranceSeverity.SEVERE) {
                return "severe";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceSeverity code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceSeverity {
        MILD,
        MODERATE,
        SEVERE,
        NULL;


        public static AllergyIntoleranceSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mild".equals(codeString)) {
                return MILD;
            }
            if ("moderate".equals(codeString)) {
                return MODERATE;
            }
            if ("severe".equals(codeString)) {
                return SEVERE;
            }
            throw new FHIRException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MILD: {
                    return "mild";
                }
                case MODERATE: {
                    return "moderate";
                }
                case SEVERE: {
                    return "severe";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MILD: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
                case MODERATE: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
                case SEVERE: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MILD: {
                    return "Causes mild physiological effects.";
                }
                case MODERATE: {
                    return "Causes moderate physiological effects.";
                }
                case SEVERE: {
                    return "Causes severe physiological effects.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MILD: {
                    return "Mild";
                }
                case MODERATE: {
                    return "Moderate";
                }
                case SEVERE: {
                    return "Severe";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceCertaintyEnumFactory
    implements EnumFactory<AllergyIntoleranceCertainty> {
        @Override
        public AllergyIntoleranceCertainty fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("unlikely".equals(codeString)) {
                return AllergyIntoleranceCertainty.UNLIKELY;
            }
            if ("likely".equals(codeString)) {
                return AllergyIntoleranceCertainty.LIKELY;
            }
            if ("confirmed".equals(codeString)) {
                return AllergyIntoleranceCertainty.CONFIRMED;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceCertainty code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceCertainty> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unlikely".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCertainty>(this, AllergyIntoleranceCertainty.UNLIKELY);
            }
            if ("likely".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCertainty>(this, AllergyIntoleranceCertainty.LIKELY);
            }
            if ("confirmed".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCertainty>(this, AllergyIntoleranceCertainty.CONFIRMED);
            }
            throw new FHIRException("Unknown AllergyIntoleranceCertainty code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceCertainty code) {
            if (code == AllergyIntoleranceCertainty.NULL) {
                return null;
            }
            if (code == AllergyIntoleranceCertainty.UNLIKELY) {
                return "unlikely";
            }
            if (code == AllergyIntoleranceCertainty.LIKELY) {
                return "likely";
            }
            if (code == AllergyIntoleranceCertainty.CONFIRMED) {
                return "confirmed";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceCertainty code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceCertainty {
        UNLIKELY,
        LIKELY,
        CONFIRMED,
        NULL;


        public static AllergyIntoleranceCertainty fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unlikely".equals(codeString)) {
                return UNLIKELY;
            }
            if ("likely".equals(codeString)) {
                return LIKELY;
            }
            if ("confirmed".equals(codeString)) {
                return CONFIRMED;
            }
            throw new FHIRException("Unknown AllergyIntoleranceCertainty code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UNLIKELY: {
                    return "unlikely";
                }
                case LIKELY: {
                    return "likely";
                }
                case CONFIRMED: {
                    return "confirmed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UNLIKELY: {
                    return "http://hl7.org/fhir/reaction-event-certainty";
                }
                case LIKELY: {
                    return "http://hl7.org/fhir/reaction-event-certainty";
                }
                case CONFIRMED: {
                    return "http://hl7.org/fhir/reaction-event-certainty";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UNLIKELY: {
                    return "There is a low level of clinical certainty that the reaction was caused by the identified Substance.";
                }
                case LIKELY: {
                    return "There is a high level of clinical certainty that the reaction was caused by the identified Substance.";
                }
                case CONFIRMED: {
                    return "There is a very high level of clinical certainty that the reaction was due to the identified Substance, which may include clinical evidence by testing or rechallenge.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UNLIKELY: {
                    return "Unlikely";
                }
                case LIKELY: {
                    return "Likely";
                }
                case CONFIRMED: {
                    return "Confirmed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceCriticalityEnumFactory
    implements EnumFactory<AllergyIntoleranceCriticality> {
        @Override
        public AllergyIntoleranceCriticality fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("low".equals(codeString)) {
                return AllergyIntoleranceCriticality.LOW;
            }
            if ("high".equals(codeString)) {
                return AllergyIntoleranceCriticality.HIGH;
            }
            if ("unable-to-assess".equals(codeString)) {
                return AllergyIntoleranceCriticality.UNABLETOASSESS;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceCriticality> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("low".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.LOW);
            }
            if ("high".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.HIGH);
            }
            if ("unable-to-assess".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.UNABLETOASSESS);
            }
            throw new FHIRException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceCriticality code) {
            if (code == AllergyIntoleranceCriticality.NULL) {
                return null;
            }
            if (code == AllergyIntoleranceCriticality.LOW) {
                return "low";
            }
            if (code == AllergyIntoleranceCriticality.HIGH) {
                return "high";
            }
            if (code == AllergyIntoleranceCriticality.UNABLETOASSESS) {
                return "unable-to-assess";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceCriticality code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceCriticality {
        LOW,
        HIGH,
        UNABLETOASSESS,
        NULL;


        public static AllergyIntoleranceCriticality fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("low".equals(codeString)) {
                return LOW;
            }
            if ("high".equals(codeString)) {
                return HIGH;
            }
            if ("unable-to-assess".equals(codeString)) {
                return UNABLETOASSESS;
            }
            throw new FHIRException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case LOW: {
                    return "low";
                }
                case HIGH: {
                    return "high";
                }
                case UNABLETOASSESS: {
                    return "unable-to-assess";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case LOW: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
                case HIGH: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
                case UNABLETOASSESS: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case LOW: {
                    return "Worst case result of a future exposure is not assessed to be life-threatening or having high potential for organ system failure.";
                }
                case HIGH: {
                    return "Worst case result of a future exposure is assessed to be life-threatening or having high potential for organ system failure.";
                }
                case UNABLETOASSESS: {
                    return "Unable to assess the worst case result of a future exposure.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case LOW: {
                    return "Low Risk";
                }
                case HIGH: {
                    return "High Risk";
                }
                case UNABLETOASSESS: {
                    return "Unable to Assess Risk";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceCategoryEnumFactory
    implements EnumFactory<AllergyIntoleranceCategory> {
        @Override
        public AllergyIntoleranceCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("food".equals(codeString)) {
                return AllergyIntoleranceCategory.FOOD;
            }
            if ("medication".equals(codeString)) {
                return AllergyIntoleranceCategory.MEDICATION;
            }
            if ("environment".equals(codeString)) {
                return AllergyIntoleranceCategory.ENVIRONMENT;
            }
            if ("other".equals(codeString)) {
                return AllergyIntoleranceCategory.OTHER;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceCategory> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("food".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.FOOD);
            }
            if ("medication".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.MEDICATION);
            }
            if ("environment".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.ENVIRONMENT);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.OTHER);
            }
            throw new FHIRException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceCategory code) {
            if (code == AllergyIntoleranceCategory.NULL) {
                return null;
            }
            if (code == AllergyIntoleranceCategory.FOOD) {
                return "food";
            }
            if (code == AllergyIntoleranceCategory.MEDICATION) {
                return "medication";
            }
            if (code == AllergyIntoleranceCategory.ENVIRONMENT) {
                return "environment";
            }
            if (code == AllergyIntoleranceCategory.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceCategory code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceCategory {
        FOOD,
        MEDICATION,
        ENVIRONMENT,
        OTHER,
        NULL;


        public static AllergyIntoleranceCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("food".equals(codeString)) {
                return FOOD;
            }
            if ("medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("environment".equals(codeString)) {
                return ENVIRONMENT;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            throw new FHIRException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case FOOD: {
                    return "food";
                }
                case MEDICATION: {
                    return "medication";
                }
                case ENVIRONMENT: {
                    return "environment";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case FOOD: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case ENVIRONMENT: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case FOOD: {
                    return "Any substance consumed to provide nutritional support for the body.";
                }
                case MEDICATION: {
                    return "Substances administered to achieve a physiological effect.";
                }
                case ENVIRONMENT: {
                    return "Substances that are encountered in the environment.";
                }
                case OTHER: {
                    return "Other substances that are not covered by any other category.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case FOOD: {
                    return "Food";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case ENVIRONMENT: {
                    return "Environment";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceTypeEnumFactory
    implements EnumFactory<AllergyIntoleranceType> {
        @Override
        public AllergyIntoleranceType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("allergy".equals(codeString)) {
                return AllergyIntoleranceType.ALLERGY;
            }
            if ("intolerance".equals(codeString)) {
                return AllergyIntoleranceType.INTOLERANCE;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceType code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("allergy".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceType>(this, AllergyIntoleranceType.ALLERGY);
            }
            if ("intolerance".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceType>(this, AllergyIntoleranceType.INTOLERANCE);
            }
            throw new FHIRException("Unknown AllergyIntoleranceType code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceType code) {
            if (code == AllergyIntoleranceType.NULL) {
                return null;
            }
            if (code == AllergyIntoleranceType.ALLERGY) {
                return "allergy";
            }
            if (code == AllergyIntoleranceType.INTOLERANCE) {
                return "intolerance";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceType code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceType {
        ALLERGY,
        INTOLERANCE,
        NULL;


        public static AllergyIntoleranceType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("allergy".equals(codeString)) {
                return ALLERGY;
            }
            if ("intolerance".equals(codeString)) {
                return INTOLERANCE;
            }
            throw new FHIRException("Unknown AllergyIntoleranceType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ALLERGY: {
                    return "allergy";
                }
                case INTOLERANCE: {
                    return "intolerance";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ALLERGY: {
                    return "http://hl7.org/fhir/allergy-intolerance-type";
                }
                case INTOLERANCE: {
                    return "http://hl7.org/fhir/allergy-intolerance-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ALLERGY: {
                    return "A propensity for hypersensitivity reaction(s) to a substance.  These reactions are most typically type I hypersensitivity, plus other \"allergy-like\" reactions, including pseudoallergy.";
                }
                case INTOLERANCE: {
                    return "A propensity for adverse reactions to a substance that is not judged to be allergic or \"allergy-like\".  These reactions are typically (but not necessarily) non-immune.  They are to some degree idiosyncratic and/or individually specific (i.e. are not a reaction that is expected to occur with most or all patients given similar circumstances).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ALLERGY: {
                    return "Allergy";
                }
                case INTOLERANCE: {
                    return "Intolerance";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceStatusEnumFactory
    implements EnumFactory<AllergyIntoleranceStatus> {
        @Override
        public AllergyIntoleranceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return AllergyIntoleranceStatus.ACTIVE;
            }
            if ("unconfirmed".equals(codeString)) {
                return AllergyIntoleranceStatus.UNCONFIRMED;
            }
            if ("confirmed".equals(codeString)) {
                return AllergyIntoleranceStatus.CONFIRMED;
            }
            if ("inactive".equals(codeString)) {
                return AllergyIntoleranceStatus.INACTIVE;
            }
            if ("resolved".equals(codeString)) {
                return AllergyIntoleranceStatus.RESOLVED;
            }
            if ("refuted".equals(codeString)) {
                return AllergyIntoleranceStatus.REFUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return AllergyIntoleranceStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceStatus code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceStatus>(this, AllergyIntoleranceStatus.ACTIVE);
            }
            if ("unconfirmed".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceStatus>(this, AllergyIntoleranceStatus.UNCONFIRMED);
            }
            if ("confirmed".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceStatus>(this, AllergyIntoleranceStatus.CONFIRMED);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceStatus>(this, AllergyIntoleranceStatus.INACTIVE);
            }
            if ("resolved".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceStatus>(this, AllergyIntoleranceStatus.RESOLVED);
            }
            if ("refuted".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceStatus>(this, AllergyIntoleranceStatus.REFUTED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceStatus>(this, AllergyIntoleranceStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown AllergyIntoleranceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceStatus code) {
            if (code == AllergyIntoleranceStatus.NULL) {
                return null;
            }
            if (code == AllergyIntoleranceStatus.ACTIVE) {
                return "active";
            }
            if (code == AllergyIntoleranceStatus.UNCONFIRMED) {
                return "unconfirmed";
            }
            if (code == AllergyIntoleranceStatus.CONFIRMED) {
                return "confirmed";
            }
            if (code == AllergyIntoleranceStatus.INACTIVE) {
                return "inactive";
            }
            if (code == AllergyIntoleranceStatus.RESOLVED) {
                return "resolved";
            }
            if (code == AllergyIntoleranceStatus.REFUTED) {
                return "refuted";
            }
            if (code == AllergyIntoleranceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceStatus code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceStatus {
        ACTIVE,
        UNCONFIRMED,
        CONFIRMED,
        INACTIVE,
        RESOLVED,
        REFUTED,
        ENTEREDINERROR,
        NULL;


        public static AllergyIntoleranceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("unconfirmed".equals(codeString)) {
                return UNCONFIRMED;
            }
            if ("confirmed".equals(codeString)) {
                return CONFIRMED;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("resolved".equals(codeString)) {
                return RESOLVED;
            }
            if ("refuted".equals(codeString)) {
                return REFUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown AllergyIntoleranceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case UNCONFIRMED: {
                    return "unconfirmed";
                }
                case CONFIRMED: {
                    return "confirmed";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case RESOLVED: {
                    return "resolved";
                }
                case REFUTED: {
                    return "refuted";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/allergy-intolerance-status";
                }
                case UNCONFIRMED: {
                    return "http://hl7.org/fhir/allergy-intolerance-status";
                }
                case CONFIRMED: {
                    return "http://hl7.org/fhir/allergy-intolerance-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/allergy-intolerance-status";
                }
                case RESOLVED: {
                    return "http://hl7.org/fhir/allergy-intolerance-status";
                }
                case REFUTED: {
                    return "http://hl7.org/fhir/allergy-intolerance-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/allergy-intolerance-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "An active record of a reaction to the identified Substance.";
                }
                case UNCONFIRMED: {
                    return "A low level of certainty about the propensity for a reaction to the identified Substance.";
                }
                case CONFIRMED: {
                    return "A high level of certainty about the propensity for a reaction to the identified Substance, which may include clinical evidence by testing or rechallenge.";
                }
                case INACTIVE: {
                    return "An inactive record of a reaction to the identified Substance.";
                }
                case RESOLVED: {
                    return "A reaction to the identified Substance has been clinically reassessed by testing or rechallenge and considered to be resolved.";
                }
                case REFUTED: {
                    return "A propensity for a reaction to the identified Substance has been disproven with a high level of clinical certainty, which may include testing or rechallenge, and is refuted.";
                }
                case ENTEREDINERROR: {
                    return "The statement was entered in error and is not valid.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case UNCONFIRMED: {
                    return "Unconfirmed";
                }
                case CONFIRMED: {
                    return "Confirmed";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case RESOLVED: {
                    return "Resolved";
                }
                case REFUTED: {
                    return "Refuted";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

