/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.GoalStatus;

public class GoalStatusEnumFactory
implements EnumFactory<GoalStatus> {
    @Override
    public GoalStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return GoalStatus.PROPOSED;
        }
        if ("planned".equals(codeString)) {
            return GoalStatus.PLANNED;
        }
        if ("accepted".equals(codeString)) {
            return GoalStatus.ACCEPTED;
        }
        if ("rejected".equals(codeString)) {
            return GoalStatus.REJECTED;
        }
        if ("in-progress".equals(codeString)) {
            return GoalStatus.INPROGRESS;
        }
        if ("achieved".equals(codeString)) {
            return GoalStatus.ACHIEVED;
        }
        if ("sustaining".equals(codeString)) {
            return GoalStatus.SUSTAINING;
        }
        if ("on-hold".equals(codeString)) {
            return GoalStatus.ONHOLD;
        }
        if ("cancelled".equals(codeString)) {
            return GoalStatus.CANCELLED;
        }
        throw new IllegalArgumentException("Unknown GoalStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(GoalStatus code) {
        if (code == GoalStatus.NULL) {
            return null;
        }
        if (code == GoalStatus.PROPOSED) {
            return "proposed";
        }
        if (code == GoalStatus.PLANNED) {
            return "planned";
        }
        if (code == GoalStatus.ACCEPTED) {
            return "accepted";
        }
        if (code == GoalStatus.REJECTED) {
            return "rejected";
        }
        if (code == GoalStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == GoalStatus.ACHIEVED) {
            return "achieved";
        }
        if (code == GoalStatus.SUSTAINING) {
            return "sustaining";
        }
        if (code == GoalStatus.ONHOLD) {
            return "on-hold";
        }
        if (code == GoalStatus.CANCELLED) {
            return "cancelled";
        }
        return "?";
    }

    @Override
    public String toSystem(GoalStatus code) {
        return code.getSystem();
    }
}

