/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.util.FhirVersionIndependentConcept;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ValueSet;

public class ValueSetExpansionFilterContext {
    private final Map<String, Map<String, String>> propertyIndex = new HashMap<String, Map<String, String>>();
    private final Map<String, Set<String>> conceptCodeTree = new HashMap<String, Set<String>>();
    private final Set<String> allCodes = new HashSet<String>();
    private final Set<String> allCodesLower = new HashSet<String>();
    private final Map<String, Set<String>> inSetsMap = new HashMap<String, Set<String>>();
    private final Map<String, Pattern> regexCache = new HashMap<String, Pattern>();
    private final CodeSystem codeSystem;
    private final List<ValueSet.ConceptSetFilterComponent> filters;
    private boolean hasIndexRun = false;

    public ValueSetExpansionFilterContext(CodeSystem codeSystem, List<ValueSet.ConceptSetFilterComponent> filters) {
        this.codeSystem = codeSystem;
        this.filters = filters;
    }

    public boolean isFiltered(FhirVersionIndependentConcept concept) {
        if (this.filters == null || this.filters.isEmpty()) {
            return false;
        }
        for (ValueSet.ConceptSetFilterComponent filter : this.filters) {
            if (this.passesFilter(filter, concept)) continue;
            return true;
        }
        return false;
    }

    public boolean passesFilter(ValueSet.ConceptSetFilterComponent filter, FhirVersionIndependentConcept concept) {
        if (filter.hasOp()) {
            this.buildIndexes();
            String theFilterProperty = filter.hasProperty() ? filter.getProperty().toLowerCase(Locale.ROOT) : "concept";
            boolean onCode = theFilterProperty.equals("concept") || theFilterProperty.equals("code");
            boolean onDisplay = theFilterProperty.equals("display");
            if (!onCode && !onDisplay) {
                return false;
            }
            String theFilterValue = filter.getValue();
            String theConceptCode = concept.getCode();
            String theConceptPropertyValue = onCode ? concept.getCode() : (String)this.propertyIndex.getOrDefault("display", Collections.emptyMap()).get(theConceptCode);
            switch (filter.getOp()) {
                case EQUAL: {
                    if (theConceptPropertyValue == null) {
                        return false;
                    }
                    return this.isEqualsWithOptionalCaseSensitive(theFilterValue, theConceptPropertyValue);
                }
                case ISA: {
                    if (this.failsStructuralFilterGuard(theFilterValue, onCode)) {
                        return false;
                    }
                    if (this.isEqualsWithOptionalCaseSensitive(theFilterValue, theConceptCode)) {
                        return true;
                    }
                    return this.isDescendantOf(theFilterValue, theConceptCode);
                }
                case DESCENDENTOF: {
                    if (this.failsStructuralFilterGuard(theFilterValue, onCode)) {
                        return false;
                    }
                    return this.isDescendantOf(theFilterValue, theConceptCode);
                }
                case ISNOTA: {
                    if (this.failsStructuralFilterGuard(theFilterValue, onCode)) {
                        return false;
                    }
                    if (this.isEqualsWithOptionalCaseSensitive(theFilterValue, theConceptCode)) {
                        return false;
                    }
                    return !this.isDescendantOf(theFilterValue, theConceptCode);
                }
                case REGEX: {
                    if (theConceptPropertyValue == null) {
                        return false;
                    }
                    return this.matchesRegex(theFilterValue, theConceptPropertyValue);
                }
                case IN: {
                    if (theConceptPropertyValue == null) {
                        return false;
                    }
                    return this.csvFilterListContains(theFilterValue, theConceptPropertyValue);
                }
                case NOTIN: {
                    if (theConceptPropertyValue == null) {
                        return true;
                    }
                    return !this.csvFilterListContains(theFilterValue, theConceptPropertyValue);
                }
                case GENERALIZES: {
                    if (this.failsStructuralFilterGuard(theFilterValue, onCode)) {
                        return false;
                    }
                    if (this.isEqualsWithOptionalCaseSensitive(theFilterValue, theConceptCode)) {
                        return true;
                    }
                    return this.isDescendantOf(theConceptCode, theFilterValue);
                }
                case CHILDOF: {
                    if (this.failsStructuralFilterGuard(theFilterValue, onCode)) {
                        return false;
                    }
                    Set directKids = this.conceptCodeTree.getOrDefault(theFilterValue, Collections.emptySet());
                    return directKids.stream().anyMatch(childCode -> this.isEqualsWithOptionalCaseSensitive((String)childCode, theConceptCode));
                }
                case DESCENDENTLEAF: {
                    if (this.failsStructuralFilterGuard(theFilterValue, onCode)) {
                        return false;
                    }
                    if (!this.isDescendantOf(theFilterValue, theConceptCode)) {
                        return false;
                    }
                    Set kids = this.conceptCodeTree.getOrDefault(theConceptCode, Collections.emptySet());
                    return kids.isEmpty();
                }
                case EXISTS: {
                    boolean wantExists = Boolean.parseBoolean(theFilterValue);
                    if (onCode) {
                        boolean hasCode = !this.isFilterPropertyValueNotInCodeSystem(theConceptCode);
                        return wantExists == hasCode;
                    }
                    boolean hasDisplay = theConceptPropertyValue != null;
                    return wantExists == hasDisplay;
                }
            }
        }
        return false;
    }

    private boolean failsStructuralFilterGuard(String theFilterValue, boolean onCode) {
        return !onCode || this.isFilterPropertyValueNotInCodeSystem(theFilterValue);
    }

    private boolean isDescendantOf(String theParentCode, String theCandidatePropertyValue) {
        ArrayDeque stack = new ArrayDeque(this.conceptCodeTree.getOrDefault(theParentCode, Set.of()));
        while (!stack.isEmpty()) {
            String theChildCode = (String)stack.pop();
            if (this.isEqualsWithOptionalCaseSensitive(theChildCode, theCandidatePropertyValue)) {
                return true;
            }
            stack.addAll(this.conceptCodeTree.getOrDefault(theChildCode, Set.of()));
        }
        return false;
    }

    private boolean isEqualsWithOptionalCaseSensitive(String a, String b) {
        return this.codeSystem.getCaseSensitive() ? a.equals(b) : a.equalsIgnoreCase(b);
    }

    private boolean csvFilterListContains(String theCsvFilter, String theCandidatePropertyValue) {
        Set values = this.inSetsMap.computeIfAbsent(theCsvFilter, filter -> new HashSet<String>(Arrays.asList(filter.split("\\s*,\\s*"))));
        return values.stream().anyMatch(part -> this.isEqualsWithOptionalCaseSensitive((String)part, theCandidatePropertyValue));
    }

    private boolean isFilterPropertyValueNotInCodeSystem(String theFilterPropertyValue) {
        if (this.codeSystem.getCaseSensitive()) {
            return !this.allCodes.contains(theFilterPropertyValue);
        }
        return !this.allCodesLower.contains(theFilterPropertyValue.toLowerCase());
    }

    private boolean matchesRegex(String expr, String text) {
        try {
            Pattern p = this.regexCache.computeIfAbsent(expr, key -> Pattern.compile(key, this.codeSystem.getCaseSensitive() ? 0 : 2));
            return p.matcher(text).matches();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    private void buildIndexes() {
        if (!this.hasIndexRun) {
            this.buildIndexes(this.codeSystem.getConcept());
            this.hasIndexRun = true;
        }
    }

    private void buildIndexes(List<CodeSystem.ConceptDefinitionComponent> defs) {
        for (CodeSystem.ConceptDefinitionComponent def : defs) {
            String code = def.getCode();
            String display = def.getDisplay();
            this.allCodes.add(code);
            this.allCodesLower.add(code.toLowerCase());
            for (CodeSystem.ConceptDefinitionComponent child : def.getConcept()) {
                this.conceptCodeTree.computeIfAbsent(code, k -> new HashSet()).add(child.getCode());
            }
            this.propertyIndex.computeIfAbsent("code", k -> new HashMap()).put(code, code);
            this.propertyIndex.computeIfAbsent("display", k -> new HashMap()).put(code, display);
            this.buildIndexes(def.getConcept());
        }
    }
}

