/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.LookupCodeRequest;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.StopWatch;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.RemoteTerminologyServiceValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChainMetrics;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;

public class ValidationSupportChain
implements IValidationSupport {
    public static final ValueSetExpansionOptions EMPTY_EXPANSION_OPTIONS = new ValueSetExpansionOptions();
    static Logger ourLog = Logs.getTerminologyTroubleshootingLog();
    private final List<IValidationSupport> myChain = new ArrayList<IValidationSupport>();
    @Nullable
    private final Cache<BaseKey<?>, Object> myExpiringCache;
    @Nullable
    private final Map<BaseKey<?>, Object> myNonExpiringCache;
    @Nonnull
    private final Map<String, IBaseResource> myStructureDefinitionsByUrl = new HashMap<String, IBaseResource>();
    @Nonnull
    private final List<IBaseResource> myStructureDefinitionsAsList = new ArrayList<IBaseResource>();
    private final ThreadPoolExecutor myBackgroundExecutor;
    private final CacheConfiguration myCacheConfiguration;
    private boolean myEnabledValidationForCodingsLogicalAnd;
    private String myName = this.getClass().getSimpleName();
    private ValidationSupportChainMetrics myMetrics;
    private volatile boolean myHaveFetchedAllStructureDefinitions = false;

    public ValidationSupportChain() {
        this(Collections.emptyList());
    }

    public ValidationSupportChain(IValidationSupport ... theValidationSupportModules) {
        this(theValidationSupportModules != null ? Arrays.asList(theValidationSupportModules) : Collections.emptyList());
    }

    public ValidationSupportChain(List<IValidationSupport> theValidationSupportModules) {
        this(CacheConfiguration.defaultValues(), theValidationSupportModules);
    }

    public ValidationSupportChain(@Nonnull CacheConfiguration theCacheConfiguration, IValidationSupport ... theValidationSupportModules) {
        this(theCacheConfiguration, theValidationSupportModules != null ? Arrays.asList(theValidationSupportModules) : Collections.emptyList());
    }

    public ValidationSupportChain(@Nonnull CacheConfiguration theCacheConfiguration, @Nonnull List<IValidationSupport> theValidationSupportModules) {
        Validate.notNull((Object)theCacheConfiguration, (String)"theCacheConfiguration must not be null", (Object[])new Object[0]);
        Validate.notNull(theValidationSupportModules, (String)"theValidationSupportModules must not be null", (Object[])new Object[0]);
        this.myCacheConfiguration = theCacheConfiguration;
        if (theCacheConfiguration.getCacheSize() == 0 || theCacheConfiguration.getCacheTimeout() == 0L) {
            this.myExpiringCache = null;
            this.myNonExpiringCache = null;
            this.myBackgroundExecutor = null;
        } else {
            this.myExpiringCache = CacheFactory.build((long)theCacheConfiguration.getCacheTimeout(), (long)theCacheConfiguration.getCacheSize());
            this.myNonExpiringCache = Collections.synchronizedMap(new HashMap());
            LinkedBlockingQueue<Runnable> executorQueue = new LinkedBlockingQueue<Runnable>(1000);
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("CachingValidationSupport-%d").daemon(false).priority(5).build();
            this.myBackgroundExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, executorQueue, (ThreadFactory)threadFactory, new ThreadPoolExecutor.DiscardPolicy());
        }
        for (IValidationSupport next : theValidationSupportModules) {
            if (next == null) continue;
            this.addValidationSupport(next);
        }
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String theName) {
        Validate.notBlank((CharSequence)theName, (String)"theName must not be blank", (Object[])new Object[0]);
        this.myName = theName;
    }

    @PostConstruct
    public void start() {
        if (this.myMetrics == null) {
            this.myMetrics = new ValidationSupportChainMetrics(this);
            this.myMetrics.start();
        }
    }

    @PreDestroy
    public void stop() {
        if (this.myMetrics != null) {
            this.myMetrics.stop();
            this.myMetrics = null;
        }
    }

    public boolean isCodeableConceptValidationSuccessfulIfNotAllCodingsAreValid() {
        return this.myEnabledValidationForCodingsLogicalAnd;
    }

    public ValidationSupportChain setCodeableConceptValidationSuccessfulIfNotAllCodingsAreValid(boolean theEnabledValidationForCodingsLogicalAnd) {
        this.myEnabledValidationForCodingsLogicalAnd = theEnabledValidationForCodingsLogicalAnd;
        return this;
    }

    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        TranslateConceptKey key = new TranslateConceptKey(theRequest);
        CacheValue<Object> retVal = this.getFromCache(key);
        if (retVal == null) {
            retVal = CacheValue.empty();
            TranslateConceptResults outcome = null;
            for (IValidationSupport next : this.myChain) {
                TranslateConceptResults translations = next.translateConcept(theRequest);
                if (translations == null) continue;
                if (outcome == null) {
                    outcome = new TranslateConceptResults();
                }
                if (outcome.getMessage() == null) {
                    outcome.setMessage(translations.getMessage());
                }
                if (translations.getResult() && !outcome.getResult()) {
                    outcome.setResult(translations.getResult());
                    outcome.setMessage(translations.getMessage());
                }
                if (translations.isEmpty()) continue;
                ourLog.debug("{} found {} concept translation{} for {}", new Object[]{next.getName(), translations.size(), translations.size() > 1 ? "s" : "", theRequest});
                outcome.getResults().addAll(translations.getResults());
            }
            if (outcome != null) {
                retVal = new CacheValue<Object>(outcome);
            }
            this.putInCache(key, retVal);
        }
        return retVal.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCaches() {
        ourLog.debug("Invalidating caches in {} validation support modules", (Object)this.myChain.size());
        this.myHaveFetchedAllStructureDefinitions = false;
        for (IValidationSupport next : this.myChain) {
            next.invalidateCaches();
        }
        if (this.myNonExpiringCache != null) {
            this.myNonExpiringCache.clear();
        }
        if (this.myExpiringCache != null) {
            this.myExpiringCache.invalidateAll();
        }
        Map<String, IBaseResource> map = this.myStructureDefinitionsByUrl;
        synchronized (map) {
            this.myStructureDefinitionsByUrl.clear();
            this.myStructureDefinitionsAsList.clear();
        }
    }

    public void invalidateExpiringCaches() {
        if (this.myExpiringCache != null) {
            this.myExpiringCache.invalidateAll();
        }
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        for (IValidationSupport next : this.myChain) {
            boolean retVal = this.isValueSetSupported(theValidationSupportContext, next, theValueSetUrl);
            if (!retVal) continue;
            ourLog.debug("ValueSet {} found in {}", (Object)theValueSetUrl, (Object)next.getName());
            return true;
        }
        return false;
    }

    private boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, IValidationSupport theValidationSupport, String theValueSetUrl) {
        IsValueSetSupportedKey key = new IsValueSetSupportedKey(theValidationSupport, theValueSetUrl);
        CacheValue<Boolean> value = this.getFromCache(key);
        if (value == null) {
            value = new CacheValue<Boolean>(theValidationSupport.isValueSetSupported(theValidationSupportContext, theValueSetUrl));
            this.putInCache(key, value);
        }
        return value.getValue();
    }

    public IBaseResource generateSnapshot(ValidationSupportContext theValidationSupportContext, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.generateSnapshot(theValidationSupportContext, theInput, theUrl, theWebUrl, theProfileName);
            if (retVal == null) continue;
            ourLog.atDebug().setMessage("Profile snapshot for {} generated by {}").addArgument(() -> ((IBaseResource)theInput).getIdElement()).addArgument(() -> ((IValidationSupport)next).getName()).log();
            return retVal;
        }
        return null;
    }

    public FhirContext getFhirContext() {
        if (this.myChain.isEmpty()) {
            return null;
        }
        return this.myChain.get(0).getFhirContext();
    }

    public void addValidationSupport(IValidationSupport theValidationSupport) {
        int index = this.myChain.size();
        this.addValidationSupport(index, theValidationSupport);
    }

    public void addValidationSupport(int theIndex, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        this.invalidateCaches();
        if (theValidationSupport.getFhirContext() == null) {
            String message = "Can not add validation support: getFhirContext() returns null";
            throw new ConfigurationException(Msg.code((int)708) + message);
        }
        FhirContext existingFhirContext = this.getFhirContext();
        if (existingFhirContext != null) {
            FhirVersionEnum newVersion = theValidationSupport.getFhirContext().getVersion().getVersion();
            FhirVersionEnum existingVersion = existingFhirContext.getVersion().getVersion();
            if (!existingVersion.equals((Object)newVersion)) {
                String message = "Trying to add validation support of version " + String.valueOf(newVersion) + " to chain with " + this.myChain.size() + " entries of version " + String.valueOf(existingVersion);
                throw new ConfigurationException(Msg.code((int)709) + message);
            }
        }
        this.myChain.add(theIndex, theValidationSupport);
    }

    public void removeValidationSupport(IValidationSupport theValidationSupport) {
        this.myChain.remove(theValidationSupport);
    }

    @Nullable
    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, @Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull String theValueSetUrlToExpand) throws ResourceNotFoundException {
        ValueSetExpansionOptions expansionOptions = (ValueSetExpansionOptions)ObjectUtils.defaultIfNull((Object)theExpansionOptions, (Object)EMPTY_EXPANSION_OPTIONS);
        ExpandValueSetKey key = new ExpandValueSetKey(expansionOptions, null, theValueSetUrlToExpand);
        CacheValue<Object> retVal = this.getFromCache(key);
        if (retVal == null) {
            retVal = CacheValue.empty();
            for (IValidationSupport next : this.myChain) {
                IValidationSupport.ValueSetExpansionOutcome expanded;
                if (!this.isValueSetSupported(theValidationSupportContext, next, theValueSetUrlToExpand) || (expanded = next.expandValueSet(theValidationSupportContext, expansionOptions, theValueSetUrlToExpand)) == null) continue;
                ourLog.debug("ValueSet {} expanded by URL by {}", (Object)theValueSetUrlToExpand, (Object)next.getName());
                retVal = new CacheValue<IValidationSupport.ValueSetExpansionOutcome>(expanded);
                break;
            }
            this.putInCache(key, retVal);
        }
        return retVal.getValue();
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        ValueSetExpansionOptions expansionOptions = (ValueSetExpansionOptions)ObjectUtils.defaultIfNull((Object)theExpansionOptions, (Object)EMPTY_EXPANSION_OPTIONS);
        String id = theValueSetToExpand.getIdElement().getValue();
        ExpandValueSetKey key = null;
        CacheValue<Object> retVal = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            key = new ExpandValueSetKey(expansionOptions, id, null);
            retVal = this.getFromCache(key);
        }
        if (retVal == null) {
            retVal = CacheValue.empty();
            for (IValidationSupport next : this.myChain) {
                IValidationSupport.ValueSetExpansionOutcome expanded = next.expandValueSet(theValidationSupportContext, expansionOptions, theValueSetToExpand);
                if (expanded == null) continue;
                ourLog.debug("ValueSet {} expanded by {}", (Object)theValueSetToExpand.getIdElement(), (Object)next.getName());
                retVal = new CacheValue<IValidationSupport.ValueSetExpansionOutcome>(expanded);
                break;
            }
            if (key != null) {
                this.putInCache(key, retVal);
            }
        }
        return (IValidationSupport.ValueSetExpansionOutcome)retVal.getValue();
    }

    public boolean isRemoteTerminologyServiceConfigured() {
        return this.myChain.stream().anyMatch(RemoteTerminologyServiceValidationSupport.class::isInstance);
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        FetchAllKey key = new FetchAllKey(FetchAllKey.TypeEnum.ALL);
        Supplier<List<IBaseResource>> loader = () -> {
            ArrayList allCandidates = new ArrayList();
            for (IValidationSupport next : this.myChain) {
                List candidates = next.fetchAllConformanceResources();
                if (candidates == null) continue;
                allCandidates.addAll(candidates);
            }
            return allCandidates;
        };
        return this.getFromCacheWithAsyncRefresh(key, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<IBaseResource> fetchAllStructureDefinitions() {
        if (!this.myHaveFetchedAllStructureDefinitions) {
            FhirTerser terser = this.getFhirContext().newTerser();
            List<IBaseResource> allStructureDefinitions = this.doFetchStructureDefinitions(IValidationSupport::fetchAllStructureDefinitions);
            if (this.myExpiringCache != null) {
                Map<String, IBaseResource> map = this.myStructureDefinitionsByUrl;
                synchronized (map) {
                    for (IBaseResource structureDefinition : allStructureDefinitions) {
                        String url = terser.getSinglePrimitiveValueOrNull((IBase)structureDefinition, "url");
                        if (this.myStructureDefinitionsByUrl.putIfAbsent(url = (String)StringUtils.defaultIfBlank((CharSequence)url, (CharSequence)UUID.randomUUID().toString()), structureDefinition) != null) continue;
                        this.myStructureDefinitionsAsList.add(structureDefinition);
                    }
                }
            }
            this.myHaveFetchedAllStructureDefinitions = true;
        }
        return Collections.unmodifiableList(new ArrayList<IBaseResource>(this.myStructureDefinitionsAsList));
    }

    public List<IBaseResource> fetchAllNonBaseStructureDefinitions() {
        FetchAllKey key = new FetchAllKey(FetchAllKey.TypeEnum.ALL_NON_BASE_STRUCTUREDEFINITIONS);
        Supplier<List<IBaseResource>> loader = () -> this.doFetchStructureDefinitions(IValidationSupport::fetchAllNonBaseStructureDefinitions);
        return this.getFromCacheWithAsyncRefresh(key, loader);
    }

    @Nullable
    public <T extends IBaseResource> List<T> fetchAllSearchParameters() {
        FetchAllKey key = new FetchAllKey(FetchAllKey.TypeEnum.ALL_SEARCHPARAMETERS);
        Supplier<List<IBaseResource>> loader = () -> this.doFetchStructureDefinitions(IValidationSupport::fetchAllSearchParameters);
        return this.getFromCacheWithAsyncRefresh(key, loader);
    }

    private List<IBaseResource> doFetchStructureDefinitions(Function<IValidationSupport, List<IBaseResource>> theFunction) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        HashSet<String> urls = new HashSet<String>();
        for (IValidationSupport nextSupport : this.myChain) {
            List<IBaseResource> allStructureDefinitions = theFunction.apply(nextSupport);
            if (allStructureDefinitions == null) continue;
            for (IBaseResource next : allStructureDefinitions) {
                IPrimitiveType urlType = (IPrimitiveType)this.getFhirContext().newTerser().getSingleValueOrNull((IBase)next, "url", IPrimitiveType.class);
                if (urlType != null && !StringUtils.isBlank((CharSequence)urlType.getValueAsString()) && !urls.add(urlType.getValueAsString())) continue;
                retVal.add(next);
            }
        }
        return retVal;
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        Function<IValidationSupport, IBaseResource> invoker = v -> v.fetchCodeSystem(theSystem);
        ResourceByUrlKey key = new ResourceByUrlKey(ResourceByUrlKey.TypeEnum.CODESYSTEM, theSystem);
        return this.fetchValue(key, invoker, theSystem);
    }

    private <T> T fetchValue(ResourceByUrlKey<T> theKey, Function<IValidationSupport, T> theInvoker, String theUrl) {
        CacheValue<T> retVal = this.getFromCache(theKey);
        if (retVal == null) {
            retVal = CacheValue.empty();
            for (IValidationSupport next : this.myChain) {
                T outcome = theInvoker.apply(next);
                if (outcome == null) continue;
                ourLog.debug("{} {} with URL {} fetched by {}", new Object[]{theKey.myType, outcome, theUrl, next.getName()});
                retVal = new CacheValue<T>(outcome);
                break;
            }
            this.putInCache(theKey, retVal);
        }
        return retVal.getValue();
    }

    public IBaseResource fetchValueSet(String theUrl) {
        Function<IValidationSupport, IBaseResource> invoker = v -> v.fetchValueSet(theUrl);
        ResourceByUrlKey key = new ResourceByUrlKey(ResourceByUrlKey.TypeEnum.VALUESET, theUrl);
        return this.fetchValue(key, invoker, theUrl);
    }

    public <T extends IBaseResource> T fetchResource(Class<T> theClass, String theUri) {
        BaseRuntimeElementDefinition elementDefinition;
        if (theClass != null && (elementDefinition = this.getFhirContext().getElementDefinition(theClass)) != null) {
            switch (elementDefinition.getName()) {
                case "ValueSet": {
                    return (T)this.fetchValueSet(theUri);
                }
                case "CodeSystem": {
                    return (T)this.fetchCodeSystem(theUri);
                }
                case "StructureDefinition": {
                    return (T)this.fetchStructureDefinition(theUri);
                }
            }
        }
        Function<IValidationSupport, IBaseResource> invoker = v -> v.fetchResource(theClass, theUri);
        TypedResourceByUrlKey key = new TypedResourceByUrlKey(theClass, theUri);
        return (T)this.fetchValue(key, invoker, theUri);
    }

    public byte[] fetchBinary(String theKey) {
        Function<IValidationSupport, byte[]> invoker = v -> v.fetchBinary(theKey);
        ResourceByUrlKey key = new ResourceByUrlKey(ResourceByUrlKey.TypeEnum.BINARY, theKey);
        return this.fetchValue(key, invoker, theKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBaseResource fetchStructureDefinition(String theUrl) {
        Map<String, IBaseResource> map = this.myStructureDefinitionsByUrl;
        synchronized (map) {
            IBaseResource candidate = this.myStructureDefinitionsByUrl.get(theUrl);
            if (candidate == null) {
                Function<IValidationSupport, IBaseResource> invoker = v -> v.fetchStructureDefinition(theUrl);
                ResourceByUrlKey key = new ResourceByUrlKey(ResourceByUrlKey.TypeEnum.STRUCTUREDEFINITION, theUrl);
                candidate = this.fetchValue(key, invoker, theUrl);
                if (this.myExpiringCache != null && candidate != null && this.myStructureDefinitionsByUrl.putIfAbsent(theUrl, candidate) == null) {
                    this.myStructureDefinitionsAsList.add(candidate);
                }
            }
            return candidate;
        }
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            if (!this.isCodeSystemSupported(theValidationSupportContext, next, theSystem)) continue;
            if (ourLog.isDebugEnabled()) {
                ourLog.debug("CodeSystem with System {} is supported by {}", (Object)theSystem, (Object)next.getName());
            }
            return true;
        }
        return false;
    }

    private boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, IValidationSupport theValidationSupport, String theCodeSystemUrl) {
        IsCodeSystemSupportedKey key = new IsCodeSystemSupportedKey(theValidationSupport, theCodeSystemUrl);
        CacheValue<Boolean> value = this.getFromCache(key);
        if (value == null) {
            value = new CacheValue<Boolean>(theValidationSupport.isCodeSystemSupported(theValidationSupportContext, theCodeSystemUrl));
            this.putInCache(key, value);
        }
        return value.getValue();
    }

    public IValidationSupport.CodeValidationResult validateCode(@Nonnull ValidationSupportContext theValidationSupportContext, @Nonnull ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        ValidateCodeKey key = new ValidateCodeKey(theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl);
        CacheValue<Object> retVal = this.getFromCache(key);
        if (retVal == null) {
            retVal = CacheValue.empty();
            for (IValidationSupport next : this.myChain) {
                IValidationSupport.CodeValidationResult outcome;
                if ((!StringUtils.isBlank((CharSequence)theValueSetUrl) || !this.isCodeSystemSupported(theValidationSupportContext, next, theCodeSystem)) && (!StringUtils.isNotBlank((CharSequence)theValueSetUrl) || !this.isValueSetSupported(theValidationSupportContext, next, theValueSetUrl)) || (outcome = next.validateCode(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl)) == null) continue;
                ourLog.debug("Code {}|{} '{}' in ValueSet {} validated by {}", new Object[]{theCodeSystem, theCode, theDisplay, theValueSetUrl, next.getName()});
                retVal = new CacheValue<IValidationSupport.CodeValidationResult>(outcome);
                break;
            }
            this.putInCache(key, retVal);
        }
        return retVal.getValue();
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        String url = CommonCodeSystemsTerminologyService.getValueSetUrl(this.getFhirContext(), theValueSet);
        ValidateCodeKey key = null;
        CacheValue<Object> retVal = null;
        if (StringUtils.isNotBlank((CharSequence)url)) {
            key = new ValidateCodeKey(theOptions, theCodeSystem, theCode, theDisplay, url);
            retVal = this.getFromCache(key);
        }
        if (retVal != null) {
            return (IValidationSupport.CodeValidationResult)retVal.getValue();
        }
        retVal = CacheValue.empty();
        for (IValidationSupport next : this.myChain) {
            IValidationSupport.CodeValidationResult outcome;
            if (!StringUtils.isBlank((CharSequence)url) && !this.isValueSetSupported(theValidationSupportContext, next, url) || (outcome = next.validateCodeInValueSet(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, theValueSet)) == null) continue;
            ourLog.debug("Code {}|{} '{}' in ValueSet {} validated by {}", new Object[]{theCodeSystem, theCode, theDisplay, theValueSet.getIdElement(), next.getName()});
            retVal = new CacheValue<IValidationSupport.CodeValidationResult>(outcome);
            break;
        }
        if (key != null) {
            this.putInCache(key, retVal);
        }
        return (IValidationSupport.CodeValidationResult)retVal.getValue();
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, @Nonnull LookupCodeRequest theLookupCodeRequest) {
        LookupCodeKey key = new LookupCodeKey(theLookupCodeRequest);
        CacheValue<Object> retVal = this.getFromCache(key);
        if (retVal == null) {
            retVal = CacheValue.empty();
            for (IValidationSupport next : this.myChain) {
                String system = theLookupCodeRequest.getSystem();
                String code = theLookupCodeRequest.getCode();
                String displayLanguage = theLookupCodeRequest.getDisplayLanguage();
                if (!this.isCodeSystemSupported(theValidationSupportContext, next, system)) continue;
                IValidationSupport.LookupCodeResult lookupCodeResult = next.lookupCode(theValidationSupportContext, theLookupCodeRequest);
                if (lookupCodeResult == null) {
                    lookupCodeResult = next.lookupCode(theValidationSupportContext, system, code, displayLanguage);
                }
                if (lookupCodeResult == null) continue;
                ourLog.debug("Code {}|{}{} {} by {}", new Object[]{system, code, StringUtils.isBlank((CharSequence)displayLanguage) ? "" : " (" + theLookupCodeRequest.getDisplayLanguage() + ")", lookupCodeResult.isFound() ? "found" : "not found", next.getName()});
                retVal = new CacheValue<IValidationSupport.LookupCodeResult>(lookupCodeResult);
                break;
            }
            this.putInCache(key, retVal);
        }
        return retVal.getValue();
    }

    public List<IValidationSupport> getValidationSupports() {
        return Collections.unmodifiableList(this.myChain);
    }

    private <T> void putInCache(BaseKey<T> key, CacheValue<T> theValue) {
        if (this.myExpiringCache != null) {
            this.myExpiringCache.put(key, theValue);
        }
    }

    private <T> CacheValue<T> getFromCache(BaseKey<T> key) {
        if (this.myExpiringCache != null) {
            return (CacheValue)this.myExpiringCache.getIfPresent(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IBaseResource> getFromCacheWithAsyncRefresh(FetchAllKey theKey, Supplier<List<IBaseResource>> theLoader) {
        if (this.myExpiringCache == null || this.myNonExpiringCache == null) {
            return theLoader.get();
        }
        CacheValue<List<IBaseResource>> retVal = this.getFromCache(theKey);
        if (retVal == null) {
            retVal = (CacheValue<List<IBaseResource>>)this.myNonExpiringCache.get(theKey);
            if (retVal != null) {
                Runnable loaderTask = () -> {
                    List loadedItem = (List)theLoader.get();
                    CacheValue<List> value = new CacheValue<List>(loadedItem);
                    this.myNonExpiringCache.put(theKey, value);
                    this.putInCache(theKey, value);
                };
                List returnValue = (List)retVal.getValue();
                this.myBackgroundExecutor.execute(loaderTask);
                return returnValue;
            }
            ValidationSupportChain validationSupportChain = this;
            synchronized (validationSupportChain) {
                retVal = this.getFromCache(theKey);
                if (retVal == null) {
                    StopWatch sw = new StopWatch();
                    ourLog.info("Performing initial retrieval for non-expiring cache: {}", (Object)theKey);
                    retVal = new CacheValue<List<IBaseResource>>(theLoader.get());
                    ourLog.info("Initial retrieval for non-expiring cache {} succeeded in {}", (Object)theKey, (Object)sw);
                    this.myNonExpiringCache.put(theKey, retVal);
                    this.putInCache(theKey, retVal);
                }
            }
        }
        return retVal.getValue();
    }

    public void logCacheSizes() {
        String b = "Cache sizes:\n * Expiring: " + String.valueOf(this.myExpiringCache != null ? Long.valueOf(this.myExpiringCache.estimatedSize()) : "(disabled)") + "\n * Non-Expiring: " + String.valueOf(this.myNonExpiringCache != null ? Integer.valueOf(this.myNonExpiringCache.size()) : "(disabled)");
        ourLog.info(b);
    }

    long getMetricExpiringCacheEntries() {
        if (this.myExpiringCache != null) {
            return this.myExpiringCache.estimatedSize();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMetricNonExpiringCacheEntries() {
        Map<String, IBaseResource> map = this.myStructureDefinitionsByUrl;
        synchronized (map) {
            int size = this.myNonExpiringCache != null ? this.myNonExpiringCache.size() : 0;
            return size + this.myStructureDefinitionsAsList.size();
        }
    }

    int getMetricExpiringCacheMaxSize() {
        return this.myCacheConfiguration.getCacheSize();
    }

    public static class CacheConfiguration {
        private long myCacheTimeout;
        private int myCacheSize;

        private CacheConfiguration() {
        }

        public long getCacheTimeout() {
            return this.myCacheTimeout;
        }

        public CacheConfiguration setCacheTimeout(Duration theCacheTimeout) {
            Validate.isTrue((theCacheTimeout.toMillis() >= 0L ? 1 : 0) != 0, (String)"Cache timeout must not be negative", (Object[])new Object[0]);
            this.myCacheTimeout = theCacheTimeout.toMillis();
            return this;
        }

        public int getCacheSize() {
            return this.myCacheSize;
        }

        public CacheConfiguration setCacheSize(int theCacheSize) {
            Validate.isTrue((theCacheSize >= 0 ? 1 : 0) != 0, (String)"Cache size must not be negative", (Object[])new Object[0]);
            this.myCacheSize = theCacheSize;
            return this;
        }

        public static CacheConfiguration defaultValues() {
            return new CacheConfiguration().setCacheTimeout(Duration.ofMinutes(10L)).setCacheSize(5000);
        }

        public static CacheConfiguration disabled() {
            return new CacheConfiguration().setCacheSize(0).setCacheTimeout(Duration.ofMillis(0L));
        }
    }

    static class TranslateConceptKey
    extends BaseKey<TranslateConceptResults> {
        private final IValidationSupport.TranslateCodeRequest myRequest;
        private final int myHashCode;

        private TranslateConceptKey(IValidationSupport.TranslateCodeRequest theRequest) {
            this.myRequest = theRequest;
            this.myHashCode = Objects.hash("TranslateConcept", this.myRequest);
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof TranslateConceptKey)) {
                return false;
            }
            TranslateConceptKey that = (TranslateConceptKey)theO;
            return Objects.equals(this.myRequest, that.myRequest);
        }

        @Override
        public int hashCode() {
            return this.myHashCode;
        }
    }

    static abstract class BaseKey<V> {
        BaseKey() {
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    private static class CacheValue<T> {
        private static final CacheValue<IValidationSupport.CodeValidationResult> EMPTY = new CacheValue<Object>(null);
        private final T myValue;

        private CacheValue(T theValue) {
            this.myValue = theValue;
        }

        public T getValue() {
            return this.myValue;
        }

        public static <T> CacheValue<T> empty() {
            return EMPTY;
        }
    }

    static class IsValueSetSupportedKey
    extends BaseKey<Boolean> {
        private final String myValueSetUrl;
        private final IValidationSupport myValidationSupport;
        private final int myHashCode;

        private IsValueSetSupportedKey(IValidationSupport theValidationSupport, String theValueSetUrl) {
            this.myValidationSupport = theValidationSupport;
            this.myValueSetUrl = theValueSetUrl;
            this.myHashCode = Objects.hash("IsValueSetSupported", theValidationSupport, this.myValueSetUrl);
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof IsValueSetSupportedKey)) {
                return false;
            }
            IsValueSetSupportedKey that = (IsValueSetSupportedKey)theO;
            return this.myValidationSupport == that.myValidationSupport && Objects.equals(this.myValueSetUrl, that.myValueSetUrl);
        }

        @Override
        public int hashCode() {
            return this.myHashCode;
        }
    }

    static class ExpandValueSetKey
    extends BaseKey<IValidationSupport.ValueSetExpansionOutcome> {
        private final ValueSetExpansionOptions myOptions;
        private final String myId;
        private final String myUrl;
        private final int myHashCode;

        private ExpandValueSetKey(ValueSetExpansionOptions theOptions, String theId, String theUrl) {
            this.myOptions = theOptions;
            this.myId = theId;
            this.myUrl = theUrl;
            this.myHashCode = Objects.hash(this.myOptions, this.myId, this.myUrl);
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof ExpandValueSetKey)) {
                return false;
            }
            ExpandValueSetKey that = (ExpandValueSetKey)theO;
            return Objects.equals(this.myOptions, that.myOptions) && Objects.equals(this.myId, that.myId) && Objects.equals(this.myUrl, that.myUrl);
        }

        @Override
        public int hashCode() {
            return this.myHashCode;
        }
    }

    static class FetchAllKey
    extends BaseKey<List<IBaseResource>> {
        private final TypeEnum myType;
        private final int myHashCode;

        private FetchAllKey(TypeEnum theType) {
            this.myType = theType;
            this.myHashCode = Objects.hash(new Object[]{this.myType});
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof FetchAllKey)) {
                return false;
            }
            FetchAllKey that = (FetchAllKey)theO;
            return this.myType == that.myType;
        }

        @Override
        public int hashCode() {
            return this.myHashCode;
        }

        private static enum TypeEnum {
            ALL,
            ALL_STRUCTUREDEFINITIONS,
            ALL_NON_BASE_STRUCTUREDEFINITIONS,
            ALL_SEARCHPARAMETERS;

        }
    }

    static class ResourceByUrlKey<T>
    extends BaseKey<T> {
        private final TypeEnum myType;
        private final String myUrl;
        private final int myHashCode;

        private ResourceByUrlKey(TypeEnum theType, String theUrl) {
            this(theType, theUrl, Objects.hash(new Object[]{"ResourceByUrl", theType, theUrl}));
        }

        private ResourceByUrlKey(TypeEnum theType, String theUrl, int theHashCode) {
            this.myType = theType;
            this.myUrl = theUrl;
            this.myHashCode = theHashCode;
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof ResourceByUrlKey)) {
                return false;
            }
            ResourceByUrlKey that = (ResourceByUrlKey)theO;
            return this.myType == that.myType && Objects.equals(this.myUrl, that.myUrl);
        }

        @Override
        public int hashCode() {
            return this.myHashCode;
        }

        private static enum TypeEnum {
            CODESYSTEM,
            VALUESET,
            RESOURCE,
            BINARY,
            STRUCTUREDEFINITION;

        }
    }

    static class TypedResourceByUrlKey<T>
    extends ResourceByUrlKey<T> {
        private final Class<?> myType;

        private TypedResourceByUrlKey(Class<?> theType, String theUrl) {
            super(ResourceByUrlKey.TypeEnum.RESOURCE, theUrl, Objects.hash("TypedResourceByUrl", theType, theUrl));
            this.myType = theType;
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof TypedResourceByUrlKey)) {
                return false;
            }
            if (!super.equals(theO)) {
                return false;
            }
            TypedResourceByUrlKey that = (TypedResourceByUrlKey)theO;
            return Objects.equals(this.myType, that.myType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myType);
        }
    }

    static class IsCodeSystemSupportedKey
    extends BaseKey<Boolean> {
        private final String myCodeSystemUrl;
        private final IValidationSupport myValidationSupport;
        private final int myHashCode;

        private IsCodeSystemSupportedKey(IValidationSupport theValidationSupport, String theCodeSystemUrl) {
            this.myValidationSupport = theValidationSupport;
            this.myCodeSystemUrl = theCodeSystemUrl;
            this.myHashCode = Objects.hash("IsCodeSystemSupported", theValidationSupport, this.myCodeSystemUrl);
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof IsCodeSystemSupportedKey)) {
                return false;
            }
            IsCodeSystemSupportedKey that = (IsCodeSystemSupportedKey)theO;
            return this.myValidationSupport == that.myValidationSupport && Objects.equals(this.myCodeSystemUrl, that.myCodeSystemUrl);
        }

        @Override
        public int hashCode() {
            return this.myHashCode;
        }
    }

    static class ValidateCodeKey
    extends BaseKey<IValidationSupport.CodeValidationResult> {
        private final String mySystem;
        private final String myCode;
        private final String myDisplay;
        private final String myValueSetUrl;
        private final int myHashCode;
        private final ConceptValidationOptions myOptions;

        private ValidateCodeKey(ConceptValidationOptions theOptions, String theSystem, String theCode, String theDisplay, String theValueSetUrl) {
            this.myOptions = ConceptValidationOptions.copy((ConceptValidationOptions)theOptions);
            this.mySystem = theSystem;
            this.myCode = theCode;
            this.myDisplay = theDisplay;
            this.myValueSetUrl = theValueSetUrl;
            this.myHashCode = Objects.hash("ValidateCodeKey", this.myOptions, this.mySystem, this.myCode, this.myDisplay, this.myValueSetUrl);
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof ValidateCodeKey)) {
                return false;
            }
            ValidateCodeKey that = (ValidateCodeKey)theO;
            return Objects.equals(this.myOptions, that.myOptions) && Objects.equals(this.mySystem, that.mySystem) && Objects.equals(this.myCode, that.myCode) && Objects.equals(this.myDisplay, that.myDisplay) && Objects.equals(this.myValueSetUrl, that.myValueSetUrl);
        }

        @Override
        public int hashCode() {
            return this.myHashCode;
        }

        public String toString() {
            return "ValidateCodeKey{mySystem='" + this.mySystem + "', myCode='" + this.myCode + "', myDisplay='" + this.myDisplay + "', myValueSetUrl='" + this.myValueSetUrl + "', myHashCode=" + this.myHashCode + "', myOptions=" + String.valueOf(this.myOptions) + "}";
        }
    }

    static class LookupCodeKey
    extends BaseKey<IValidationSupport.LookupCodeResult> {
        private final LookupCodeRequest myRequest;
        private final int myHashCode;

        private LookupCodeKey(LookupCodeRequest theRequest) {
            this.myRequest = theRequest;
            this.myHashCode = Objects.hash("LookupCode", this.myRequest);
        }

        @Override
        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof LookupCodeKey)) {
                return false;
            }
            LookupCodeKey that = (LookupCodeKey)theO;
            return Objects.equals(this.myRequest, that.myRequest);
        }

        @Override
        public int hashCode() {
            return this.myHashCode;
        }
    }
}

