/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.util.Logs;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.validator.ProfileKnowledgeWorkerR5;
import org.hl7.fhir.common.hapi.validation.validator.WorkerContextValidationSupportAdapter;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.slf4j.Logger;

public class SnapshotGeneratingValidationSupport
implements IValidationSupport {
    @VisibleForTesting
    public static final String GENERATING_SNAPSHOT_LOG_MSG = "Generating snapshot for StructureDefinition: {}";
    public static final String CURRENTLY_GENERATING_USERDATA_KEY = SnapshotGeneratingValidationSupport.class.getName() + "_CURRENTLY_GENERATING";
    private static final Logger ourLog = Logs.getTerminologyTroubleshootingLog();
    private final FhirContext myCtx;
    private final VersionCanonicalizer myVersionCanonicalizer;
    private final IWorkerContext myWorkerContext;

    public SnapshotGeneratingValidationSupport(FhirContext theFhirContext) {
        this(theFhirContext, null);
    }

    public SnapshotGeneratingValidationSupport(FhirContext theFhirContext, IWorkerContext theWorkerContext) {
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        this.myCtx = theFhirContext;
        this.myVersionCanonicalizer = new VersionCanonicalizer(theFhirContext);
        this.myWorkerContext = theWorkerContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBaseResource generateSnapshot(ValidationSupportContext theValidationSupportContext, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        IBaseResource iBaseResource = theInput;
        synchronized (iBaseResource) {
            if (theInput.getUserData(CURRENTLY_GENERATING_USERDATA_KEY) != null) {
                String url = this.myCtx.newTerser().getSinglePrimitiveValueOrNull((IBase)theInput, "url");
                ourLog.info("Detected circular dependency, already generating snapshot for: {}", (Object)url);
                return theInput;
            }
            try {
                StructureDefinition base;
                theInput.setUserData(CURRENTLY_GENERATING_USERDATA_KEY, (Object)CURRENTLY_GENERATING_USERDATA_KEY);
                IBaseResource inputClone = this.myCtx.newTerser().clone(theInput);
                StructureDefinition inputCanonical = this.myVersionCanonicalizer.structureDefinitionToCanonical(inputClone);
                String baseDefinition = inputCanonical.getBaseDefinition();
                if (StringUtils.isBlank((CharSequence)baseDefinition)) {
                    throw new PreconditionFailedException(Msg.code((int)704) + "StructureDefinition[id=" + inputCanonical.getIdElement().getId() + ", url=" + inputCanonical.getUrl() + "] has no base");
                }
                IWorkerContext workerContext = this.myWorkerContext;
                if (workerContext == null) {
                    workerContext = new WorkerContextValidationSupportAdapter(theValidationSupportContext.getRootValidationSupport());
                }
                if ((base = (StructureDefinition)workerContext.fetchResource(StructureDefinition.class, baseDefinition)) == null) {
                    throw new PreconditionFailedException(Msg.code((int)705) + "Unknown base definition: " + baseDefinition);
                }
                ArrayList messages = new ArrayList();
                ProfileKnowledgeWorkerR5 profileKnowledgeProvider = new ProfileKnowledgeWorkerR5(this.myCtx);
                ProfileUtilities profileUtilities = new ProfileUtilities(workerContext, messages, (ProfileKnowledgeProvider)profileKnowledgeProvider);
                ourLog.info(GENERATING_SNAPSHOT_LOG_MSG, (Object)inputCanonical.getUrl());
                profileUtilities.generateSnapshot(base, inputCanonical, theUrl, theWebUrl, theProfileName);
                IBaseResource iBaseResource2 = this.myVersionCanonicalizer.structureDefinitionFromCanonical(inputCanonical);
                return iBaseResource2;
            }
            catch (BaseServerResponseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalErrorException(Msg.code((int)707) + "Failed to generate snapshot", (Throwable)e);
            }
            finally {
                theInput.setUserData(CURRENTLY_GENERATING_USERDATA_KEY, null);
            }
        }
    }

    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    public String getName() {
        return String.valueOf(this.getFhirContext().getVersion().getVersion()) + " Snapshot Generating Validation Support";
    }
}

