/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.Logs;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.common.hapi.validation.support.SnapshotGeneratingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.slf4j.Logger;

public class VersionSpecificWorkerContextWrapper
extends I18nBase
implements IWorkerContext {
    private static final Logger ourLog = Logs.getTerminologyTroubleshootingLog();
    private static final String TO_CANONICAL_USERDATA_KEY = VersionSpecificWorkerContextWrapper.class.getName() + "_TO_CANONICAL_USERDATA_KEY";
    private static final String FROM_CANONICAL_USERDATA_KEY = VersionSpecificWorkerContextWrapper.class.getName() + "_FROM_CANONICAL_USERDATA_KEY";
    public static final FhirContext FHIR_CONTEXT_R5 = FhirContext.forR5();
    private final ValidationSupportContext myValidationSupportContext;
    private VersionCanonicalizer myVersionCanonicalizer;
    private volatile List<StructureDefinition> myAllStructures;
    private volatile Set<String> myAllPrimitiveTypes;
    private Parameters myExpansionProfile;
    private volatile FHIRPathEngine myFHIRPathEngine;

    public VersionSpecificWorkerContextWrapper(ValidationSupportContext theValidationSupportContext, VersionCanonicalizer theVersionCanonicalizer) {
        this.myValidationSupportContext = theValidationSupportContext;
        this.myVersionCanonicalizer = theVersionCanonicalizer;
        this.setValidationMessageLanguage(this.getLocale());
    }

    @VisibleForTesting
    public void setVersionCanonicalizer(VersionCanonicalizer theVersionCanonicalizer) {
        this.myVersionCanonicalizer = theVersionCanonicalizer;
    }

    public Set<String> getBinaryKeysAsSet() {
        throw new UnsupportedOperationException(Msg.code((int)2118));
    }

    public boolean hasBinaryKey(String s) {
        return this.myValidationSupportContext.getRootValidationSupport().fetchBinary(s) != null;
    }

    public byte[] getBinaryForKey(String s) {
        return this.myValidationSupportContext.getRootValidationSupport().fetchBinary(s);
    }

    public int loadFromPackage(NpmPackage pi, IContextResourceLoader loader) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)652));
    }

    public int loadFromPackage(NpmPackage pi, IContextResourceLoader loader, List<String> types) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)653));
    }

    public int loadFromPackageAndDependencies(NpmPackage pi, IContextResourceLoader loader, BasePackageCacheManager pcm) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)654));
    }

    public boolean hasPackage(String id, String ver) {
        throw new UnsupportedOperationException(Msg.code((int)655));
    }

    public boolean hasPackage(PackageInformation packageInformation) {
        return false;
    }

    public PackageInformation getPackage(String id, String ver) {
        return null;
    }

    public int getClientRetryCount() {
        throw new UnsupportedOperationException(Msg.code((int)656));
    }

    public IWorkerContext setClientRetryCount(int value) {
        throw new UnsupportedOperationException(Msg.code((int)657));
    }

    public TimeTracker clock() {
        return null;
    }

    public IWorkerContextManager.IPackageLoadingTracker getPackageTracker() {
        throw new UnsupportedOperationException(Msg.code((int)2235));
    }

    public IWorkerContext setPackageTracker(IWorkerContextManager.IPackageLoadingTracker packageTracker) {
        throw new UnsupportedOperationException(Msg.code((int)2266));
    }

    public String getSpecUrl() {
        return "";
    }

    public PEBuilder getProfiledElementBuilder(PEBuilder.PEElementPropertiesPolicy thePEElementPropertiesPolicy, boolean theB) {
        throw new UnsupportedOperationException(Msg.code((int)2264));
    }

    public PackageInformation getPackageForUrl(String s) {
        throw new UnsupportedOperationException(Msg.code((int)2236));
    }

    public Parameters getExpansionParameters() {
        if (Objects.isNull(this.myExpansionProfile)) {
            this.myExpansionProfile = new Parameters();
        }
        return this.myExpansionProfile;
    }

    public void setExpansionParameters(Parameters expParameters) {
        this.setExpansionProfile(expParameters);
    }

    public void setExpansionProfile(Parameters expParameters) {
        this.myExpansionProfile = expParameters;
    }

    private List<StructureDefinition> allStructureDefinitions() {
        List<Object> retVal = this.myAllStructures;
        if (retVal == null) {
            List allStructureDefinitions = this.myValidationSupportContext.getRootValidationSupport().fetchAllStructureDefinitions();
            assert (allStructureDefinitions != null);
            retVal = allStructureDefinitions.stream().map(arg_0 -> ((VersionCanonicalizer)this.myVersionCanonicalizer).structureDefinitionToCanonical(arg_0)).collect(Collectors.toList());
            this.myAllStructures = retVal;
            try {
                for (IBaseResource next : allStructureDefinitions) {
                    Resource converted = this.convertToCanonicalVersionAndGenerateSnapshot(next, false);
                    retVal.add((StructureDefinition)converted);
                }
                this.myAllStructures = retVal;
            }
            catch (Exception e) {
                ourLog.error("Failure during snapshot generation", (Throwable)e);
                this.myAllStructures = null;
            }
        }
        return retVal;
    }

    public void cacheResource(Resource res) {
    }

    public void cacheResourceFromPackage(Resource res, PackageInformation packageDetails) throws FHIRException {
    }

    public void cachePackage(PackageInformation packageInformation) {
    }

    @Nonnull
    private ValidationResult convertValidationResult(String theSystem, @Nullable IValidationSupport.CodeValidationResult theResult) {
        ValidationResult retVal = null;
        if (theResult != null) {
            String code = theResult.getCode();
            String display = theResult.getDisplay();
            String issueSeverityCode = theResult.getSeverityCode();
            String message = theResult.getMessage();
            ValidationMessage.IssueSeverity issueSeverity = null;
            if (issueSeverityCode != null) {
                issueSeverity = ValidationMessage.IssueSeverity.fromCode((String)issueSeverityCode);
            } else if (StringUtils.isNotBlank((CharSequence)message)) {
                issueSeverity = ValidationMessage.IssueSeverity.INFORMATION;
            }
            CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = null;
            if (code != null) {
                conceptDefinitionComponent = new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(display);
            }
            retVal = new ValidationResult(issueSeverity, message, theSystem, theResult.getCodeSystemVersion(), conceptDefinitionComponent, display, this.getIssuesForCodeValidation(theResult.getIssues()));
        }
        if (retVal == null) {
            retVal = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Validation failed", null);
        }
        return retVal;
    }

    private List<OperationOutcome.OperationOutcomeIssueComponent> getIssuesForCodeValidation(List<IValidationSupport.CodeValidationIssue> theIssues) {
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issueComponents = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        for (IValidationSupport.CodeValidationIssue issue : theIssues) {
            OperationOutcome.IssueSeverity severity = OperationOutcome.IssueSeverity.fromCode((String)issue.getSeverity().getCode());
            OperationOutcome.IssueType issueType = OperationOutcome.IssueType.fromCode((String)issue.getType().getCode());
            String diagnostics = issue.getDiagnostics();
            IValidationSupport.CodeValidationIssueDetails details = issue.getDetails();
            CodeableConcept codeableConcept = new CodeableConcept().setText(details.getText());
            details.getCodings().forEach(detailCoding -> codeableConcept.addCoding().setSystem(detailCoding.getSystem()).setCode(detailCoding.getCode()));
            OperationOutcome.OperationOutcomeIssueComponent issueComponent = new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(severity).setCode(issueType).setDetails(codeableConcept).setDiagnostics(diagnostics);
            issueComponent.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id").setValue((DataType)new StringType("Terminology_PassThrough_TX_Message"));
            issueComponents.add(issueComponent);
        }
        return issueComponents;
    }

    public ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean Hierarchical) {
        IBaseResource convertedSource;
        try {
            convertedSource = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(source);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)661) + String.valueOf((Object)e));
        }
        IValidationSupport.ValueSetExpansionOutcome expanded = this.myValidationSupportContext.getRootValidationSupport().expandValueSet(this.myValidationSupportContext, null, convertedSource);
        ValueSet convertedResult = null;
        if (expanded.getValueSet() != null) {
            try {
                convertedResult = this.myVersionCanonicalizer.valueSetToValidatorCanonical(expanded.getValueSet());
            }
            catch (FHIRException e) {
                throw new InternalErrorException(Msg.code((int)662) + String.valueOf((Object)e));
            }
        }
        String error = expanded.getError();
        TerminologyServiceErrorClass result = null;
        return new ValueSetExpansionOutcome(convertedResult, error, result, expanded.getErrorIsFromServer());
    }

    public ValueSetExpansionOutcome expandVS(ValueSet valueSet, boolean b, boolean b1, int i) {
        return null;
    }

    public ValueSetExpansionOutcome expandVS(Resource src, ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean Hierarchical) {
        ValueSet valueSet = this.fetchResource(ValueSet.class, binding.getValueSet(), src);
        return this.expandVS(valueSet, cacheOk, Hierarchical);
    }

    public ValueSetExpansionOutcome expandVS(IWorkerContext.ITerminologyOperationDetails iTerminologyOperationDetails, ValueSet.ConceptSetComponent conceptSetComponent, boolean b, boolean b1) throws TerminologyServiceException {
        return null;
    }

    public Locale getLocale() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getLocalizer().getLocale();
    }

    public void setLocale(Locale locale) {
    }

    public CodeSystem fetchCodeSystem(String system) {
        IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchCodeSystem(system);
        if (fetched == null) {
            return null;
        }
        try {
            return this.myVersionCanonicalizer.codeSystemToValidatorCanonical(fetched);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)665) + String.valueOf((Object)e));
        }
    }

    public CodeSystem fetchCodeSystem(String system, String verison) {
        IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchCodeSystem(system);
        if (fetched == null) {
            return null;
        }
        try {
            return this.myVersionCanonicalizer.codeSystemToValidatorCanonical(fetched);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)1992) + String.valueOf((Object)e));
        }
    }

    public CodeSystem fetchCodeSystem(String system, FhirPublication fhirVersion) {
        return null;
    }

    public CodeSystem fetchCodeSystem(String system, String version, FhirPublication fhirVersion) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, String version) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, FhirPublication fhirVersion) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, String version, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResourceRaw(Class<T> class_, String uri) {
        return this.fetchResource(class_, uri);
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String theUri) {
        if (StringUtils.isBlank((CharSequence)theUri)) {
            return null;
        }
        if (StringUtils.countMatches((CharSequence)theUri, (CharSequence)"|") > 1) {
            ourLog.warn("Unrecognized profile uri: {}", (Object)theUri);
        }
        String resourceType = VersionSpecificWorkerContextWrapper.getResourceType(class_);
        Resource retVal = (Resource)this.fetchResource(resourceType, theUri);
        return (T)retVal;
    }

    public Resource fetchResourceById(String type, String uri) {
        throw new UnsupportedOperationException(Msg.code((int)666));
    }

    public Resource fetchResourceById(String type, String uri, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        T retVal = this.fetchResource(class_, uri);
        if (retVal == null) {
            throw new FHIRException(Msg.code((int)667) + "Can not find resource of type " + class_.getSimpleName() + " with uri " + uri);
        }
        return retVal;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version) {
        return this.fetchResource(class_, uri + "|" + version);
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, Resource canonicalForSource) {
        return this.fetchResource(class_, uri);
    }

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> class_, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri, Resource sourceOfReference) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)2214));
    }

    public List<String> getResourceNames() {
        return new ArrayList<String>(this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceTypes());
    }

    public List<String> getResourceNames(FhirPublication fhirVersion) {
        return null;
    }

    public Set<String> getResourceNamesAsSet() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceTypes();
    }

    public Set<String> getResourceNamesAsSet(FhirPublication theFhirVersion) {
        return null;
    }

    public StructureDefinition fetchTypeDefinition(String theTypeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + theTypeName);
    }

    public StructureDefinition fetchTypeDefinition(String theTypeName, FhirPublication theFhirVersion) {
        return null;
    }

    public List<StructureDefinition> fetchTypeDefinitions(String theTypeName) {
        ArrayList<StructureDefinition> allStructures = new ArrayList<StructureDefinition>(this.allStructureDefinitions());
        allStructures.removeIf(sd -> !sd.hasType() || !sd.getType().equals(theTypeName));
        return allStructures;
    }

    public List<StructureDefinition> fetchTypeDefinitions(String theTypeName, FhirPublication theFhirVersion) {
        return null;
    }

    public boolean isPrimitiveType(String theType) {
        return this.allPrimitiveTypes().contains(theType);
    }

    private Set<String> allPrimitiveTypes() {
        Set retVal = this.myAllPrimitiveTypes;
        if (retVal == null) {
            this.myAllPrimitiveTypes = retVal = this.allStructureDefinitions().stream().filter(structureDefinition -> structureDefinition.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE).map(StructureDefinition::getName).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        }
        return retVal;
    }

    public boolean isDataType(String theType) {
        return !this.isPrimitiveType(theType);
    }

    public UcumService getUcumService() {
        throw new UnsupportedOperationException(Msg.code((int)676));
    }

    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException(Msg.code((int)677));
    }

    public String getVersion() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getVersion().getVersion().getFhirVersionString();
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return false;
        }
        String resourceType = VersionSpecificWorkerContextWrapper.getResourceType(class_);
        return this.fetchResource(resourceType, uri) != null;
    }

    private static <T extends Resource> String getResourceType(Class<T> theClass) {
        if (theClass.getSimpleName().equals("Resource")) {
            return "Resource";
        }
        return FHIR_CONTEXT_R5.getResourceType(theClass);
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri, Resource sourceOfReference) {
        return false;
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri, FhirPublication fhirVersion) {
        return false;
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public Set<String> getCodeSystemsUsed() {
        throw new UnsupportedOperationException(Msg.code((int)681));
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException(Msg.code((int)684));
    }

    public Map<String, NamingSystem> getNSUrlMap() {
        throw new UnsupportedOperationException(Msg.code((int)2265));
    }

    public ILoggingService getLogger() {
        return null;
    }

    public void setLogger(ILoggingService logger) {
        throw new UnsupportedOperationException(Msg.code((int)687));
    }

    public boolean supportsSystem(String system) {
        return this.myValidationSupportContext.getRootValidationSupport().isCodeSystemSupported(this.myValidationSupportContext, system);
    }

    public boolean supportsSystem(String system, FhirPublication fhirVersion) throws TerminologyServiceException {
        return this.supportsSystem(system);
    }

    public ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean heiarchical, boolean incompleteOk) {
        return null;
    }

    public ValueSetExpansionOutcome expandVS(String s, boolean b, boolean b1, int i) {
        return null;
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String system, String version, String code, String display) {
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        return this.doValidation(null, validationOptions, system, code, display);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String version, String theCode, String display, ValueSet theValueSet) {
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        return this.doValidation(theValueSet, validationOptions, theSystem, theCode, display);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet theValueSet) {
        String system = ValidationSupportUtils.extractCodeSystemForCode((IBaseResource)theValueSet, code);
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions).setInferSystem(true);
        return this.doValidation(theValueSet, validationOptions, system, code, null);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, Coding theCoding, ValueSet theValueSet) {
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        String system = theCoding.getSystem();
        String code = theCoding.getCode();
        String display = theCoding.getDisplay();
        return this.doValidation(theValueSet, validationOptions, system, code, display);
    }

    public ValidationResult validateCode(ValidationOptions options, Coding code, ValueSet vs, ValidationContextCarrier ctxt) {
        return this.validateCode(options, code, vs);
    }

    public void validateCodeBatch(ValidationOptions options, List<? extends CodingValidationRequest> codes, ValueSet vs) {
        for (CodingValidationRequest codingValidationRequest : codes) {
            ValidationResult outcome = this.validateCode(options, codingValidationRequest.getCoding(), vs);
            codingValidationRequest.setResult(outcome);
        }
    }

    public void validateCodeBatchByRef(ValidationOptions validationOptions, List<? extends CodingValidationRequest> list, String s) {
        ValueSet valueSet = this.fetchResource(ValueSet.class, s);
        this.validateCodeBatch(validationOptions, list, valueSet);
    }

    @Nonnull
    private ValidationResult doValidation(@Nullable ValueSet theValueSet, ConceptValidationOptions theValidationOptions, String theSystem, String theCode, String theDisplay) {
        IBaseResource convertedVs = this.getOrConvertValueSet(theValueSet);
        IValidationSupport.CodeValidationResult result = convertedVs != null ? this.validateCodeInValueSet(convertedVs, theValidationOptions, theSystem, theCode, theDisplay) : this.validateCodeInCodeSystem(theValidationOptions, theSystem, theCode, theDisplay);
        return this.convertValidationResult(theSystem, result);
    }

    private IBaseResource getOrConvertValueSet(ValueSet theValueSet) {
        if (theValueSet == null) {
            return null;
        }
        IBaseResource convertedValueSet = (IBaseResource)theValueSet.getUserData(FROM_CANONICAL_USERDATA_KEY);
        if (convertedValueSet != null) {
            IBaseResource finalConvertedValueSet = convertedValueSet;
            ourLog.atDebug().setMessage("Using user data - Key: {}, ValueSet: {}").addArgument((Object)FROM_CANONICAL_USERDATA_KEY).addArgument(() -> this.toResourceId(finalConvertedValueSet)).log();
            return convertedValueSet;
        }
        convertedValueSet = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(theValueSet);
        this.cacheConvertedValueSet(theValueSet, convertedValueSet);
        return convertedValueSet;
    }

    private void cacheConvertedValueSet(ValueSet theValueSet, IBaseResource theConvertedValueSet) {
        if (theValueSet == null || theConvertedValueSet == null) {
            return;
        }
        theValueSet.setUserData(FROM_CANONICAL_USERDATA_KEY, (Object)theConvertedValueSet);
        ourLog.atDebug().setMessage("Added user data - Key: {}, ValueSet: {}").addArgument((Object)FROM_CANONICAL_USERDATA_KEY).addArgument(() -> this.toResourceId(theConvertedValueSet)).log();
    }

    @Nullable
    private String toResourceId(IBaseResource theResource) {
        if (theResource == null) {
            return "unknown";
        }
        if (theResource.getIdElement() == null) {
            return theResource.fhirType() + "/";
        }
        return theResource.getIdElement().getIdPart();
    }

    private IValidationSupport.CodeValidationResult validateCodeInValueSet(IBaseResource theValueSet, ConceptValidationOptions theValidationOptions, String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = this.myValidationSupportContext.getRootValidationSupport().validateCodeInValueSet(this.myValidationSupportContext, theValidationOptions, theSystem, theCode, theDisplay, theValueSet);
        if (result != null && StringUtils.isNotBlank((CharSequence)theSystem)) {
            IValidationSupport.CodeValidationResult codeSystemResult = this.validateCodeInCodeSystem(theValidationOptions, theSystem, theCode, theDisplay);
            boolean valueSetResultContainsInvalidDisplay = result.getIssues().stream().anyMatch(VersionSpecificWorkerContextWrapper::hasInvalidDisplayDetailCode);
            if (codeSystemResult != null) {
                for (IValidationSupport.CodeValidationIssue codeValidationIssue : codeSystemResult.getIssues()) {
                    if (VersionSpecificWorkerContextWrapper.hasInvalidDisplayDetailCode(codeValidationIssue) && valueSetResultContainsInvalidDisplay) continue;
                    result.addIssue(codeValidationIssue);
                }
            }
        }
        return result;
    }

    private static boolean hasInvalidDisplayDetailCode(IValidationSupport.CodeValidationIssue theIssue) {
        return theIssue.hasIssueDetailCode(IValidationSupport.CodeValidationIssueCoding.INVALID_DISPLAY.getCode());
    }

    private IValidationSupport.CodeValidationResult validateCodeInCodeSystem(ConceptValidationOptions theValidationOptions, String theSystem, String theCode, String theDisplay) {
        return this.myValidationSupportContext.getRootValidationSupport().validateCode(this.myValidationSupportContext, theValidationOptions, theSystem, theCode, theDisplay, null);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept code, ValueSet theVs) {
        ArrayList<ValidationResult> validationResultsOk = new ArrayList<ValidationResult>();
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        for (Coding next : code.getCoding()) {
            ValidationResult retVal;
            if (!next.hasSystem()) {
                String message = "Coding has no system. A code with no system has no defined meaning, and it cannot be validated. A system should be provided";
                OperationOutcome.OperationOutcomeIssueComponent issue = new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(OperationOutcome.IssueSeverity.WARNING).setCode(OperationOutcome.IssueType.NOTFOUND).setDiagnostics(message).setDetails(new CodeableConcept().setText(message));
                issues.add(issue);
            }
            if ((retVal = this.validateCode(theOptions, next, theVs)).isOk()) {
                validationResultsOk.add(retVal);
                continue;
            }
            for (OperationOutcome.OperationOutcomeIssueComponent issue : retVal.getIssues()) {
                issues.add(issue);
            }
        }
        if (code.getCoding().size() > 0 && (!this.myValidationSupportContext.isCodeableConceptValidationSuccessfulIfNotAllCodingsAreValid() ? validationResultsOk.size() == code.getCoding().size() : validationResultsOk.size() > 0)) {
            return (ValidationResult)validationResultsOk.get(0);
        }
        return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, null, issues);
    }

    private static OperationOutcome.OperationOutcomeIssueComponent getOperationOutcomeTxIssueComponent(String message, OperationOutcome.IssueType issueCode, String txIssueTypeCode) {
        OperationOutcome.OperationOutcomeIssueComponent issue = new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(message);
        issue.getDetails().setText(message);
        issue.setCode(issueCode);
        issue.getDetails().addCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", txIssueTypeCode, null);
        return issue;
    }

    public void invalidateCaches() {
    }

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> theClass) {
        if (theClass.equals(StructureDefinition.class)) {
            return this.allStructureDefinitions();
        }
        throw new UnsupportedOperationException(Msg.code((int)650) + "Unable to fetch resources of type: " + String.valueOf(theClass));
    }

    public <T extends Resource> List<T> fetchResourcesByUrl(Class<T> class_, String url) {
        throw new UnsupportedOperationException(Msg.code((int)2509) + "Can't fetch all resources of url: " + url);
    }

    public boolean isForPublication() {
        return false;
    }

    public void setForPublication(boolean b) {
        throw new UnsupportedOperationException(Msg.code((int)2351));
    }

    public IWorkerContext.OIDSummary urlsForOid(String oid, String resourceType) {
        return null;
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical, Resource sourceOfReference) {
        if (canonical == null) {
            return null;
        }
        return this.fetchResource(class_, canonical, sourceOfReference);
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical) {
        if (canonical == null) {
            return null;
        }
        return this.fetchResource(class_, canonical);
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical, String version) {
        if (canonical == null) {
            return null;
        }
        return this.fetchResource(class_, canonical, version);
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }

    @Nonnull
    public static VersionSpecificWorkerContextWrapper newVersionSpecificWorkerContextWrapper(IValidationSupport theValidationSupport) {
        VersionCanonicalizer versionCanonicalizer = new VersionCanonicalizer(theValidationSupport.getFhirContext());
        return new VersionSpecificWorkerContextWrapper(new ValidationSupportContext(theValidationSupport), versionCanonicalizer);
    }

    public Boolean subsumes(ValidationOptions optionsArg, Coding parent, Coding child) {
        throw new UnsupportedOperationException(Msg.code((int)2489));
    }

    public boolean isServerSideSystem(String url) {
        return false;
    }

    private IBaseResource fetchResource(String theResourceType, String theUrl) {
        String fetchResourceName = theResourceType;
        if (this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU2 && "CodeSystem".equals(fetchResourceName)) {
            fetchResourceName = "ValueSet";
        }
        Class fetchResourceType = fetchResourceName.equals("Resource") ? null : this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceDefinition(fetchResourceName).getImplementingClass();
        IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchResource(fetchResourceType, theUrl);
        if (fetched == null) {
            return null;
        }
        return this.convertToCanonicalVersionAndGenerateSnapshot(fetched, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource convertToCanonicalVersionAndGenerateSnapshot(@Nonnull IBaseResource theResource, boolean thePropagateSnapshotException) {
        Resource canonical;
        IBaseResource iBaseResource = theResource;
        synchronized (iBaseResource) {
            canonical = (Resource)theResource.getUserData(TO_CANONICAL_USERDATA_KEY);
            if (canonical == null) {
                String sourcePackageId;
                StructureDefinition canonicalSd;
                boolean storeCanonical = true;
                canonical = this.myVersionCanonicalizer.resourceToValidatorCanonical(theResource);
                if (canonical instanceof StructureDefinition && (canonicalSd = (StructureDefinition)canonical).getSnapshot().isEmpty()) {
                    ourLog.info("Generating snapshot for StructureDefinition: {}", (Object)canonicalSd.getUrl());
                    IBaseResource resource = theResource;
                    try {
                        FhirContext fhirContext = this.myValidationSupportContext.getRootValidationSupport().getFhirContext();
                        SnapshotGeneratingValidationSupport snapshotGenerator = new SnapshotGeneratingValidationSupport(fhirContext, this, this.getFHIRPathEngine());
                        resource = snapshotGenerator.generateSnapshot(this.myValidationSupportContext, resource, "", null, "");
                        Validate.isTrue((resource != null ? 1 : 0) != 0, (String)"StructureDefinition %s has no snapshot, and no snapshot generator is configured", (Object[])new Object[]{canonicalSd.getUrl()});
                    }
                    catch (BaseServerResponseException e) {
                        if (thePropagateSnapshotException) {
                            throw e;
                        }
                        String message = e.toString();
                        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                        if (rootCause != null) {
                            message = rootCause.getMessage();
                        }
                        ourLog.warn("Failed to generate snapshot for profile with URL[{}]: {}", (Object)canonicalSd.getUrl(), (Object)message);
                        storeCanonical = false;
                    }
                    canonical = this.myVersionCanonicalizer.resourceToValidatorCanonical(resource);
                }
                if ((sourcePackageId = (String)theResource.getUserData(DefaultProfileValidationSupport.SOURCE_PACKAGE_ID)) != null) {
                    canonical.setSourcePackage(new PackageInformation(sourcePackageId, null, null, new Date()));
                }
                if (storeCanonical) {
                    theResource.setUserData(TO_CANONICAL_USERDATA_KEY, (Object)canonical);
                }
            }
        }
        return canonical;
    }

    private FHIRPathEngine getFHIRPathEngine() {
        FHIRPathEngine retVal = this.myFHIRPathEngine;
        if (retVal == null) {
            this.myFHIRPathEngine = retVal = new FHIRPathEngine((IWorkerContext)this);
        }
        return retVal;
    }

    private static class ResourceKey {
        private final int myHashCode;
        private final String myResourceName;
        private final String myUri;

        private ResourceKey(String theResourceName, String theUri) {
            this.myResourceName = theResourceName;
            this.myUri = theUri;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myResourceName).append((Object)this.myUri).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)theO;
            return new EqualsBuilder().append((Object)this.myResourceName, (Object)that.myResourceName).append((Object)this.myUri, (Object)that.myUri).isEquals();
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public String getUri() {
            return this.myUri;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

