/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.XmlUtil;
import ca.uhn.fhir.validation.IValidationContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.input.ReaderInputStream;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.r5.utils.validation.constants.IdStatus;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.ValidatorSettings;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class ValidatorWrapper {
    private static final Logger ourLog = Logs.getTerminologyTroubleshootingLog();
    private BestPracticeWarningLevel myBestPracticeWarningLevel;
    private boolean myAnyExtensionsAllowed;
    private boolean myErrorForUnknownProfiles;
    private boolean myNoTerminologyChecks;
    private boolean myAssumeValidRestReferences;
    private boolean myNoExtensibleWarnings;
    private boolean myNoBindingMsgSuppressed;
    private Collection<? extends String> myExtensionDomains;
    private IValidatorResourceFetcher myValidatorResourceFetcher;
    private IValidationPolicyAdvisor myValidationPolicyAdvisor;
    private boolean myAllowExamples;

    public boolean isAssumeValidRestReferences() {
        return this.myAssumeValidRestReferences;
    }

    public ValidatorWrapper setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.myAssumeValidRestReferences = assumeValidRestReferences;
        return this;
    }

    public ValidatorWrapper setAllowExamples(boolean theAllowExamples) {
        this.myAllowExamples = theAllowExamples;
        return this;
    }

    public ValidatorWrapper setBestPracticeWarningLevel(BestPracticeWarningLevel theBestPracticeWarningLevel) {
        this.myBestPracticeWarningLevel = theBestPracticeWarningLevel;
        return this;
    }

    public ValidatorWrapper setAnyExtensionsAllowed(boolean theAnyExtensionsAllowed) {
        this.myAnyExtensionsAllowed = theAnyExtensionsAllowed;
        return this;
    }

    public ValidatorWrapper setErrorForUnknownProfiles(boolean theErrorForUnknownProfiles) {
        this.myErrorForUnknownProfiles = theErrorForUnknownProfiles;
        return this;
    }

    public ValidatorWrapper setNoTerminologyChecks(boolean theNoTerminologyChecks) {
        this.myNoTerminologyChecks = theNoTerminologyChecks;
        return this;
    }

    public ValidatorWrapper setNoExtensibleWarnings(boolean theNoExtensibleWarnings) {
        this.myNoExtensibleWarnings = theNoExtensibleWarnings;
        return this;
    }

    public ValidatorWrapper setNoBindingMsgSuppressed(boolean theNoBindingMsgSuppressed) {
        this.myNoBindingMsgSuppressed = theNoBindingMsgSuppressed;
        return this;
    }

    public ValidatorWrapper setExtensionDomains(Collection<? extends String> theExtensionDomains) {
        this.myExtensionDomains = theExtensionDomains;
        return this;
    }

    public ValidatorWrapper setValidationPolicyAdvisor(IValidationPolicyAdvisor validationPolicyAdvisor) {
        this.myValidationPolicyAdvisor = validationPolicyAdvisor;
        return this;
    }

    public ValidatorWrapper setValidatorResourceFetcher(IValidatorResourceFetcher validatorResourceFetcher) {
        this.myValidatorResourceFetcher = validatorResourceFetcher;
        return this;
    }

    public List<ValidationMessage> validate(IWorkerContext theWorkerContext, IValidationContext<?> theValidationContext) {
        InstanceValidator v;
        FhirInstanceValidator.NullEvaluationContext evaluationCtx = new FhirInstanceValidator.NullEvaluationContext();
        XVerExtensionManager xverManager = new XVerExtensionManager(theWorkerContext);
        try {
            v = new InstanceValidator(theWorkerContext, (FHIRPathEngine.IEvaluationContext)evaluationCtx, xverManager, new ValidatorSession(), new ValidatorSettings());
        }
        catch (Exception e) {
            throw new ConfigurationException(Msg.code((int)648) + e.getMessage(), (Throwable)e);
        }
        v.setAssumeValidRestReferences(this.isAssumeValidRestReferences());
        v.setBestPracticeWarningLevel(this.myBestPracticeWarningLevel);
        v.setAnyExtensionsAllowed(this.myAnyExtensionsAllowed);
        v.setResourceIdRule(IdStatus.OPTIONAL);
        v.setNoTerminologyChecks(this.myNoTerminologyChecks);
        v.setErrorForUnknownProfiles(this.myErrorForUnknownProfiles);
        v.setUnknownCodeSystemsCauseErrors(true);
        v.getExtensionDomains().addAll(this.myExtensionDomains);
        v.setFetcher(this.myValidatorResourceFetcher);
        v.setPolicyAdvisor(this.myValidationPolicyAdvisor);
        v.setNoExtensibleWarnings(this.myNoExtensibleWarnings);
        v.setNoBindingMsgSuppressed(this.myNoBindingMsgSuppressed);
        v.setAllowExamples(this.myAllowExamples);
        v.setAllowXsiLocation(true);
        List<Object> messages = new ArrayList<ValidationMessage>();
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        ArrayList<ValidationMessage> invalidProfileValidationMessages = new ArrayList<ValidationMessage>();
        for (String nextProfileUrl : theValidationContext.getOptions().getProfiles()) {
            this.fetchAndAddProfile(theWorkerContext, profiles, nextProfileUrl, invalidProfileValidationMessages);
        }
        String input = theValidationContext.getResourceAsString();
        EncodingEnum encoding = theValidationContext.getResourceAsStringEncoding();
        ReaderInputStream inputStream = this.constructNewReaderInputStream(new StringReader(input));
        if (encoding == EncodingEnum.XML) {
            Document document;
            try {
                document = XmlUtil.parseDocument((String)input);
            }
            catch (Exception e2) {
                ourLog.error("Failure to parse XML input", (Throwable)e2);
                ValidationMessage m2 = new ValidationMessage();
                m2.setLevel(ValidationMessage.IssueSeverity.FATAL);
                m2.setMessage("Failed to parse input, it does not appear to be valid XML:" + e2.getMessage());
                messages.add(m2);
                return messages;
            }
            ArrayList<String> profileUrls = this.determineIfProfilesSpecified(document);
            for (String nextProfileUrl : profileUrls) {
                this.fetchAndAddProfile(theWorkerContext, profiles, nextProfileUrl, invalidProfileValidationMessages);
            }
            Manager.FhirFormat format = Manager.FhirFormat.XML;
            v.validate(null, messages, (InputStream)inputStream, format, profiles);
        } else if (encoding == EncodingEnum.JSON) {
            JsonElement profileElement;
            Gson gson = new GsonBuilder().create();
            JsonObject json = (JsonObject)gson.fromJson(input, JsonObject.class);
            JsonObject meta = json.getAsJsonObject("meta");
            if (meta != null && (profileElement = meta.get("profile")) != null && profileElement.isJsonArray()) {
                JsonArray profilesArray = profileElement.getAsJsonArray();
                for (JsonElement element : profilesArray) {
                    String nextProfileUrl = element.getAsString();
                    this.fetchAndAddProfile(theWorkerContext, profiles, nextProfileUrl, invalidProfileValidationMessages);
                }
            }
            Manager.FhirFormat format = Manager.FhirFormat.JSON;
            v.validate(null, messages, (InputStream)inputStream, format, profiles);
        } else {
            throw new IllegalArgumentException(Msg.code((int)649) + "Unknown encoding: " + String.valueOf(encoding));
        }
        if (profiles.isEmpty() && !invalidProfileValidationMessages.isEmpty()) {
            messages.addAll(invalidProfileValidationMessages);
        }
        messages = messages.stream().filter(m -> m.getMessageId() == null || !m.getMessageId().equals("Terminology_TX_Binding_NoSource") && !m.getMessageId().equals("Terminology_TX_Binding_NoSource2") && (!m.getMessageId().equals("Terminology_TX_ValueSet_NotFound") || !m.getMessage().contains("http://hl7.org/fhir/ValueSet/mimetypes"))).collect(Collectors.toList());
        if (this.myErrorForUnknownProfiles) {
            messages.stream().filter(m -> m.getMessageId() != null && (m.getMessageId().equals("Validation_VAL_Profile_Unknown") || m.getMessageId().equals("VALIDATION_VAL_PROFILE_UNKNOWN_NOT_POLICY"))).filter(m -> m.getLevel() == ValidationMessage.IssueSeverity.WARNING).forEach(m -> m.setLevel(ValidationMessage.IssueSeverity.ERROR));
        }
        return messages;
    }

    private ReaderInputStream constructNewReaderInputStream(Reader theReader) {
        try {
            return ((ReaderInputStream.Builder)ReaderInputStream.builder().setCharset(StandardCharsets.UTF_8).setReader(theReader)).get();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(Msg.code((int)2596) + "Error constructing input reader stream while validating resource.", ex);
        }
    }

    private void fetchAndAddProfile(IWorkerContext theWorkerContext, List<StructureDefinition> theProfileStructureDefinitions, String theUrl, List<ValidationMessage> theValidationMessages) {
        try {
            StructureDefinition structureDefinition = (StructureDefinition)theWorkerContext.fetchResource(StructureDefinition.class, theUrl);
            if (structureDefinition != null) {
                theProfileStructureDefinitions.add(structureDefinition);
            } else {
                ValidationMessage m = new ValidationMessage();
                m.setMessageId("Validation_VAL_Profile_Unknown");
                m.setLevel(ValidationMessage.IssueSeverity.ERROR);
                m.setMessage("Invalid profile. Failed to retrieve profile with url=" + theUrl);
                theValidationMessages.add(m);
            }
        }
        catch (FHIRException e) {
            ourLog.debug("Failed to load profile: {}", (Object)theUrl);
        }
    }

    private ArrayList<String> determineIfProfilesSpecified(Document theDocument) {
        ArrayList<String> profileNames = new ArrayList<String>();
        NodeList list = theDocument.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName().compareToIgnoreCase("meta") != 0) continue;
            NodeList metaList = list.item(i).getChildNodes();
            for (int j = 0; j < metaList.getLength(); ++j) {
                if (metaList.item(j).getNodeName().compareToIgnoreCase("profile") != 0) continue;
                profileNames.add(metaList.item(j).getAttributes().item(0).getNodeValue());
            }
            break;
        }
        return profileNames;
    }
}

