/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationSupportChainMetrics {
    public static final String CLASS_OPENTELEMETRY_BASE_NAME = "io.hapifhir.validation_support_chain";
    static final String INSTRUMENTATION_NAME = "io.hapifhir.validation_support_chain";
    private static final AttributeKey<String> INSTANCE_NAME = AttributeKey.stringKey((String)"io.hapifhir.validation_support_chain.instance_name");
    public static final String EXPIRING_CACHE_MAXIMUM_SIZE = "io.hapifhir.validation_support_chain.expiring_cache.maximum_size";
    public static final String EXPIRING_CACHE_CURRENT_ENTRIES = "io.hapifhir.validation_support_chain.expiring_cache.current_entries";
    public static final String NON_EXPIRING_CACHE_CURRENT_ENTRIES = "io.hapifhir.validation_support_chain.non_expiring_cache.current_entries";
    private static final Logger ourLog = LoggerFactory.getLogger(ValidationSupportChainMetrics.class);
    private final ValidationSupportChain myValidationSupportChain;
    private BatchCallback myBatchCallback;

    public ValidationSupportChainMetrics(ValidationSupportChain theValidationSupportChain) {
        this.myValidationSupportChain = theValidationSupportChain;
    }

    public void start() {
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        MeterBuilder meterBuilder = openTelemetry.getMeterProvider().meterBuilder("io.hapifhir.validation_support_chain");
        Meter meter = meterBuilder.build();
        Attributes baseAttribute = Attributes.of(INSTANCE_NAME, (Object)this.myValidationSupportChain.getName());
        ObservableLongMeasurement expiringCacheMaxSize = meter.gaugeBuilder(EXPIRING_CACHE_MAXIMUM_SIZE).ofLongs().setUnit("{entries}").setDescription("The maximum number of cache entries in the expiring cache.").buildObserver();
        ObservableLongMeasurement expiringCacheCurrentEntries = meter.gaugeBuilder(EXPIRING_CACHE_CURRENT_ENTRIES).ofLongs().setUnit("{entries}").setDescription("The current number of cache entries in the expiring cache.").buildObserver();
        ObservableLongMeasurement nonExpiringCacheCurrentEntries = meter.gaugeBuilder(NON_EXPIRING_CACHE_CURRENT_ENTRIES).ofLongs().setUnit("{entries}").setDescription("The current number of cache entries in the non-expiring cache.").buildObserver();
        this.myBatchCallback = meter.batchCallback(() -> {
            long expiringCacheEntries = this.myValidationSupportChain.getMetricExpiringCacheEntries();
            int expiringCacheMaxSizeValue = this.myValidationSupportChain.getMetricExpiringCacheMaxSize();
            int nonExpiringCacheEntries = this.myValidationSupportChain.getMetricNonExpiringCacheEntries();
            ourLog.trace("ExpiringMax[{}] ExpiringEntries[{}] NonExpiringEntries[{}]", new Object[]{expiringCacheMaxSizeValue, expiringCacheEntries, nonExpiringCacheEntries});
            expiringCacheMaxSize.record((long)expiringCacheMaxSizeValue, baseAttribute);
            expiringCacheCurrentEntries.record(expiringCacheEntries, baseAttribute);
            nonExpiringCacheCurrentEntries.record((long)nonExpiringCacheEntries, baseAttribute);
        }, (ObservableMeasurement)expiringCacheMaxSize, new ObservableMeasurement[]{expiringCacheCurrentEntries, nonExpiringCacheCurrentEntries});
    }

    public void stop() {
        if (this.myBatchCallback != null) {
            this.myBatchCallback.close();
        }
    }
}

