/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.util.Logs;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.validator.ProfileKnowledgeWorkerR5;
import org.hl7.fhir.common.hapi.validation.validator.VersionSpecificWorkerContextWrapper;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.slf4j.Logger;

public class SnapshotGeneratingValidationSupport
implements IValidationSupport {
    private static final Logger ourLog = Logs.getTerminologyTroubleshootingLog();
    private final FhirContext myCtx;
    private final IWorkerContext myWorkerContext;
    private final FHIRPathEngine myFHIRPathEngine;
    private VersionCanonicalizer myVersionCanonicalizer;

    public SnapshotGeneratingValidationSupport(FhirContext theFhirContext) {
        this(theFhirContext, null, null);
    }

    public SnapshotGeneratingValidationSupport(FhirContext theFhirContext, IWorkerContext theWorkerContext, FHIRPathEngine theFHIRPathEngine) {
        Objects.requireNonNull(theFhirContext);
        this.myCtx = theFhirContext;
        this.myVersionCanonicalizer = new VersionCanonicalizer(theFhirContext);
        this.myWorkerContext = theWorkerContext;
        this.myFHIRPathEngine = theFHIRPathEngine;
    }

    @VisibleForTesting
    public void setVersionCanonicalizer(VersionCanonicalizer theVersionCanonicalizer) {
        this.myVersionCanonicalizer = theVersionCanonicalizer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBaseResource generateSnapshot(ValidationSupportContext theValidationSupportContext, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        IBaseResource iBaseResource;
        org.hl7.fhir.r5.model.StructureDefinition inputCanonical;
        FhirVersionEnum version;
        String inputUrl = null;
        try {
            version = theInput.getStructureFhirVersionEnum();
            inputCanonical = this.myVersionCanonicalizer.structureDefinitionToCanonical(theInput);
            inputUrl = inputCanonical.getUrl();
            if (theValidationSupportContext.getCurrentlyGeneratingSnapshots().contains(inputUrl)) {
                ourLog.warn("Detected circular dependency, already generating snapshot for: {}", (Object)inputUrl);
                IBaseResource iBaseResource2 = theInput;
                if (inputUrl == null) return iBaseResource2;
                theValidationSupportContext.getCurrentlyGeneratingSnapshots().remove(inputUrl);
                return iBaseResource2;
            }
        }
        catch (BaseServerResponseException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new InternalErrorException(Msg.code((int)707) + "Failed to generate snapshot", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (inputUrl == null) throw throwable;
                theValidationSupportContext.getCurrentlyGeneratingSnapshots().remove(inputUrl);
                throw throwable;
            }
        }
        {
            ProfileUtilities profileUtilities;
            theValidationSupportContext.getCurrentlyGeneratingSnapshots().add(inputUrl);
            String baseDefinition = inputCanonical.getBaseDefinition();
            if (StringUtils.isBlank((CharSequence)baseDefinition)) {
                throw new PreconditionFailedException(Msg.code((int)704) + "StructureDefinition[id=" + inputCanonical.getIdElement().getId() + ", url=" + inputCanonical.getUrl() + "] has no base");
            }
            IBaseResource base = theValidationSupportContext.getRootValidationSupport().fetchStructureDefinition(baseDefinition);
            if (base == null) {
                throw new PreconditionFailedException(Msg.code((int)705) + "Unknown base definition: " + baseDefinition);
            }
            org.hl7.fhir.r5.model.StructureDefinition baseCanonical = this.myVersionCanonicalizer.structureDefinitionToCanonical(base);
            if (baseCanonical.getSnapshot().getElement().isEmpty()) {
                theValidationSupportContext.getRootValidationSupport().generateSnapshot(theValidationSupportContext, base, null, null, null);
                baseCanonical = this.myVersionCanonicalizer.structureDefinitionToCanonical(base);
            }
            ArrayList messages = new ArrayList();
            ProfileKnowledgeWorkerR5 profileKnowledgeProvider = new ProfileKnowledgeWorkerR5(this.myCtx);
            if (this.myWorkerContext == null) {
                VersionSpecificWorkerContextWrapper context = new VersionSpecificWorkerContextWrapper(theValidationSupportContext, this.myVersionCanonicalizer);
                profileUtilities = new ProfileUtilities((IWorkerContext)context, messages, (ProfileKnowledgeProvider)profileKnowledgeProvider);
            } else {
                profileUtilities = new ProfileUtilities(this.myWorkerContext, messages, (ProfileKnowledgeProvider)profileKnowledgeProvider, this.myFHIRPathEngine);
            }
            profileUtilities.generateSnapshot(baseCanonical, inputCanonical, theUrl, theWebUrl, theProfileName);
            switch (CommonCodeSystemsTerminologyService.getFhirVersionEnum(theValidationSupportContext.getRootValidationSupport().getFhirContext(), theInput)) {
                case DSTU3: {
                    org.hl7.fhir.dstu3.model.StructureDefinition generatedDstu3 = (org.hl7.fhir.dstu3.model.StructureDefinition)this.myVersionCanonicalizer.structureDefinitionFromCanonical(inputCanonical);
                    ((org.hl7.fhir.dstu3.model.StructureDefinition)theInput).getSnapshot().setElement(new ArrayList(generatedDstu3.getSnapshot().getElement()));
                    break;
                }
                case R4: {
                    StructureDefinition generatedR4 = (StructureDefinition)this.myVersionCanonicalizer.structureDefinitionFromCanonical(inputCanonical);
                    ((StructureDefinition)theInput).getSnapshot().setElement(new ArrayList(generatedR4.getSnapshot().getElement()));
                    break;
                }
                case R4B: {
                    org.hl7.fhir.r4b.model.StructureDefinition generatedR4b = (org.hl7.fhir.r4b.model.StructureDefinition)this.myVersionCanonicalizer.structureDefinitionFromCanonical(inputCanonical);
                    ((org.hl7.fhir.r4b.model.StructureDefinition)theInput).getSnapshot().setElement(new ArrayList(generatedR4b.getSnapshot().getElement()));
                    break;
                }
                case R5: {
                    break;
                }
                default: {
                    throw new IllegalStateException(Msg.code((int)706) + "Can not generate snapshot for version: " + String.valueOf(version));
                }
            }
            iBaseResource = theInput;
            if (inputUrl == null) return iBaseResource;
            theValidationSupportContext.getCurrentlyGeneratingSnapshots().remove(inputUrl);
        }
        return iBaseResource;
    }

    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    public String getName() {
        return String.valueOf(this.getFhirContext().getVersion().getVersion()) + " Snapshot Generating Validation Support";
    }
}

