/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.StopWatch;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.NpmPackageValidationSupport;
import org.slf4j.Logger;

public class DefaultProfileValidationSupportNpmStrategy
extends NpmPackageValidationSupport {
    private static final Logger ourLog = Logs.getTerminologyTroubleshootingLog();

    public DefaultProfileValidationSupportNpmStrategy(@Nonnull FhirContext theFhirContext) {
        super(theFhirContext);
        Validate.isTrue((theFhirContext.getVersion().getVersion() == FhirVersionEnum.R5 ? 1 : 0) != 0);
        ourLog.info("Loading R5 Core+Extension packages into memory");
        StopWatch sw = new StopWatch();
        try {
            this.loadPackageFromClasspath("org/hl7/fhir/r5/packages/hl7.fhir.r5.core-5.0.0.tgz");
            this.loadPackageFromClasspath("org/hl7/fhir/r5/packages/hl7.fhir.uv.extensions.r5-1.0.0.tgz");
            this.loadPackageFromClasspath("org/hl7/fhir/r5/packages/hl7.terminology-5.1.0.tgz");
        }
        catch (IOException e) {
            throw new ConfigurationException(Msg.code((int)2333) + "Failed to load required validation resources. Make sure that the appropriate hapi-fhir-validation-resources-VER JAR is on the classpath", (Throwable)e);
        }
        ourLog.info("Loaded {} Core+Extension resources in {}", (Object)this.countAll(), (Object)sw);
    }

    @Override
    public String getName() {
        return String.valueOf(this.getFhirContext().getVersion().getVersion()) + " FHIR Standard Profile NPM Validation Support";
    }
}

