/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.LookupCodeRequest;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.RemoteTerminologyUtil;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportUtils;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.slf4j.Logger;

public class RemoteTerminologyServiceValidationSupport
extends BaseValidationSupport
implements IValidationSupport {
    private static final Logger ourLog = Logs.getTerminologyTroubleshootingLog();
    public static final String ERROR_CODE_UNKNOWN_CODE_IN_CODE_SYSTEM = "unknownCodeInSystem";
    public static final String ERROR_CODE_UNKNOWN_CODE_IN_VALUE_SET = "unknownCodeInValueSet";
    private String myBaseUrl;
    private final List<Object> myClientInterceptors = new ArrayList<Object>();

    public RemoteTerminologyServiceValidationSupport(FhirContext theFhirContext) {
        super(theFhirContext);
    }

    public RemoteTerminologyServiceValidationSupport(FhirContext theFhirContext, String theBaseUrl) {
        super(theFhirContext);
        this.myBaseUrl = theBaseUrl;
    }

    public String getName() {
        return String.valueOf(this.getFhirContext().getVersion().getVersion()) + " Remote Terminology Service Validation Support";
    }

    public IValidationSupport.CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return this.invokeRemoteValidateCode(theCodeSystem, theCode, theDisplay, theValueSetUrl, null);
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        String valueSetUrl;
        IBaseResource valueSet = theValueSet;
        String codeSystem = theCodeSystem;
        if (StringUtils.isNotBlank((CharSequence)theCode) && StringUtils.isBlank((CharSequence)codeSystem)) {
            codeSystem = ValidationSupportUtils.extractCodeSystemForCode(theValueSet, theCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(valueSetUrl = DefaultProfileValidationSupport.getConformanceResourceUrl((FhirContext)this.myCtx, (IBaseResource)valueSet)))) {
            valueSet = null;
        } else {
            valueSetUrl = null;
        }
        return this.invokeRemoteValidateCode(codeSystem, theCode, theDisplay, valueSetUrl, valueSet);
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.fetchCodeSystem(theSystem, SummaryEnum.FALSE);
    }

    @Nullable
    private IBaseResource fetchCodeSystem(String theSystem, @Nullable SummaryEnum theSummaryParam) {
        IBaseBundle results;
        List resultsList;
        IGenericClient client = this.provideClient();
        Class bundleType = this.myCtx.getResourceDefinition("Bundle").getImplementingClass(IBaseBundle.class);
        IQuery codeSystemQuery = client.search().forResource("CodeSystem").where(CodeSystem.URL.matches().value(theSystem));
        if (theSummaryParam != null) {
            codeSystemQuery.summaryMode(theSummaryParam);
        }
        if (!(resultsList = BundleUtil.toListOfResources((FhirContext)this.myCtx, (IBaseBundle)(results = (IBaseBundle)codeSystemQuery.returnBundle(bundleType).execute()))).isEmpty()) {
            return (IBaseResource)resultsList.get(0);
        }
        return null;
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, @Nonnull LookupCodeRequest theLookupCodeRequest) {
        IBaseParameters outcome;
        String code = theLookupCodeRequest.getCode();
        String system = theLookupCodeRequest.getSystem();
        String displayLanguage = theLookupCodeRequest.getDisplayLanguage();
        Validate.notBlank((CharSequence)code, (String)"theCode must be provided", (Object[])new Object[0]);
        IGenericClient client = this.provideClient();
        FhirContext fhirContext = client.getFhirContext();
        FhirVersionEnum fhirVersion = fhirContext.getVersion().getVersion();
        if (fhirVersion.isNewerThan(FhirVersionEnum.R4) || fhirVersion.isOlderThan(FhirVersionEnum.DSTU3)) {
            throw new UnsupportedOperationException(Msg.code((int)710) + "Unsupported FHIR version '" + fhirVersion.getFhirVersionString() + "'. Only DSTU3 and R4 are supported.");
        }
        IBaseParameters params = ParametersUtil.newInstance((FhirContext)fhirContext);
        ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"code", (String)code);
        if (!StringUtils.isEmpty((CharSequence)system)) {
            ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"system", (String)system);
        }
        if (!StringUtils.isEmpty((CharSequence)displayLanguage)) {
            ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"language", (String)displayLanguage);
        }
        for (String propertyName : theLookupCodeRequest.getPropertyNames()) {
            ParametersUtil.addParameterToParametersCode((FhirContext)fhirContext, (IBaseParameters)params, (String)"property", (String)propertyName);
        }
        Class codeSystemClass = this.myCtx.getResourceDefinition("CodeSystem").getImplementingClass();
        try {
            outcome = (IBaseParameters)((IOperationUnnamed)client.operation().onType(codeSystemClass)).named("$lookup").withParameters(params).useHttpGet().execute();
        }
        catch (InvalidRequestException | ResourceNotFoundException e) {
            ourLog.error(e.getMessage(), e);
            IValidationSupport.LookupCodeResult result = IValidationSupport.LookupCodeResult.notFound((String)system, (String)code);
            result.setErrorMessage(this.getErrorMessage(ERROR_CODE_UNKNOWN_CODE_IN_CODE_SYSTEM, system, code, this.getBaseUrl(), e.getMessage()));
            return result;
        }
        if (outcome != null && !outcome.isEmpty()) {
            if (fhirVersion == FhirVersionEnum.DSTU3) {
                return this.generateLookupCodeResultDstu3(code, system, (Parameters)outcome);
            }
            if (fhirVersion == FhirVersionEnum.R4) {
                return this.generateLookupCodeResultR4(code, system, (org.hl7.fhir.r4.model.Parameters)outcome);
            }
        }
        return IValidationSupport.LookupCodeResult.notFound((String)system, (String)code);
    }

    protected String getErrorMessage(String errorCode, Object ... theParams) {
        return this.getFhirContext().getLocalizer().getMessage(this.getClass(), errorCode, theParams);
    }

    private IValidationSupport.LookupCodeResult generateLookupCodeResultDstu3(String theCode, String theSystem, Parameters outcomeDSTU3) {
        IValidationSupport.LookupCodeResult result = new IValidationSupport.LookupCodeResult();
        result.setSearchedForCode(theCode);
        result.setSearchedForSystem(theSystem);
        result.setFound(true);
        for (Parameters.ParametersParameterComponent parameterComponent : outcomeDSTU3.getParameter()) {
            String parameterTypeAsString = Objects.toString(parameterComponent.getValue(), null);
            switch (parameterComponent.getName()) {
                case "property": {
                    IValidationSupport.BaseConceptProperty conceptProperty = RemoteTerminologyServiceValidationSupport.createConceptPropertyDstu3(parameterComponent);
                    if (conceptProperty == null) break;
                    result.getProperties().add(conceptProperty);
                    break;
                }
                case "designation": {
                    IValidationSupport.ConceptDesignation conceptDesignation = this.createConceptDesignationDstu3(parameterComponent);
                    result.getDesignations().add(conceptDesignation);
                    break;
                }
                case "name": {
                    result.setCodeSystemDisplayName(parameterTypeAsString);
                    break;
                }
                case "version": {
                    result.setCodeSystemVersion(parameterTypeAsString);
                    break;
                }
                case "display": {
                    result.setCodeDisplay(parameterTypeAsString);
                    break;
                }
                case "abstract": {
                    result.setCodeIsAbstract(Boolean.parseBoolean(parameterTypeAsString));
                    break;
                }
            }
        }
        return result;
    }

    private static IValidationSupport.BaseConceptProperty createConceptPropertyDstu3(Parameters.ParametersParameterComponent theParameterComponent) {
        Property property = theParameterComponent.getChildByName("part");
        if (property == null || property.getValues().size() < 2) {
            return null;
        }
        List values = property.getValues();
        Parameters.ParametersParameterComponent firstPart = (Parameters.ParametersParameterComponent)values.get(0);
        String propertyName = (String)((org.hl7.fhir.dstu3.model.CodeType)firstPart.getValue()).getValue();
        Parameters.ParametersParameterComponent secondPart = (Parameters.ParametersParameterComponent)values.get(1);
        Type value = secondPart.getValue();
        if (value != null) {
            return RemoteTerminologyServiceValidationSupport.createConceptPropertyDstu3(propertyName, value);
        }
        String groupName = secondPart.getName();
        if (!"subproperty".equals(groupName)) {
            return null;
        }
        IValidationSupport.GroupConceptProperty groupConceptProperty = new IValidationSupport.GroupConceptProperty(propertyName);
        for (int i = 1; i < values.size(); ++i) {
            Parameters.ParametersParameterComponent nextPart = (Parameters.ParametersParameterComponent)values.get(i);
            IValidationSupport.BaseConceptProperty subProperty = RemoteTerminologyServiceValidationSupport.createConceptPropertyDstu3(nextPart);
            if (subProperty == null) continue;
            groupConceptProperty.addSubProperty(subProperty);
        }
        return groupConceptProperty;
    }

    public static IValidationSupport.BaseConceptProperty createConceptProperty(String theName, IBaseDatatype theValue) {
        if (theValue instanceof org.hl7.fhir.r4.model.Type) {
            return RemoteTerminologyServiceValidationSupport.createConceptPropertyR4(theName, (org.hl7.fhir.r4.model.Type)theValue);
        }
        if (theValue instanceof Type) {
            return RemoteTerminologyServiceValidationSupport.createConceptPropertyDstu3(theName, (Type)theValue);
        }
        return null;
    }

    private static IValidationSupport.BaseConceptProperty createConceptPropertyDstu3(String theName, Type theValue) {
        IValidationSupport.StringConceptProperty conceptProperty;
        String fhirType;
        if (theValue == null) {
            return null;
        }
        switch (fhirType = theValue.fhirType()) {
            case "string": {
                org.hl7.fhir.dstu3.model.StringType stringType = (org.hl7.fhir.dstu3.model.StringType)theValue;
                conceptProperty = new IValidationSupport.StringConceptProperty(theName, (String)stringType.getValue());
                break;
            }
            case "Coding": {
                org.hl7.fhir.dstu3.model.Coding coding = (org.hl7.fhir.dstu3.model.Coding)theValue;
                conceptProperty = new IValidationSupport.CodingConceptProperty(theName, coding.getSystem(), coding.getCode(), coding.getDisplay());
                break;
            }
            default: {
                conceptProperty = new IValidationSupport.StringConceptProperty(theName, theValue.toString());
            }
        }
        return conceptProperty;
    }

    private IValidationSupport.ConceptDesignation createConceptDesignationDstu3(Parameters.ParametersParameterComponent theParameterComponent) {
        IValidationSupport.ConceptDesignation conceptDesignation = new IValidationSupport.ConceptDesignation();
        for (Parameters.ParametersParameterComponent designationComponent : theParameterComponent.getPart()) {
            Type designationComponentValue = designationComponent.getValue();
            if (designationComponentValue == null) continue;
            switch (designationComponent.getName()) {
                case "language": {
                    conceptDesignation.setLanguage(designationComponentValue.toString());
                    break;
                }
                case "use": {
                    org.hl7.fhir.dstu3.model.Coding coding = (org.hl7.fhir.dstu3.model.Coding)designationComponentValue;
                    conceptDesignation.setUseSystem(coding.getSystem());
                    conceptDesignation.setUseCode(coding.getCode());
                    conceptDesignation.setUseDisplay(coding.getDisplay());
                    break;
                }
                case "value": {
                    conceptDesignation.setValue(designationComponent.getValue().toString());
                    break;
                }
            }
        }
        return conceptDesignation;
    }

    private IValidationSupport.LookupCodeResult generateLookupCodeResultR4(String theCode, String theSystem, org.hl7.fhir.r4.model.Parameters outcomeR4) {
        IValidationSupport.LookupCodeResult result = new IValidationSupport.LookupCodeResult();
        result.setSearchedForCode(theCode);
        result.setSearchedForSystem(theSystem);
        result.setFound(true);
        for (Parameters.ParametersParameterComponent parameterComponent : outcomeR4.getParameter()) {
            String parameterTypeAsString = Objects.toString(parameterComponent.getValue(), null);
            switch (parameterComponent.getName()) {
                case "property": {
                    IValidationSupport.BaseConceptProperty conceptProperty = RemoteTerminologyServiceValidationSupport.createConceptPropertyR4(parameterComponent);
                    if (conceptProperty == null) break;
                    result.getProperties().add(conceptProperty);
                    break;
                }
                case "designation": {
                    IValidationSupport.ConceptDesignation conceptDesignation = this.createConceptDesignationR4(parameterComponent);
                    result.getDesignations().add(conceptDesignation);
                    break;
                }
                case "name": {
                    result.setCodeSystemDisplayName(parameterTypeAsString);
                    break;
                }
                case "version": {
                    result.setCodeSystemVersion(parameterTypeAsString);
                    break;
                }
                case "display": {
                    result.setCodeDisplay(parameterTypeAsString);
                    break;
                }
                case "abstract": {
                    result.setCodeIsAbstract(Boolean.parseBoolean(parameterTypeAsString));
                    break;
                }
            }
        }
        return result;
    }

    private static IValidationSupport.BaseConceptProperty createConceptPropertyR4(Parameters.ParametersParameterComponent thePropertyComponent) {
        org.hl7.fhir.r4.model.Property property = thePropertyComponent.getChildByName("part");
        if (property == null || property.getValues().size() < 2) {
            return null;
        }
        List values = property.getValues();
        Parameters.ParametersParameterComponent firstPart = (Parameters.ParametersParameterComponent)values.get(0);
        String propertyName = (String)((CodeType)firstPart.getValue()).getValue();
        Parameters.ParametersParameterComponent secondPart = (Parameters.ParametersParameterComponent)values.get(1);
        org.hl7.fhir.r4.model.Type value = secondPart.getValue();
        if (value != null) {
            return RemoteTerminologyServiceValidationSupport.createConceptPropertyR4(propertyName, value);
        }
        String groupName = secondPart.getName();
        if (!"subproperty".equals(groupName)) {
            return null;
        }
        IValidationSupport.GroupConceptProperty groupConceptProperty = new IValidationSupport.GroupConceptProperty(propertyName);
        for (int i = 1; i < values.size(); ++i) {
            Parameters.ParametersParameterComponent nextPart = (Parameters.ParametersParameterComponent)values.get(i);
            IValidationSupport.BaseConceptProperty subProperty = RemoteTerminologyServiceValidationSupport.createConceptPropertyR4(nextPart);
            if (subProperty == null) continue;
            groupConceptProperty.addSubProperty(subProperty);
        }
        return groupConceptProperty;
    }

    private static IValidationSupport.BaseConceptProperty createConceptPropertyR4(String theName, org.hl7.fhir.r4.model.Type theValue) {
        IValidationSupport.StringConceptProperty conceptProperty;
        String fhirType;
        switch (fhirType = theValue.fhirType()) {
            case "string": {
                StringType stringType = (StringType)theValue;
                conceptProperty = new IValidationSupport.StringConceptProperty(theName, (String)stringType.getValue());
                break;
            }
            case "boolean": {
                BooleanType booleanType = (BooleanType)theValue;
                conceptProperty = new IValidationSupport.BooleanConceptProperty(theName, ((Boolean)booleanType.getValue()).booleanValue());
                break;
            }
            case "Coding": {
                Coding coding = (Coding)theValue;
                conceptProperty = new IValidationSupport.CodingConceptProperty(theName, coding.getSystem(), coding.getCode(), coding.getDisplay());
                break;
            }
            default: {
                conceptProperty = new IValidationSupport.StringConceptProperty(theName, theValue.toString());
            }
        }
        return conceptProperty;
    }

    private IValidationSupport.ConceptDesignation createConceptDesignationR4(Parameters.ParametersParameterComponent theParameterComponent) {
        IValidationSupport.ConceptDesignation conceptDesignation = new IValidationSupport.ConceptDesignation();
        for (Parameters.ParametersParameterComponent designationComponent : theParameterComponent.getPart()) {
            org.hl7.fhir.r4.model.Type designationComponentValue = designationComponent.getValue();
            if (designationComponentValue == null) continue;
            switch (designationComponent.getName()) {
                case "language": {
                    conceptDesignation.setLanguage(designationComponentValue.toString());
                    break;
                }
                case "use": {
                    Coding coding = (Coding)designationComponentValue;
                    conceptDesignation.setUseSystem(coding.getSystem());
                    conceptDesignation.setUseCode(coding.getCode());
                    conceptDesignation.setUseDisplay(coding.getDisplay());
                    break;
                }
                case "value": {
                    conceptDesignation.setValue(designationComponentValue.toString());
                    break;
                }
            }
        }
        return conceptDesignation;
    }

    public IBaseResource fetchValueSet(String theValueSetUrl) {
        SummaryEnum summaryParam = SummaryEnum.FALSE;
        return this.fetchValueSet(theValueSetUrl, summaryParam);
    }

    @Nullable
    private IBaseResource fetchValueSet(String theValueSetUrl, SummaryEnum theSummaryParam) {
        IBaseBundle results;
        List resultsList;
        IGenericClient client = this.provideClient();
        Class bundleType = this.myCtx.getResourceDefinition("Bundle").getImplementingClass(IBaseBundle.class);
        IQuery valueSetQuery = client.search().forResource("ValueSet").where(CodeSystem.URL.matches().value(theValueSetUrl));
        if (theSummaryParam != null) {
            valueSetQuery.summaryMode(theSummaryParam);
        }
        if (!(resultsList = BundleUtil.toListOfResources((FhirContext)this.myCtx, (IBaseBundle)(results = (IBaseBundle)valueSetQuery.returnBundle(bundleType).execute()))).isEmpty()) {
            return (IBaseResource)resultsList.get(0);
        }
        return null;
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        SummaryEnum summaryParam = null;
        return this.fetchCodeSystem(theSystem, summaryParam) != null;
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        SummaryEnum summaryParam = null;
        return this.fetchValueSet(theValueSetUrl, summaryParam) != null;
    }

    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        IGenericClient client = this.provideClient();
        FhirContext fhirContext = client.getFhirContext();
        IBaseParameters params = RemoteTerminologyUtil.buildTranslateInputParameters(fhirContext, theRequest);
        IBaseParameters outcome = (IBaseParameters)((IOperationUnnamed)client.operation().onType("ConceptMap")).named("$translate").withParameters(params).execute();
        return RemoteTerminologyUtil.translateOutcomeToResults(fhirContext, outcome);
    }

    private IGenericClient provideClient() {
        IGenericClient retVal = this.myCtx.newRestfulGenericClient(this.myBaseUrl);
        for (Object next : this.myClientInterceptors) {
            retVal.registerInterceptor(next);
        }
        return retVal;
    }

    public String getBaseUrl() {
        return this.myBaseUrl;
    }

    protected IValidationSupport.CodeValidationResult invokeRemoteValidateCode(String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl, IBaseResource theValueSet) {
        if (StringUtils.isBlank((CharSequence)theCode)) {
            return null;
        }
        IGenericClient client = this.provideClient();
        ValidationErrorMessageBuilder errorMessageBuilder = theServerMessage -> {
            if (theValueSetUrl == null && theValueSet == null) {
                return this.getErrorMessage(ERROR_CODE_UNKNOWN_CODE_IN_CODE_SYSTEM, theCodeSystem, theCode, this.getBaseUrl(), theServerMessage);
            }
            return this.getErrorMessage(ERROR_CODE_UNKNOWN_CODE_IN_VALUE_SET, theCodeSystem, theCode, theValueSetUrl, this.getBaseUrl(), theServerMessage);
        };
        IBaseParameters input = this.buildValidateCodeInputParameters(theCodeSystem, theCode, theDisplay, theValueSetUrl, theValueSet);
        String resourceType = "ValueSet";
        if (theValueSet == null && theValueSetUrl == null) {
            resourceType = "CodeSystem";
        }
        try {
            IBaseParameters output = (IBaseParameters)((IOperationUnnamed)client.operation().onType(resourceType)).named("validate-code").withParameters(input).execute();
            return this.createCodeValidationResult(output, errorMessageBuilder, theCode);
        }
        catch (InvalidRequestException | ResourceNotFoundException ex) {
            ourLog.error(ex.getMessage(), ex);
            String errorMessage = errorMessageBuilder.buildErrorMessage(ex.getMessage());
            IValidationSupport.CodeValidationIssueCode issueCode = ex instanceof ResourceNotFoundException ? IValidationSupport.CodeValidationIssueCode.NOT_FOUND : IValidationSupport.CodeValidationIssueCode.CODE_INVALID;
            return this.createErrorCodeValidationResult(issueCode, errorMessage);
        }
    }

    private IValidationSupport.CodeValidationResult createErrorCodeValidationResult(IValidationSupport.CodeValidationIssueCode theIssueCode, String theMessage) {
        IValidationSupport.IssueSeverity severity = IValidationSupport.IssueSeverity.ERROR;
        return new IValidationSupport.CodeValidationResult().setSeverity(severity).setMessage(theMessage).addIssue(new IValidationSupport.CodeValidationIssue(theMessage, severity, theIssueCode, IValidationSupport.CodeValidationIssueCoding.INVALID_CODE));
    }

    private IValidationSupport.CodeValidationResult createCodeValidationResult(IBaseParameters theOutput, ValidationErrorMessageBuilder theMessageBuilder, String theCode) {
        FhirContext fhirContext = this.getFhirContext();
        Optional resultValue = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)theOutput, (String)"result");
        if (!resultValue.isPresent()) {
            throw new IllegalArgumentException(Msg.code((int)2560) + "Parameter `result` is missing from the $validate-code response.");
        }
        boolean success = ((String)resultValue.get()).equalsIgnoreCase("true");
        IValidationSupport.CodeValidationResult result = new IValidationSupport.CodeValidationResult();
        if (success) {
            result.setCode(theCode);
        }
        Optional systemValue = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)theOutput, (String)"system");
        systemValue.ifPresent(arg_0 -> ((IValidationSupport.CodeValidationResult)result).setCodeSystemName(arg_0));
        Optional versionValue = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)theOutput, (String)"version");
        versionValue.ifPresent(arg_0 -> ((IValidationSupport.CodeValidationResult)result).setCodeSystemVersion(arg_0));
        Optional displayValue = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)theOutput, (String)"display");
        displayValue.ifPresent(arg_0 -> ((IValidationSupport.CodeValidationResult)result).setDisplay(arg_0));
        if (success) {
            return result;
        }
        result.setSeverity(IValidationSupport.IssueSeverity.ERROR);
        Optional messageValue = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)theOutput, (String)"message");
        messageValue.ifPresent(value -> result.setMessage(theMessageBuilder.buildErrorMessage((String)value)));
        Optional issuesValue = ParametersUtil.getNamedParameterResource((FhirContext)fhirContext, (IBaseParameters)theOutput, (String)"issues");
        if (issuesValue.isPresent()) {
            RemoteTerminologyServiceValidationSupport.createCodeValidationIssues((IBaseOperationOutcome)issuesValue.get(), fhirContext.getVersion().getVersion()).ifPresent(i -> i.forEach(arg_0 -> ((IValidationSupport.CodeValidationResult)result).addIssue(arg_0)));
        } else {
            result.addIssue(RemoteTerminologyServiceValidationSupport.createCodeValidationIssue(result.getMessage()));
        }
        return result;
    }

    public static Optional<Collection<IValidationSupport.CodeValidationIssue>> createCodeValidationIssues(IBaseOperationOutcome theOperationOutcome, FhirVersionEnum theFhirVersion) {
        if (theFhirVersion == FhirVersionEnum.R4) {
            return Optional.of(RemoteTerminologyServiceValidationSupport.createCodeValidationIssuesR4((OperationOutcome)theOperationOutcome));
        }
        if (theFhirVersion == FhirVersionEnum.DSTU3) {
            return Optional.of(RemoteTerminologyServiceValidationSupport.createCodeValidationIssuesDstu3((org.hl7.fhir.dstu3.model.OperationOutcome)theOperationOutcome));
        }
        return Optional.empty();
    }

    private static Collection<IValidationSupport.CodeValidationIssue> createCodeValidationIssuesR4(OperationOutcome theOperationOutcome) {
        return theOperationOutcome.getIssue().stream().map(issueComponent -> {
            String diagnostics = issueComponent.getDiagnostics();
            IValidationSupport.IssueSeverity issueSeverity = IValidationSupport.IssueSeverity.fromCode((String)issueComponent.getSeverity().toCode());
            String issueTypeCode = issueComponent.getCode().toCode();
            CodeableConcept details = issueComponent.getDetails();
            IValidationSupport.CodeValidationIssue issue = new IValidationSupport.CodeValidationIssue(diagnostics, issueSeverity, issueTypeCode);
            IValidationSupport.CodeValidationIssueDetails issueDetails = new IValidationSupport.CodeValidationIssueDetails(details.getText());
            details.getCoding().forEach(coding -> issueDetails.addCoding(coding.getSystem(), coding.getCode()));
            issue.setDetails(issueDetails);
            return issue;
        }).collect(Collectors.toList());
    }

    private static Collection<IValidationSupport.CodeValidationIssue> createCodeValidationIssuesDstu3(org.hl7.fhir.dstu3.model.OperationOutcome theOperationOutcome) {
        return theOperationOutcome.getIssue().stream().map(issueComponent -> {
            String diagnostics = issueComponent.getDiagnostics();
            IValidationSupport.IssueSeverity issueSeverity = IValidationSupport.IssueSeverity.fromCode((String)issueComponent.getSeverity().toCode());
            String issueTypeCode = issueComponent.getCode().toCode();
            org.hl7.fhir.dstu3.model.CodeableConcept details = issueComponent.getDetails();
            IValidationSupport.CodeValidationIssue issue = new IValidationSupport.CodeValidationIssue(diagnostics, issueSeverity, issueTypeCode);
            IValidationSupport.CodeValidationIssueDetails issueDetails = new IValidationSupport.CodeValidationIssueDetails(details.getText());
            details.getCoding().forEach(coding -> issueDetails.addCoding(coding.getSystem(), coding.getCode()));
            issue.setDetails(issueDetails);
            return issue;
        }).collect(Collectors.toList());
    }

    private static IValidationSupport.CodeValidationIssue createCodeValidationIssue(String theMessage) {
        return new IValidationSupport.CodeValidationIssue(theMessage, IValidationSupport.IssueSeverity.ERROR, IValidationSupport.CodeValidationIssueCode.INVALID, IValidationSupport.CodeValidationIssueCoding.INVALID_CODE);
    }

    protected IBaseParameters buildValidateCodeInputParameters(String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl, IBaseResource theValueSet) {
        FhirContext fhirContext = this.getFhirContext();
        IBaseParameters params = ParametersUtil.newInstance((FhirContext)fhirContext);
        if (theValueSet == null && theValueSetUrl == null) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"url", (String)theCodeSystem);
            ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"code", (String)theCode);
            if (StringUtils.isNotBlank((CharSequence)theDisplay)) {
                ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"display", (String)theDisplay);
            }
            return params;
        }
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"url", (String)theValueSetUrl);
        }
        ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"code", (String)theCode);
        if (StringUtils.isNotBlank((CharSequence)theCodeSystem)) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"system", (String)theCodeSystem);
        }
        if (StringUtils.isNotBlank((CharSequence)theDisplay)) {
            ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"display", (String)theDisplay);
        }
        if (theValueSet != null) {
            ParametersUtil.addParameterToParameters((FhirContext)fhirContext, (IBaseParameters)params, (String)"valueSet", (Object)theValueSet);
        }
        return params;
    }

    public void setBaseUrl(String theBaseUrl) {
        Validate.notBlank((CharSequence)theBaseUrl, (String)"theBaseUrl must be provided", (Object[])new Object[0]);
        this.myBaseUrl = theBaseUrl;
    }

    public void addClientInterceptor(@Nonnull Object theClientInterceptor) {
        Validate.notNull((Object)theClientInterceptor, (String)"theClientInterceptor must not be null", (Object[])new Object[0]);
        this.myClientInterceptors.add(theClientInterceptor);
    }

    public static interface ValidationErrorMessageBuilder {
        public String buildErrorMessage(String var1);
    }
}

