/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.util.ILockable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupport;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class PrePopulatedValidationSupport
extends BaseValidationSupport
implements IValidationSupport,
ILockable {
    private final Map<String, IBaseResource> myUrlToCodeSystems;
    private final Map<String, IBaseResource> myUrlToStructureDefinitions;
    private final Map<String, IBaseResource> myUrlToSearchParameters;
    private final Map<String, IBaseResource> myUrlToValueSets;
    private final List<IBaseResource> myCodeSystems;
    private final List<IBaseResource> myStructureDefinitions;
    private final List<IBaseResource> mySearchParameters;
    private final List<IBaseResource> myValueSets;
    private final Map<String, byte[]> myBinaries;
    private boolean myLocked;

    public PrePopulatedValidationSupport(FhirContext theContext) {
        this(theContext, new HashMap<String, IBaseResource>(), new HashMap<String, IBaseResource>(), new HashMap<String, IBaseResource>(), new HashMap<String, IBaseResource>(), new HashMap<String, byte[]>());
    }

    public String getName() {
        return String.valueOf(this.getFhirContext().getVersion().getVersion()) + " Pre-populated Validation Support";
    }

    public PrePopulatedValidationSupport(FhirContext theFhirContext, Map<String, IBaseResource> theUrlToStructureDefinitions, Map<String, IBaseResource> theUrlToValueSets, Map<String, IBaseResource> theUrlToCodeSystems) {
        this(theFhirContext, theUrlToStructureDefinitions, theUrlToValueSets, theUrlToCodeSystems, new HashMap<String, IBaseResource>(), new HashMap<String, byte[]>());
    }

    public PrePopulatedValidationSupport(FhirContext theFhirContext, Map<String, IBaseResource> theUrlToStructureDefinitions, Map<String, IBaseResource> theUrlToValueSets, Map<String, IBaseResource> theUrlToCodeSystems, Map<String, IBaseResource> theUrlToSearchParameters, Map<String, byte[]> theBinaries) {
        super(theFhirContext);
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        Validate.notNull(theUrlToStructureDefinitions, (String)"theStructureDefinitions must not be null", (Object[])new Object[0]);
        Validate.notNull(theUrlToValueSets, (String)"theValueSets must not be null", (Object[])new Object[0]);
        Validate.notNull(theUrlToCodeSystems, (String)"theCodeSystems must not be null", (Object[])new Object[0]);
        Validate.notNull(theUrlToSearchParameters, (String)"theSearchParameters must not be null", (Object[])new Object[0]);
        Validate.notNull(theBinaries, (String)"theBinaries must not be null", (Object[])new Object[0]);
        this.myUrlToStructureDefinitions = theUrlToStructureDefinitions;
        this.myStructureDefinitions = theUrlToStructureDefinitions.values().stream().distinct().collect(Collectors.toList());
        this.myUrlToValueSets = theUrlToValueSets;
        this.myValueSets = theUrlToValueSets.values().stream().distinct().collect(Collectors.toList());
        this.myUrlToCodeSystems = theUrlToCodeSystems;
        this.myCodeSystems = theUrlToCodeSystems.values().stream().distinct().collect(Collectors.toList());
        this.myUrlToSearchParameters = theUrlToSearchParameters;
        this.mySearchParameters = theUrlToSearchParameters.values().stream().distinct().collect(Collectors.toList());
        this.myBinaries = theBinaries;
    }

    public void addBinary(byte[] theBinary, String theBinaryKey) {
        this.validateNotLocked();
        Validate.notNull((Object)theBinary, (String)"theBinaryKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theBinary, (String)("the" + theBinaryKey + " must not be null"), (Object[])new Object[0]);
        this.myBinaries.put(theBinaryKey, theBinary);
    }

    private synchronized void validateNotLocked() {
        Validate.isTrue((!this.myLocked ? 1 : 0) != 0, (String)"Can not add to validation support, module is locked", (Object[])new Object[0]);
    }

    public void addCodeSystem(IBaseResource theCodeSystem) {
        this.validateNotLocked();
        Set<String> urls = this.processResourceAndReturnUrls(theCodeSystem, "CodeSystem");
        this.addToMap(theCodeSystem, this.myCodeSystems, this.myUrlToCodeSystems, urls);
    }

    private Set<String> processResourceAndReturnUrls(IBaseResource theResource, String theResourceName) {
        Validate.notNull((Object)theResource, (String)("the" + theResourceName + " must not be null"), (Object[])new Object[0]);
        RuntimeResourceDefinition resourceDef = this.getFhirContext().getResourceDefinition(theResource);
        String actualResourceName = resourceDef.getName();
        Validate.isTrue((boolean)actualResourceName.equals(theResourceName), (String)("the" + theResourceName + " must be a " + theResourceName + " - Got: " + actualResourceName), (Object[])new Object[0]);
        Optional urlValue = resourceDef.getChildByName("url").getAccessor().getFirstValueOrNull((IBase)theResource);
        String url = urlValue.map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
        Validate.notNull((Object)url, (String)("the" + theResourceName + ".getUrl() must not return null"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)url, (String)("the" + theResourceName + ".getUrl() must return a value"), (Object[])new Object[0]);
        int pipeIdx = url.indexOf(124);
        String urlWithoutVersion = pipeIdx != -1 ? url.substring(0, pipeIdx) : url;
        HashSet retVal = Sets.newHashSet((Object[])new String[]{url, urlWithoutVersion});
        Optional versionValue = resourceDef.getChildByName("version").getAccessor().getFirstValueOrNull((IBase)theResource);
        String version = versionValue.map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
        if (StringUtils.isNotBlank((CharSequence)version)) {
            retVal.add(urlWithoutVersion + "|" + version);
        }
        return retVal;
    }

    public void addStructureDefinition(IBaseResource theStructureDefinition) {
        this.validateNotLocked();
        Set<String> url = this.processResourceAndReturnUrls(theStructureDefinition, "StructureDefinition");
        this.addToMap(theStructureDefinition, this.myStructureDefinitions, this.myUrlToStructureDefinitions, url);
    }

    public void addSearchParameter(IBaseResource theSearchParameter) {
        this.validateNotLocked();
        Set<String> url = this.processResourceAndReturnUrls(theSearchParameter, "SearchParameter");
        this.addToMap(theSearchParameter, this.mySearchParameters, this.myUrlToSearchParameters, url);
    }

    private <T extends IBaseResource> void addToMap(T theResource, List<T> theList, Map<String, T> theMap, Collection<String> theUrls) {
        theList.add(theResource);
        for (String urls : theUrls) {
            if (!StringUtils.isNotBlank((CharSequence)urls)) continue;
            theMap.put(urls, theResource);
            int lastSlashIdx = urls.lastIndexOf(47);
            if (lastSlashIdx == -1) continue;
            theMap.put(urls.substring(lastSlashIdx + 1), theResource);
            int previousSlashIdx = urls.lastIndexOf(47, lastSlashIdx - 1);
            if (previousSlashIdx == -1) continue;
            theMap.put(urls.substring(previousSlashIdx + 1), theResource);
        }
    }

    public void addValueSet(IBaseResource theValueSet) {
        this.validateNotLocked();
        Set<String> urls = this.processResourceAndReturnUrls(theValueSet, "ValueSet");
        this.addToMap(theValueSet, this.myValueSets, this.myUrlToValueSets, urls);
    }

    public void addResource(@Nonnull IBaseResource theResource) {
        this.validateNotLocked();
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        switch (this.getFhirContext().getResourceType(theResource)) {
            case "SearchParameter": {
                this.addSearchParameter(theResource);
                break;
            }
            case "StructureDefinition": {
                this.addStructureDefinition(theResource);
                break;
            }
            case "CodeSystem": {
                this.addCodeSystem(theResource);
                break;
            }
            case "ValueSet": {
                this.addValueSet(theResource);
            }
        }
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        retVal.addAll(this.myCodeSystems);
        retVal.addAll(this.myStructureDefinitions);
        retVal.addAll(this.myValueSets);
        return retVal;
    }

    @Nullable
    public <T extends IBaseResource> List<T> fetchAllSearchParameters() {
        return Collections.unmodifiableList(this.mySearchParameters);
    }

    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        return Collections.unmodifiableList(this.myStructureDefinitions);
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.myUrlToCodeSystems.get(theSystem);
    }

    public IBaseResource fetchValueSet(String theUri) {
        return this.myUrlToValueSets.get(theUri);
    }

    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.myUrlToStructureDefinitions.get(theUrl);
    }

    public byte[] fetchBinary(String theBinaryKey) {
        return this.myBinaries.get(theBinaryKey);
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return this.myUrlToCodeSystems.containsKey(theSystem);
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return this.myUrlToValueSets.containsKey(theValueSetUrl);
    }

    public int countAll() {
        return this.myBinaries.size() + this.myCodeSystems.size() + this.myStructureDefinitions.size() + this.myValueSets.size() + this.myStructureDefinitions.size();
    }

    public synchronized void lock() {
        this.myLocked = true;
    }
}

