/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.hapi.ctx;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4b.hapi.fhirpath.FhirPathR4B;
import org.hl7.fhir.r4b.hapi.rest.server.R4BBundleFactory;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.IdType;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.StructureDefinition;

public class FhirR4B
implements IFhirVersion {
    private String myId;

    public IFhirPath createFhirPathExecutor(FhirContext theFhirContext) {
        return new FhirPathR4B(theFhirContext);
    }

    public IBaseResource generateProfile(RuntimeResourceDefinition theRuntimeResourceDefinition, String theServerBase) {
        StructureDefinition retVal = new StructureDefinition();
        RuntimeResourceDefinition def = theRuntimeResourceDefinition;
        this.myId = def.getId();
        if (StringUtils.isBlank((CharSequence)this.myId)) {
            this.myId = theRuntimeResourceDefinition.getName().toLowerCase();
        }
        retVal.setId((IIdType)new IdDt(this.myId));
        return retVal;
    }

    public Class<List> getContainedType() {
        return List.class;
    }

    public InputStream getFhirVersionPropertiesFile() {
        String path = "org/hl7/fhir/r4b/hapi/model/fhirversion.properties";
        InputStream str = FhirR4B.class.getResourceAsStream("/" + path);
        if (str == null) {
            str = FhirR4B.class.getResourceAsStream(path);
        }
        if (str == null) {
            throw new ConfigurationException(Msg.code((int)2156) + "Can not find model property file on classpath: " + path);
        }
        return str;
    }

    public IPrimitiveType<Date> getLastUpdated(IBaseResource theResource) {
        return ((Resource)theResource).getMeta().getLastUpdatedElement();
    }

    public String getPathToSchemaDefinitions() {
        return "/org/hl7/fhir/r4b/model/schema";
    }

    public Class<? extends IBaseReference> getResourceReferenceType() {
        return Reference.class;
    }

    public Object getServerVersion() {
        return ReflectionUtil.newInstanceOfFhirServerType((String)"org.hl7.fhir.r4b.hapi.ctx.FhirServerR4B");
    }

    public FhirVersionEnum getVersion() {
        return FhirVersionEnum.R4B;
    }

    public IVersionSpecificBundleFactory newBundleFactory(FhirContext theContext) {
        return new R4BBundleFactory(theContext);
    }

    public IBaseCoding newCodingDt() {
        return new Coding();
    }

    public IIdType newIdType() {
        return new IdType();
    }
}

