/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum EncounterClassEnum {
    INPATIENT("inpatient", "http://hl7.org/fhir/encounter-class"),
    OUTPATIENT("outpatient", "http://hl7.org/fhir/encounter-class"),
    AMBULATORY("ambulatory", "http://hl7.org/fhir/encounter-class"),
    EMERGENCY("emergency", "http://hl7.org/fhir/encounter-class"),
    HOME("home", "http://hl7.org/fhir/encounter-class"),
    FIELD("field", "http://hl7.org/fhir/encounter-class"),
    DAYTIME("daytime", "http://hl7.org/fhir/encounter-class"),
    VIRTUAL("virtual", "http://hl7.org/fhir/encounter-class"),
    OTHER("other", "http://hl7.org/fhir/encounter-class");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "EncounterClass";
    private static Map<String, EncounterClassEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, EncounterClassEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<EncounterClassEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static EncounterClassEnum forCode(String theCode) {
        EncounterClassEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private EncounterClassEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, EncounterClassEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, EncounterClassEnum>>();
        for (EncounterClassEnum next : EncounterClassEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<EncounterClassEnum>(){

            public String toCodeString(EncounterClassEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(EncounterClassEnum theEnum) {
                return theEnum.getSystem();
            }

            public EncounterClassEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public EncounterClassEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, EncounterClassEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

