/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum AdmitSourceEnum {
    TRANSFERRED_FROM_OTHER_HOSPITAL("hosp-trans", "http://hl7.org/fhir/admit-source"),
    FROM_ACCIDENT_EMERGENCY_DEPARTMENT("emd", "http://hl7.org/fhir/admit-source"),
    FROM_OUTPATIENT_DEPARTMENT("outp", "http://hl7.org/fhir/admit-source"),
    BORN_IN_HOSPITAL("born", "http://hl7.org/fhir/admit-source"),
    GENERAL_PRACTITIONER_REFERRAL("gp", "http://hl7.org/fhir/admit-source"),
    MEDICAL_PRACTITIONER_PHYSICIAN_REFERRAL("mp", "http://hl7.org/fhir/admit-source"),
    FROM_NURSING_HOME("nursing", "http://hl7.org/fhir/admit-source"),
    FROM_PSYCHIATRIC_HOSPITAL("psych", "http://hl7.org/fhir/admit-source"),
    FROM_REHABILITATION_FACILITY("rehab", "http://hl7.org/fhir/admit-source"),
    OTHER("other", "http://hl7.org/fhir/admit-source");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "AdmitSource";
    private static Map<String, AdmitSourceEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, AdmitSourceEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<AdmitSourceEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static AdmitSourceEnum forCode(String theCode) {
        AdmitSourceEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private AdmitSourceEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, AdmitSourceEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, AdmitSourceEnum>>();
        for (AdmitSourceEnum next : AdmitSourceEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<AdmitSourceEnum>(){

            public String toCodeString(AdmitSourceEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(AdmitSourceEnum theEnum) {
                return theEnum.getSystem();
            }

            public AdmitSourceEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public AdmitSourceEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, AdmitSourceEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

