/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.util;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SqlUtil {
    private static final Pattern CREATE_TABLE = Pattern.compile("create table ([a-zA-Z0-9_]+).*(\\s|[a-zA-Z0-9,()_])+?primary key\\s+\\(([a-zA-Z_, ]+)\\).*", 42);
    private static final Pattern ALTER_TABLE_ADD_CONSTRAINT_FOREIGN_KEY = Pattern.compile("alter table\\s+(if exists)?\\s+(\\w+)\\s+add constraint\\s+(\\w+)\\s+foreign key \\(([a-zA-Z_, ]+)\\)\\s+references (\\w+).*", 42);

    private SqlUtil() {
    }

    @Nonnull
    public static List<String> splitSqlFileIntoStatements(String theSql) {
        String sqlWithoutComments = Arrays.stream(theSql.split("\n")).filter(t -> !t.trim().startsWith("--")).collect(Collectors.joining("\n"));
        return Arrays.stream(sqlWithoutComments.split(";")).filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toList());
    }

    @Nonnull
    public static Optional<CreateTablePrimaryKey> parseCreateTableStatementPrimaryKey(String theStatement) {
        Matcher matcher = CREATE_TABLE.matcher(theStatement);
        if (matcher.find()) {
            String tableName = matcher.group(1).toUpperCase(Locale.US);
            String primaryKeyColumnsString = matcher.group(3);
            List<String> primaryKeyColumns = SqlUtil.splitCommaSeparatedList(primaryKeyColumnsString);
            return Optional.of(new CreateTablePrimaryKey(tableName, primaryKeyColumns));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<AlterTableAddConstraint> parseAlterTableAddConstraintConstraintForeignKey(String theStatement) {
        Matcher matcher = ALTER_TABLE_ADD_CONSTRAINT_FOREIGN_KEY.matcher(theStatement);
        if (matcher.find()) {
            String tableName = matcher.group(2);
            String constraintName = matcher.group(3);
            String columnsString = matcher.group(4);
            String references = matcher.group(5);
            List<String> columns = SqlUtil.splitCommaSeparatedList(columnsString);
            return Optional.of(new AlterTableAddConstraint(tableName, constraintName, columns, references));
        }
        return Optional.empty();
    }

    @Nonnull
    private static List<String> splitCommaSeparatedList(String primaryKeyColumnsString) {
        return Arrays.asList(StringUtils.split((String)primaryKeyColumnsString, (String)", "));
    }

    public static class CreateTablePrimaryKey {
        private final String myTableName;
        private final List<String> myPrimaryKeyColumns;

        public CreateTablePrimaryKey(String theTableName, List<String> thePrimaryKeyColumns) {
            this.myTableName = theTableName;
            this.myPrimaryKeyColumns = thePrimaryKeyColumns;
        }

        public List<String> getPrimaryKeyColumns() {
            return this.myPrimaryKeyColumns;
        }

        public String getTableName() {
            return this.myTableName;
        }
    }

    public static class AlterTableAddConstraint {
        private final String myConstraintName;
        private final List<String> myColumns;
        private final String myTableName;
        private final String myReferences;

        public AlterTableAddConstraint(String theTableName, String theConstraintName, List<String> theColumns, String theReferences) {
            Validate.isTrue((boolean)theTableName.matches("^[a-zA-Z0-9_]+$"), (String)"Invalid table name '%s'", (Object[])new Object[]{theTableName});
            Validate.isTrue((boolean)theConstraintName.matches("^[a-zA-Z0-9_]+$"), (String)"Invalid constraint name '%s'", (Object[])new Object[]{theConstraintName});
            Validate.isTrue((boolean)theReferences.matches("^[a-zA-Z0-9_]+$"), (String)"Invalid reference '%s'", (Object[])new Object[]{theReferences});
            Validate.isTrue((!theColumns.isEmpty() ? 1 : 0) != 0, (String)"Invalid columns '%s'", (Object[])new Object[]{theColumns});
            Validate.isTrue((theColumns.stream().map(t -> t.matches("^[a-zA-Z0-9_]+$")).filter(t -> t).count() == (long)theColumns.size() ? 1 : 0) != 0, (String)"Invalid columns '%s'", (Object[])new Object[]{theColumns});
            this.myTableName = theTableName;
            this.myConstraintName = theConstraintName;
            this.myColumns = theColumns;
            this.myReferences = theReferences;
        }

        public String getReferences() {
            return this.myReferences;
        }

        public List<String> getColumns() {
            return this.myColumns;
        }

        public String getTableName() {
            return this.myTableName;
        }

        public String getConstraintName() {
            return this.myConstraintName;
        }
    }
}

