/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.dao;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.dao.MigrationQueryBuilder;
import ca.uhn.fhir.jpa.migrate.entity.HapiMigrationEntity;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.VersionEnum;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.flywaydb.core.api.MigrationVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class HapiMigrationDao {
    private static final Logger ourLog = LoggerFactory.getLogger(HapiMigrationDao.class);
    private final JdbcTemplate myJdbcTemplate;
    private final String myMigrationTablename;
    private final MigrationQueryBuilder myMigrationQueryBuilder;
    private final DataSource myDataSource;

    public HapiMigrationDao(DataSource theDataSource, DriverTypeEnum theDriverType, String theMigrationTablename) {
        this.myDataSource = theDataSource;
        this.myJdbcTemplate = new JdbcTemplate(theDataSource);
        this.myMigrationTablename = theMigrationTablename;
        this.myMigrationQueryBuilder = new MigrationQueryBuilder(theDriverType, theMigrationTablename);
    }

    public String getMigrationTablename() {
        return this.myMigrationTablename;
    }

    public Set<MigrationVersion> fetchSuccessfulMigrationVersions() {
        List<HapiMigrationEntity> allEntries = this.findAll();
        return allEntries.stream().filter(HapiMigrationEntity::getSuccess).map(HapiMigrationEntity::getVersion).map(MigrationVersion::fromVersion).collect(Collectors.toSet());
    }

    public void deleteAll() {
        this.myJdbcTemplate.execute(this.myMigrationQueryBuilder.deleteAll());
    }

    public boolean save(HapiMigrationEntity theEntity) {
        Validate.notNull((Object)theEntity.getDescription(), (String)"Description may not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theEntity.getExecutionTime(), (String)"Execution time may not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theEntity.getSuccess(), (String)"Success may not be null", (Object[])new Object[0]);
        if (theEntity.getPid() == null) {
            Integer highestKey = this.getHighestKey();
            if (highestKey == null || highestKey < 0) {
                highestKey = 0;
            }
            Integer nextAvailableKey = highestKey + 1;
            theEntity.setPid(nextAvailableKey);
        }
        theEntity.setType("JDBC");
        theEntity.setScript("HAPI FHIR");
        theEntity.setInstalledBy(VersionEnum.latestVersion().name());
        theEntity.setInstalledOn(new Date());
        String insertRecordStatement = this.myMigrationQueryBuilder.insertPreparedStatement();
        int changedRecordCount = this.myJdbcTemplate.update(insertRecordStatement, theEntity.asPreparedStatementSetter());
        return changedRecordCount > 0;
    }

    private Integer getHighestKey() {
        String highestKeyQuery = this.myMigrationQueryBuilder.getHighestKeyQuery();
        return (Integer)this.myJdbcTemplate.queryForObject(highestKeyQuery, Integer.class);
    }

    public boolean createMigrationTableIfRequired() {
        if (this.migrationTableExists()) {
            if (!this.columnExists("result")) {
                String addResultColumnStatement = this.myMigrationQueryBuilder.addResultColumnStatement();
                ourLog.info(addResultColumnStatement);
                this.myJdbcTemplate.execute(addResultColumnStatement);
            }
            return false;
        }
        ourLog.info("Creating table {}", (Object)this.myMigrationTablename);
        String createTableStatement = this.myMigrationQueryBuilder.createTableStatement();
        ourLog.info(createTableStatement);
        this.myJdbcTemplate.execute(createTableStatement);
        String createIndexStatement = this.myMigrationQueryBuilder.createIndexStatement();
        ourLog.info(createIndexStatement);
        this.myJdbcTemplate.execute(createIndexStatement);
        HapiMigrationEntity entity = HapiMigrationEntity.tableCreatedRecord();
        this.myJdbcTemplate.update(this.myMigrationQueryBuilder.insertPreparedStatement(), entity.asPreparedStatementSetter());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean migrationTableExists() {
        try (Connection connection = this.myDataSource.getConnection();){
            ResultSet tables = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), null, null);
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                if (!this.myMigrationTablename.equalsIgnoreCase(tableName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new InternalErrorException(Msg.code((int)2141) + String.valueOf(e));
        }
    }

    private boolean columnExists(String theColumnName) {
        boolean bl;
        block8: {
            Connection connection = this.myDataSource.getConnection();
            try {
                ResultSet columnsUpper = connection.getMetaData().getColumns(connection.getCatalog(), connection.getSchema(), this.myMigrationTablename, theColumnName.toUpperCase());
                ResultSet columnsLower = connection.getMetaData().getColumns(connection.getCatalog(), connection.getSchema(), this.myMigrationTablename, theColumnName.toLowerCase());
                boolean bl2 = bl = columnsUpper.next() || columnsLower.next();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new InternalErrorException(Msg.code((int)2615) + "Error checking column existence: " + e.getMessage(), (Throwable)e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public List<HapiMigrationEntity> findAll() {
        String allQuery = this.myMigrationQueryBuilder.findAllQuery();
        ourLog.debug("Executing query: [{}]", (Object)allQuery);
        return this.myJdbcTemplate.query(allQuery, HapiMigrationEntity.rowMapper());
    }

    public boolean deleteLockRecord(Integer theLockPid, String theLockDescription) {
        int recordsChanged = this.myJdbcTemplate.update(this.myMigrationQueryBuilder.deleteLockRecordStatement(theLockPid, theLockDescription));
        return recordsChanged > 0;
    }

    public Optional<HapiMigrationEntity> findFirstByPidAndNotDescription(Integer theLockPid, String theLockDescription) {
        String query = this.myMigrationQueryBuilder.findByPidAndNotDescriptionQuery(theLockPid, theLockDescription);
        return this.myJdbcTemplate.query(query, HapiMigrationEntity.rowMapper()).stream().findFirst();
    }
}

