/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public final class DriverTypeEnum
extends Enum<DriverTypeEnum> {
    public static final /* enum */ DriverTypeEnum H2_EMBEDDED = new DriverTypeEnum("org.h2.Driver", false);
    public static final /* enum */ DriverTypeEnum DERBY_EMBEDDED = new DriverTypeEnum("org.apache.derby.jdbc.EmbeddedDriver", true);
    public static final /* enum */ DriverTypeEnum MARIADB_10_1 = new DriverTypeEnum("org.mariadb.jdbc.Driver", false);
    public static final /* enum */ DriverTypeEnum MYSQL_5_7 = new DriverTypeEnum("com.mysql.cj.jdbc.Driver", false);
    public static final /* enum */ DriverTypeEnum POSTGRES_9_4 = new DriverTypeEnum("org.postgresql.Driver", false);
    public static final /* enum */ DriverTypeEnum ORACLE_12C = new DriverTypeEnum("oracle.jdbc.OracleDriver", false);
    public static final /* enum */ DriverTypeEnum MSSQL_2012 = new DriverTypeEnum("com.microsoft.sqlserver.jdbc.SQLServerDriver", false);
    public static final /* enum */ DriverTypeEnum COCKROACHDB_21_1 = new DriverTypeEnum("org.postgresql.Driver", false);
    private static final Logger ourLog;
    private String myDriverClassName;
    private boolean myDerby;
    private static final /* synthetic */ DriverTypeEnum[] $VALUES;

    public static DriverTypeEnum[] values() {
        return (DriverTypeEnum[])$VALUES.clone();
    }

    public static DriverTypeEnum valueOf(String name) {
        return Enum.valueOf(DriverTypeEnum.class, name);
    }

    private DriverTypeEnum(String theDriverClassName, boolean theDerby) {
        this.myDriverClassName = theDriverClassName;
        this.myDerby = theDerby;
    }

    public static DriverTypeEnum fromDriverClassName(String theDriverClassName) {
        for (DriverTypeEnum driverTypeEnum : DriverTypeEnum.values()) {
            if (!driverTypeEnum.myDriverClassName.equals(theDriverClassName)) continue;
            return driverTypeEnum;
        }
        return null;
    }

    public String getDriverClassName() {
        return this.myDriverClassName;
    }

    public String getSchemaFilename() {
        return switch (this) {
            case H2_EMBEDDED -> "h2.sql";
            case DERBY_EMBEDDED -> "derby.sql";
            case MYSQL_5_7, MARIADB_10_1 -> "mysql.sql";
            case POSTGRES_9_4 -> "postgres.sql";
            case ORACLE_12C -> "oracle.sql";
            case MSSQL_2012 -> "sqlserver.sql";
            case COCKROACHDB_21_1 -> "cockroachdb.sql";
            default -> throw new ConfigurationException(Msg.code((int)45) + "No schema initialization script available for driver " + String.valueOf((Object)this));
        };
    }

    public ConnectionProperties newConnectionProperties(String theUrl, String theUsername, String thePassword) {
        BasicDataSource dataSource = new BasicDataSource(){

            public Connection getConnection() throws SQLException {
                ourLog.debug("Creating new DB connection");
                return super.getConnection();
            }
        };
        dataSource.setDriverClassName(this.myDriverClassName);
        dataSource.setUrl(theUrl);
        dataSource.setUsername(theUsername);
        dataSource.setPassword(thePassword);
        assert (dataSource.getJmxName() == null);
        return this.newConnectionProperties((DataSource)dataSource);
    }

    @Nonnull
    public ConnectionProperties newConnectionProperties(DataSource theDataSource) {
        try {
            Class.forName(this.myDriverClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalErrorException(Msg.code((int)46) + "Unable to find driver class: " + this.myDriverClassName, (Throwable)e);
        }
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(theDataSource);
        transactionManager.afterPropertiesSet();
        TransactionTemplate txTemplate = new TransactionTemplate();
        txTemplate.setTransactionManager((PlatformTransactionManager)transactionManager);
        txTemplate.setPropagationBehavior(3);
        txTemplate.afterPropertiesSet();
        return new ConnectionProperties(theDataSource, txTemplate, this);
    }

    private static /* synthetic */ DriverTypeEnum[] $values() {
        return new DriverTypeEnum[]{H2_EMBEDDED, DERBY_EMBEDDED, MARIADB_10_1, MYSQL_5_7, POSTGRES_9_4, ORACLE_12C, MSSQL_2012, COCKROACHDB_21_1};
    }

    static {
        $VALUES = DriverTypeEnum.$values();
        ourLog = LoggerFactory.getLogger(DriverTypeEnum.class);
    }

    public static class ConnectionProperties
    implements AutoCloseable {
        private final DriverTypeEnum myDriverType;
        private final DataSource myDataSource;
        private final TransactionTemplate myTxTemplate;

        public ConnectionProperties(DataSource theDataSource, TransactionTemplate theTxTemplate, DriverTypeEnum theDriverType) {
            Validate.notNull((Object)theDataSource);
            Validate.notNull((Object)theTxTemplate);
            Validate.notNull((Object)((Object)theDriverType));
            this.myDataSource = theDataSource;
            this.myTxTemplate = theTxTemplate;
            this.myDriverType = theDriverType;
        }

        public DriverTypeEnum getDriverType() {
            return this.myDriverType;
        }

        @Nonnull
        public DataSource getDataSource() {
            return this.myDataSource;
        }

        @Nonnull
        public JdbcTemplate newJdbcTemplate() {
            JdbcTemplate jdbcTemplate = new JdbcTemplate();
            jdbcTemplate.setDataSource(this.myDataSource);
            return jdbcTemplate;
        }

        @Nonnull
        public TransactionTemplate getTxTemplate() {
            return this.myTxTemplate;
        }

        @Override
        public void close() {
            if (this.myDataSource instanceof DisposableBean) {
                try {
                    ((DisposableBean)this.myDataSource).destroy();
                }
                catch (Exception e) {
                    ourLog.warn("Could not dispose of driver", (Throwable)e);
                }
            }
        }
    }
}

