/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameTableTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(RenameTableTask.class);
    private final String myOldTableName;
    private final String myNewTableName;
    private boolean myDeleteTargetColumnFirstIfExist = true;

    public RenameTableTask(String theProductVersion, String theSchemaVersion, String theOldTableName, String theNewTableName) {
        super(theProductVersion, theSchemaVersion);
        this.myOldTableName = theOldTableName;
        this.myNewTableName = theNewTableName;
    }

    @Override
    public void validate() {
        this.setDescription("Rename table " + this.getOldTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> tableNames = JdbcUtils.getTableNames(this.getConnectionProperties());
        boolean hasTableWithNewTableName = tableNames.contains(this.getNewTableName());
        String sql = this.buildRenameTableSqlStatement();
        this.logInfo(ourLog, "Renaming table: {}", this.getOldTableName());
        this.executeSql(this.getOldTableName(), sql, new Object[0]);
    }

    public void setDeleteTargetColumnFirstIfExist(boolean theDeleteTargetColumnFirstIfExist) {
        this.myDeleteTargetColumnFirstIfExist = theDeleteTargetColumnFirstIfExist;
    }

    public String getNewTableName() {
        return this.myNewTableName;
    }

    public String getOldTableName() {
        return this.myOldTableName;
    }

    String buildRenameTableSqlStatement() {
        String oldTableName = this.getOldTableName();
        String newTableName = this.getNewTableName();
        return switch (this.getDriverType()) {
            case DriverTypeEnum.MYSQL_5_7, DriverTypeEnum.DERBY_EMBEDDED -> "rename table " + oldTableName + " to " + newTableName;
            case DriverTypeEnum.ORACLE_12C, DriverTypeEnum.MARIADB_10_1, DriverTypeEnum.POSTGRES_9_4, DriverTypeEnum.COCKROACHDB_21_1, DriverTypeEnum.H2_EMBEDDED -> "alter table " + oldTableName + " rename to " + newTableName;
            case DriverTypeEnum.MSSQL_2012 -> "sp_rename '" + oldTableName + "', '" + newTableName + "'";
            default -> throw new IllegalStateException(Msg.code((int)2513));
        };
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myOldTableName);
        theBuilder.append((Object)this.myNewTableName);
    }
}

