/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.entity;

import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.util.VersionEnum;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import java.util.Date;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

@Entity
public class HapiMigrationEntity {
    public static final int VERSION_MAX_SIZE = 50;
    public static final int DESCRIPTION_MAX_SIZE = 200;
    public static final int TYPE_MAX_SIZE = 20;
    public static final int SCRIPT_MAX_SIZE = 1000;
    public static final int INSTALLED_BY_MAX_SIZE = 100;
    public static final int RESULT_MAX_SIZE = 100;
    public static final int CREATE_TABLE_PID = -1;
    public static final String INITIAL_RECORD_DESCRIPTION = "<< HAPI FHIR Schema History table created >>";
    public static final String INITIAL_RECORD_SCRIPT = "HAPI FHIR";
    @Id
    @GenericGenerator(name="SEQ_FLY_HFJ_MIGRATION", strategy="ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_FLY_HFJ_MIGRATION")
    @Column(name="INSTALLED_RANK")
    private Integer myPid;
    @Column(name="VERSION", length=50)
    private String myVersion;
    @Column(name="DESCRIPTION", length=200)
    private String myDescription;
    @Column(name="TYPE", length=20)
    private String myType;
    @Column(name="SCRIPT", length=1000)
    private String myScript;
    @Column(name="CHECKSUM")
    private Integer myChecksum;
    @Column(name="INSTALLED_BY", length=100)
    private String myInstalledBy;
    @Column(name="INSTALLED_ON")
    private Date myInstalledOn;
    @Column(name="EXECUTION_TIME")
    private Integer myExecutionTime;
    @Column(name="SUCCESS")
    private Boolean mySuccess;
    @Column(name="RESULT", length=100)
    private String myResult;

    public static HapiMigrationEntity tableCreatedRecord() {
        HapiMigrationEntity retVal = new HapiMigrationEntity();
        retVal.setPid(-1);
        retVal.setDescription(INITIAL_RECORD_DESCRIPTION);
        retVal.setType("TABLE");
        retVal.setScript(INITIAL_RECORD_SCRIPT);
        retVal.setInstalledBy(VersionEnum.latestVersion().name());
        retVal.setInstalledOn(new Date());
        retVal.setExecutionTime(0);
        retVal.setSuccess(true);
        return retVal;
    }

    public Integer getPid() {
        return this.myPid;
    }

    public void setPid(Integer thePid) {
        this.myPid = thePid;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String theVersion) {
        this.myVersion = theVersion;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String theDescription) {
        this.myDescription = theDescription;
    }

    public String getType() {
        return this.myType;
    }

    public void setType(String theType) {
        this.myType = theType;
    }

    public String getScript() {
        return this.myScript;
    }

    public void setScript(String theScript) {
        this.myScript = theScript;
    }

    public Integer getChecksum() {
        return this.myChecksum;
    }

    public void setChecksum(Integer theChecksum) {
        this.myChecksum = theChecksum;
    }

    public String getInstalledBy() {
        return this.myInstalledBy;
    }

    public void setInstalledBy(String theInstalledBy) {
        this.myInstalledBy = theInstalledBy;
    }

    public Date getInstalledOn() {
        return this.myInstalledOn;
    }

    public void setInstalledOn(Date theInstalledOn) {
        this.myInstalledOn = theInstalledOn;
    }

    public Integer getExecutionTime() {
        return this.myExecutionTime;
    }

    public void setExecutionTime(Integer theExecutionTime) {
        this.myExecutionTime = theExecutionTime;
    }

    public Boolean getSuccess() {
        return this.mySuccess;
    }

    public void setSuccess(Boolean theSuccess) {
        this.mySuccess = theSuccess;
    }

    public static HapiMigrationEntity fromBaseTask(BaseTask theTask) {
        HapiMigrationEntity retval = new HapiMigrationEntity();
        retval.setVersion(theTask.getMigrationVersion());
        retval.setDescription(theTask.getDescription());
        retval.setChecksum(theTask.hashCode());
        retval.setType("JDBC");
        return retval;
    }

    public static RowMapper<HapiMigrationEntity> rowMapper() {
        return (rs, rowNum) -> {
            HapiMigrationEntity entity = new HapiMigrationEntity();
            entity.setPid(rs.getInt(1));
            entity.setVersion(rs.getString(2));
            entity.setDescription(rs.getString(3));
            entity.setType(rs.getString(4));
            entity.setScript(rs.getString(5));
            entity.setChecksum(rs.getInt(6));
            entity.setInstalledBy(rs.getString(7));
            entity.setInstalledOn(rs.getDate(8));
            entity.setExecutionTime(rs.getInt(9));
            entity.setSuccess(rs.getBoolean(10));
            entity.setResult(rs.getString(11));
            return entity;
        };
    }

    public PreparedStatementSetter asPreparedStatementSetter() {
        return ps -> {
            ps.setInt(1, this.getPid());
            ps.setString(2, this.getVersion());
            ps.setString(3, this.getDescription());
            ps.setString(4, this.getType());
            ps.setString(5, this.getScript());
            if (this.getChecksum() == null) {
                ps.setNull(6, 4);
            } else {
                ps.setInt(6, this.getChecksum());
            }
            ps.setString(7, this.getInstalledBy());
            ps.setDate(8, this.getInstalledOn() != null ? new java.sql.Date(this.getInstalledOn().getTime()) : null);
            ps.setInt(9, this.getExecutionTime());
            ps.setBoolean(10, this.getSuccess());
            ps.setString(11, this.getResult());
        };
    }

    public String getResult() {
        return this.myResult;
    }

    public void setResult(String theResult) {
        this.myResult = theResult;
    }
}

