/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.tasks.api;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.MigrationJdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.AddColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.AddForeignKeyTask;
import ca.uhn.fhir.jpa.migrate.taskdef.AddIdGeneratorTask;
import ca.uhn.fhir.jpa.migrate.taskdef.AddIndexTask;
import ca.uhn.fhir.jpa.migrate.taskdef.AddPrimaryKeyTask;
import ca.uhn.fhir.jpa.migrate.taskdef.AddTableByColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.AddTableRawSqlTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.DropColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropForeignKeyTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropIdGeneratorTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropIndexTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropPrimaryKeyTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ExecuteRawSqlTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ExecuteTaskPrecondition;
import ca.uhn.fhir.jpa.migrate.taskdef.InitializeSchemaTask;
import ca.uhn.fhir.jpa.migrate.taskdef.MigrateColumBlobTypeToBinaryTypeTask;
import ca.uhn.fhir.jpa.migrate.taskdef.MigrateColumnClobTypeToTextTypeTask;
import ca.uhn.fhir.jpa.migrate.taskdef.MigratePostgresTextClobToBinaryClobTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ModifyColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.NopTask;
import ca.uhn.fhir.jpa.migrate.taskdef.RenameColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.RenameIndexTask;
import ca.uhn.fhir.jpa.migrate.taskdef.RenameTableTask;
import ca.uhn.fhir.jpa.migrate.tasks.api.BaseMigrationTasks;
import ca.uhn.fhir.jpa.migrate.tasks.api.ColumnAndNullable;
import ca.uhn.fhir.jpa.migrate.tasks.api.ISchemaInitializationProvider;
import ca.uhn.fhir.jpa.migrate.tasks.api.TaskFlagEnum;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder {
    private static final Logger ourLog = LoggerFactory.getLogger(Builder.class);
    private final String myRelease;
    private final BaseMigrationTasks.IAcceptsTasks mySink;

    public Builder(String theRelease, BaseMigrationTasks.IAcceptsTasks theSink) {
        this.myRelease = theRelease;
        this.mySink = theSink;
    }

    public BuilderWithTableName onTable(String theTableName) {
        return new BuilderWithTableName(this.myRelease, this.mySink, theTableName);
    }

    public void addTask(BaseTask theTask) {
        this.mySink.addTask(theTask);
    }

    public BuilderAddTableRawSql addTableRawSql(String theVersion, String theTableName) {
        return new BuilderAddTableRawSql(theVersion, theTableName);
    }

    public BuilderCompleteTask executeRawSql(String theVersion, @Language(value="SQL") String theSql) {
        ExecuteRawSqlTask task = this.executeRawSqlOptional(theVersion, theSql);
        return new BuilderCompleteTask(task);
    }

    public void executeRawSqlStub(String theVersion, @Language(value="SQL") String theSql) {
        BuilderCompleteTask task = this.executeRawSql(theVersion, theSql);
        task.withFlag(TaskFlagEnum.DO_NOTHING);
    }

    private ExecuteRawSqlTask executeRawSqlOptional(String theVersion, @Language(value="SQL") String theSql) {
        ExecuteRawSqlTask task = new ExecuteRawSqlTask(this.myRelease, theVersion).addSql(theSql);
        this.mySink.addTask(task);
        return task;
    }

    public InitializeSchemaTask initializeSchema(String theVersion, ISchemaInitializationProvider theSchemaInitializationProvider) {
        InitializeSchemaTask task = new InitializeSchemaTask(this.myRelease, theVersion, theSchemaInitializationProvider);
        this.mySink.addTask(task);
        return task;
    }

    public InitializeSchemaTask initializeSchema(String theVersion, String theSchemaName, ISchemaInitializationProvider theSchemaInitializationProvider) {
        InitializeSchemaTask task = new InitializeSchemaTask(this.myRelease, theVersion, theSchemaInitializationProvider);
        task.setDescription("Initialize " + theSchemaName + " schema");
        this.mySink.addTask(task);
        return task;
    }

    public Builder executeRawSql(String theVersion, DriverTypeEnum theDriver, @Language(value="SQL") String theSql) {
        this.mySink.addTask(new ExecuteRawSqlTask(this.myRelease, theVersion).addSql(theDriver, theSql));
        return this;
    }

    public Builder executeRawSql(String theVersion, Map<DriverTypeEnum, String> theDriverToSql) {
        HashMap<DriverTypeEnum, List<String>> singleSqlStatementMap = new HashMap<DriverTypeEnum, List<String>>();
        theDriverToSql.entrySet().stream().forEach(entry -> singleSqlStatementMap.put((DriverTypeEnum)((Object)((Object)entry.getKey())), Collections.singletonList((String)entry.getValue())));
        return this.executeRawSqls(theVersion, singleSqlStatementMap);
    }

    public Builder executeRawSqls(String theVersion, Map<DriverTypeEnum, List<String>> theDriverToSqls) {
        ExecuteRawSqlTask executeRawSqlTask = new ExecuteRawSqlTask(this.myRelease, theVersion);
        theDriverToSqls.entrySet().stream().forEach(entry -> ((List)entry.getValue()).forEach(sql -> executeRawSqlTask.addSql((DriverTypeEnum)((Object)((Object)((Object)entry.getKey()))), (String)sql)));
        this.mySink.addTask(executeRawSqlTask);
        return this;
    }

    @Deprecated
    public Builder startSectionWithMessage(String theMessage) {
        return this;
    }

    public BuilderAddTableByColumns addTableByColumns(String theVersion, String theTableName, String ... thePkColumnNames) {
        return new BuilderAddTableByColumns(this.myRelease, theVersion, this.mySink, theTableName, Arrays.asList(thePkColumnNames));
    }

    public void addIdGenerator(String theVersion, String theGeneratorName) {
        AddIdGeneratorTask task = new AddIdGeneratorTask(this.myRelease, theVersion, theGeneratorName);
        this.addTask(task);
    }

    public BuilderCompleteTask dropIdGenerator(String theVersion, String theIdGeneratorName) {
        DropIdGeneratorTask task = new DropIdGeneratorTask(this.myRelease, theVersion, theIdGeneratorName);
        this.addTask(task);
        return new BuilderCompleteTask(task);
    }

    public void addNop(String theVersion) {
        this.addTask(new NopTask(this.myRelease, theVersion));
    }

    public String getRelease() {
        return this.myRelease;
    }

    public static class BuilderWithTableName
    implements BaseMigrationTasks.IAcceptsTasks {
        private final String myRelease;
        private final BaseMigrationTasks.IAcceptsTasks mySink;
        private final String myTableName;
        private BaseTask myLastAddedTask;

        public BuilderWithTableName(String theRelease, BaseMigrationTasks.IAcceptsTasks theSink, String theTableName) {
            this.myRelease = theRelease;
            this.mySink = theSink;
            this.myTableName = theTableName;
        }

        public String getTableName() {
            return this.myTableName;
        }

        public BuilderCompleteTask dropIndex(String theVersion, String theIndexName) {
            DropIndexTask task = this.dropIndexOptional(theVersion, theIndexName);
            return new BuilderCompleteTask(task);
        }

        public BuilderCompleteTask dropIndexOnline(String theVersion, String theIndexName) {
            DropIndexTask task = this.dropIndexOptional(theVersion, theIndexName);
            task.setOnline(true);
            return new BuilderCompleteTask(task);
        }

        public void dropIndexStub(String theVersion, String theIndexName) {
            DropIndexTask task = this.dropIndexOptional(theVersion, theIndexName);
            task.addFlag(TaskFlagEnum.DO_NOTHING);
        }

        private DropIndexTask dropIndexOptional(String theVersion, String theIndexName) {
            DropIndexTask task = new DropIndexTask(this.myRelease, theVersion);
            task.setIndexName(theIndexName);
            task.setTableName(this.myTableName);
            this.addTask(task);
            return task;
        }

        @Deprecated
        public void renameIndex(String theVersion, String theOldIndexName, String theNewIndexName) {
            this.renameIndexOptional(theVersion, theOldIndexName, theNewIndexName);
        }

        public void renameIndexStub(String theVersion, String theOldIndexName, String theNewIndexName) {
            RenameIndexTask task = this.renameIndexOptional(theVersion, theOldIndexName, theNewIndexName);
            task.addFlag(TaskFlagEnum.DO_NOTHING);
        }

        private RenameIndexTask renameIndexOptional(String theVersion, String theOldIndexName, String theNewIndexName) {
            RenameIndexTask task = new RenameIndexTask(this.myRelease, theVersion);
            task.setOldIndexName(theOldIndexName);
            task.setNewIndexName(theNewIndexName);
            task.setTableName(this.myTableName);
            this.addTask(task);
            return task;
        }

        public void dropThisTable(String theVersion) {
            DropTableTask task = new DropTableTask(this.myRelease, theVersion);
            task.setTableName(this.myTableName);
            this.addTask(task);
        }

        public BuilderAddIndexWithName addIndex(String theVersion, String theIndexName) {
            return new BuilderAddIndexWithName(theVersion, theIndexName);
        }

        public BuilderAddColumnWithName addColumn(String theVersion, String theColumnName) {
            return new BuilderAddColumnWithName(this.myRelease, theVersion, theColumnName, null, this);
        }

        public BuilderAddColumnWithName addColumn(String theVersion, String theColumnName, Object theDefaultValue) {
            return new BuilderAddColumnWithName(this.myRelease, theVersion, theColumnName, theDefaultValue, this);
        }

        public BuilderCompleteTask dropColumn(String theVersion, String theColumnName) {
            Validate.notBlank((CharSequence)theColumnName);
            DropColumnTask task = new DropColumnTask(this.myRelease, theVersion);
            task.setTableName(this.myTableName);
            task.setColumnName(theColumnName);
            this.addTask(task);
            return new BuilderCompleteTask(task);
        }

        @Override
        public void addTask(BaseTask theTask) {
            ((BaseTableTask)theTask).setTableName(this.myTableName);
            this.myLastAddedTask = theTask;
            this.mySink.addTask(theTask);
        }

        public BuilderModifyColumnWithName modifyColumn(String theVersion, String theColumnName) {
            return new BuilderModifyColumnWithName(theVersion, theColumnName);
        }

        public BuilderAddForeignKey addForeignKey(String theVersion, String theForeignKeyName) {
            return new BuilderAddForeignKey(theVersion, theForeignKeyName);
        }

        public BuilderWithTableName renameColumn(String theVersion, String theOldName, String theNewName) {
            return this.renameColumn(theVersion, theOldName, theNewName, false, false);
        }

        public BuilderWithTableName renameColumn(String theVersion, String theOldName, String theNewName, boolean isOkayIfNeitherColumnExists, boolean theDeleteTargetColumnFirstIfBothExist) {
            RenameColumnTask task = new RenameColumnTask(this.myRelease, theVersion);
            task.setTableName(this.myTableName);
            task.setOldName(theOldName);
            task.setNewName(theNewName);
            task.setOkayIfNeitherColumnExists(isOkayIfNeitherColumnExists);
            task.setDeleteTargetColumnFirstIfBothExist(theDeleteTargetColumnFirstIfBothExist);
            this.addTask(task);
            return this;
        }

        public Optional<BaseTask> getLastAddedTask() {
            return Optional.ofNullable(this.myLastAddedTask);
        }

        public void addPrimaryKey(String theVersion, String ... theColumnsInOrder) {
            this.addTask(new AddPrimaryKeyTask(this.myRelease, theVersion, this.myTableName, theColumnsInOrder));
        }

        public BuilderCompleteTask dropForeignKey(String theVersion, String theFkName, String theParentTableName) {
            DropForeignKeyTask task = new DropForeignKeyTask(this.myRelease, theVersion);
            task.setConstraintName(theFkName);
            task.setTableName(this.getTableName());
            task.setParentTableName(theParentTableName);
            this.addTask(task);
            return new BuilderCompleteTask(task);
        }

        public BuilderCompleteTask renameTable(String theVersion, String theNewTableName) {
            RenameTableTask task = new RenameTableTask(this.myRelease, theVersion, this.getTableName(), theNewTableName);
            this.addTask(task);
            return new BuilderCompleteTask(task);
        }

        public BuilderCompleteTask migratePostgresTextClobToBinaryClob(String theVersion, String theColumnName) {
            MigratePostgresTextClobToBinaryClobTask task = new MigratePostgresTextClobToBinaryClobTask(this.myRelease, theVersion);
            task.setTableName(this.getTableName());
            task.setColumnName(theColumnName);
            this.addTask(task);
            return new BuilderCompleteTask(task);
        }

        public BuilderCompleteTask migrateBlobToBinary(String theVersion, String theFromColumName, String theToColumName) {
            MigrateColumBlobTypeToBinaryTypeTask task = new MigrateColumBlobTypeToBinaryTypeTask(this.myRelease, theVersion, this.getTableName(), theFromColumName, theToColumName);
            this.addTask(task);
            return new BuilderCompleteTask(task);
        }

        public BuilderCompleteTask migrateClobToText(String theVersion, String theFromColumName, String theToColumName) {
            MigrateColumnClobTypeToTextTypeTask task = new MigrateColumnClobTypeToTextTypeTask(this.myRelease, theVersion, this.getTableName(), theFromColumName, theToColumName);
            this.addTask(task);
            return new BuilderCompleteTask(task);
        }

        public void dropPrimaryKey(String theVersion) {
            DropPrimaryKeyTask task = new DropPrimaryKeyTask(this.myRelease, theVersion, this.myTableName);
            this.addTask(task);
        }

        public class BuilderAddIndexWithName {
            private final String myVersion;
            private final String myIndexName;

            public BuilderAddIndexWithName(String theVersion, String theIndexName) {
                this.myVersion = theVersion;
                this.myIndexName = theIndexName;
            }

            public BuilderAddIndexUnique unique(boolean theUnique) {
                return new BuilderAddIndexUnique(this.myVersion, theUnique);
            }

            public class BuilderAddIndexUnique {
                private final String myVersion;
                private final boolean myUnique;
                private String[] myIncludeColumns;
                private boolean myOnline = true;

                public BuilderAddIndexUnique(String theVersion, boolean theUnique) {
                    this.myVersion = theVersion;
                    this.myUnique = theUnique;
                }

                public void withColumnsStub(String ... theColumnNames) {
                    BuilderCompleteTask task = this.withColumns(theColumnNames);
                    task.withFlag(TaskFlagEnum.DO_NOTHING);
                }

                public BuilderCompleteTask withColumns(String ... theColumnNames) {
                    AddIndexTask task = new AddIndexTask(BuilderWithTableName.this.myRelease, this.myVersion);
                    task.setTableName(BuilderWithTableName.this.myTableName);
                    task.setIndexName(BuilderAddIndexWithName.this.myIndexName);
                    task.setUnique(this.myUnique);
                    task.setColumns(theColumnNames);
                    task.setOnline(this.myOnline);
                    if (this.myIncludeColumns != null) {
                        task.setIncludeColumns(this.myIncludeColumns);
                    }
                    BuilderWithTableName.this.addTask(task);
                    return new BuilderCompleteTask(task);
                }

                public BuilderCompleteTask withPossibleNullableColumns(ColumnAndNullable ... theColumns) {
                    String[] columnNames = (String[])Arrays.stream(theColumns).map(ColumnAndNullable::getColumnName).toArray(String[]::new);
                    String[] nullableColumnNames = (String[])Arrays.stream(theColumns).filter(ColumnAndNullable::isNullable).map(ColumnAndNullable::getColumnName).toArray(String[]::new);
                    AddIndexTask task = new AddIndexTask(BuilderWithTableName.this.myRelease, this.myVersion);
                    task.setTableName(BuilderWithTableName.this.myTableName);
                    task.setIndexName(BuilderAddIndexWithName.this.myIndexName);
                    task.setUnique(this.myUnique);
                    task.setColumns(columnNames);
                    task.setNullableColumns(nullableColumnNames);
                    task.setOnline(this.myOnline);
                    if (this.myIncludeColumns != null) {
                        task.setIncludeColumns(this.myIncludeColumns);
                    }
                    BuilderWithTableName.this.addTask(task);
                    return new BuilderCompleteTask(task);
                }

                public BuilderAddIndexUnique includeColumns(String ... theIncludeColumns) {
                    this.myIncludeColumns = theIncludeColumns;
                    return this;
                }

                public BuilderAddIndexUnique online(boolean theOnlineFlag) {
                    this.myOnline = theOnlineFlag;
                    return this;
                }
            }
        }

        public static class BuilderAddColumnWithName {
            private final String myRelease;
            private final String myVersion;
            private final String myColumnName;
            @Nullable
            private final Object myDefaultValue;
            private final BaseMigrationTasks.IAcceptsTasks myTaskSink;

            public BuilderAddColumnWithName(String theRelease, String theVersion, String theColumnName, @Nullable Object theDefaultValue, BaseMigrationTasks.IAcceptsTasks theTaskSink) {
                this.myRelease = theRelease;
                this.myVersion = theVersion;
                this.myColumnName = theColumnName;
                this.myDefaultValue = theDefaultValue;
                this.myTaskSink = theTaskSink;
            }

            public BuilderAddColumnWithNameNullable nullable() {
                return new BuilderAddColumnWithNameNullable(this.myRelease, this.myVersion, true);
            }

            public BuilderAddColumnWithNameNullable nonNullable() {
                return new BuilderAddColumnWithNameNullable(this.myRelease, this.myVersion, false);
            }

            public class BuilderAddColumnWithNameNullable {
                private final boolean myNullable;
                private final String myRelease;
                private final String myVersion;

                public BuilderAddColumnWithNameNullable(String theRelease, String theVersion, boolean theNullable) {
                    this.myRelease = theRelease;
                    this.myVersion = theVersion;
                    this.myNullable = theNullable;
                }

                public BuilderCompleteTask type(ColumnTypeEnum theColumnType) {
                    return this.type(theColumnType, null);
                }

                public BuilderCompleteTask type(ColumnTypeEnum theColumnType, Integer theLength) {
                    AddColumnTask task = new AddColumnTask(this.myRelease, this.myVersion);
                    task.setColumnName(BuilderAddColumnWithName.this.myColumnName);
                    task.setNullable(this.myNullable);
                    task.setColumnType(theColumnType);
                    if (theLength != null) {
                        task.setColumnLength(theLength.intValue());
                    }
                    task.setDefaultValue(BuilderAddColumnWithName.this.myDefaultValue);
                    BuilderAddColumnWithName.this.myTaskSink.addTask(task);
                    return new BuilderCompleteTask(task);
                }
            }
        }

        public class BuilderModifyColumnWithName {
            private final String myVersion;
            private final String myColumnName;

            public BuilderModifyColumnWithName(String theVersion, String theColumnName) {
                this.myVersion = theVersion;
                this.myColumnName = theColumnName;
            }

            public String getColumnName() {
                return this.myColumnName;
            }

            public BuilderModifyColumnWithNameAndNullable nullable() {
                return new BuilderModifyColumnWithNameAndNullable(this.myVersion, true);
            }

            public BuilderModifyColumnWithNameAndNullable nonNullable() {
                return new BuilderModifyColumnWithNameAndNullable(this.myVersion, false);
            }

            public class BuilderModifyColumnWithNameAndNullable {
                private final String myVersion;
                private final boolean myNullable;

                public BuilderModifyColumnWithNameAndNullable(String theVersion, boolean theNullable) {
                    this.myVersion = theVersion;
                    this.myNullable = theNullable;
                }

                public BuilderCompleteTask withType(ColumnTypeEnum theColumnType) {
                    return this.withType(theColumnType, null);
                }

                public BuilderCompleteTask withType(ColumnTypeEnum theColumnType, Integer theLength) {
                    if (theColumnType == ColumnTypeEnum.STRING) {
                        if (theLength == null || theLength == 0) {
                            throw new IllegalArgumentException(Msg.code((int)52) + "Can not specify length 0 for column of type " + String.valueOf((Object)theColumnType));
                        }
                    } else if (theLength != null) {
                        throw new IllegalArgumentException(Msg.code((int)53) + "Can not specify length for column of type " + String.valueOf((Object)theColumnType));
                    }
                    ModifyColumnTask task = new ModifyColumnTask(BuilderWithTableName.this.myRelease, this.myVersion);
                    task.setColumnName(BuilderModifyColumnWithName.this.myColumnName);
                    task.setTableName(BuilderWithTableName.this.myTableName);
                    if (theLength != null) {
                        task.setColumnLength(theLength.intValue());
                    }
                    task.setNullable(this.myNullable);
                    task.setColumnType(theColumnType);
                    BuilderWithTableName.this.addTask(task);
                    return new BuilderCompleteTask(task);
                }
            }
        }

        public class BuilderAddForeignKey {
            private final String myVersion;
            private final String myForeignKeyName;

            public BuilderAddForeignKey(String theVersion, String theForeignKeyName) {
                this.myVersion = theVersion;
                this.myForeignKeyName = theForeignKeyName;
            }

            public BuilderAddForeignKeyToColumn toColumn(String theColumnName) {
                return new BuilderAddForeignKeyToColumn(this.myVersion, theColumnName);
            }

            public class BuilderAddForeignKeyToColumn
            extends BuilderModifyColumnWithName {
                public BuilderAddForeignKeyToColumn(String theVersion, String theColumnName) {
                    super(theVersion, theColumnName);
                }

                public BuilderCompleteTask references(String theForeignTable, String theForeignColumn) {
                    AddForeignKeyTask task = new AddForeignKeyTask(BuilderWithTableName.this.myRelease, BuilderAddForeignKey.this.myVersion);
                    task.setTableName(BuilderWithTableName.this.myTableName);
                    task.setConstraintName(BuilderAddForeignKey.this.myForeignKeyName);
                    task.setColumnName(this.getColumnName());
                    task.setForeignTableName(theForeignTable);
                    task.setForeignColumnName(theForeignColumn);
                    BuilderWithTableName.this.addTask(task);
                    return new BuilderCompleteTask(task);
                }
            }
        }
    }

    public class BuilderAddTableRawSql {
        private final AddTableRawSqlTask myTask;

        protected BuilderAddTableRawSql(String theVersion, String theTableName) {
            this.myTask = new AddTableRawSqlTask(Builder.this.myRelease, theVersion);
            this.myTask.setTableName(theTableName);
            Builder.this.addTask(this.myTask);
        }

        public BuilderAddTableRawSql addSql(DriverTypeEnum theDriverTypeEnum, @Language(value="SQL") String theSql) {
            this.myTask.addSql(theDriverTypeEnum, theSql);
            return this;
        }

        public void addSql(@Language(value="SQL") String theSql) {
            this.myTask.addSql(theSql);
        }
    }

    public static class BuilderCompleteTask {
        private final BaseTask myTask;

        public BuilderCompleteTask(BaseTask theTask) {
            this.myTask = theTask;
        }

        public BuilderCompleteTask failureAllowed() {
            this.myTask.addFlag(TaskFlagEnum.FAILURE_ALLOWED);
            return this;
        }

        public BuilderCompleteTask doNothing() {
            this.myTask.addFlag(TaskFlagEnum.DO_NOTHING);
            return this;
        }

        public BuilderCompleteTask onlyAppliesToPlatforms(DriverTypeEnum ... theTypes) {
            Set<DriverTypeEnum> typesSet = Arrays.stream(theTypes).collect(Collectors.toSet());
            this.myTask.setOnlyAppliesToPlatforms(typesSet);
            return this;
        }

        public BuilderCompleteTask onlyIf(@Language(value="SQL") String theSql, String reason) {
            if (!theSql.toUpperCase().startsWith("WITH") && !theSql.toUpperCase().startsWith("SELECT")) {
                throw new IllegalArgumentException(Msg.code((int)2455) + String.format("Only SELECT statements (including CTEs) are allowed here.  Please check your SQL: [%s]", theSql));
            }
            ourLog.debug("SQL to evaluate: {}", (Object)theSql);
            this.myTask.addPrecondition(new ExecuteTaskPrecondition(() -> {
                ourLog.debug("Checking precondition for SQL: {}", (Object)theSql);
                return MigrationJdbcUtils.queryForSingleBooleanResultMultipleThrowsException(theSql, this.myTask.newJdbcTemplate());
            }, reason));
            return this;
        }

        public BuilderCompleteTask runEvenDuringSchemaInitialization() {
            this.myTask.addFlag(TaskFlagEnum.RUN_DURING_SCHEMA_INITIALIZATION);
            return this;
        }

        public BuilderCompleteTask setTransactional(boolean theFlag) {
            this.myTask.setTransactional(theFlag);
            return this;
        }

        public BuilderCompleteTask heavyweightSkipByDefault() {
            this.myTask.addFlag(TaskFlagEnum.HEAVYWEIGHT_SKIP_BY_DEFAULT);
            return this;
        }

        public BuilderCompleteTask withFlag(TaskFlagEnum theFlag) {
            this.myTask.addFlag(theFlag);
            return this;
        }
    }

    public class BuilderAddTableByColumns
    extends BuilderWithTableName
    implements BaseMigrationTasks.IAcceptsTasks {
        private final String myVersion;
        private final AddTableByColumnTask myTask;

        public BuilderAddTableByColumns(String theRelease, String theVersion, BaseMigrationTasks.IAcceptsTasks theSink, String theTableName, List<String> thePkColumnNames) {
            super(theRelease, theSink, theTableName);
            this.myVersion = theVersion;
            this.myTask = new AddTableByColumnTask(Builder.this.myRelease, theVersion);
            this.myTask.setTableName(theTableName);
            this.myTask.setPkColumns(thePkColumnNames);
            theSink.addTask(this.myTask);
        }

        public BuilderWithTableName.BuilderAddColumnWithName addColumn(String theColumnName) {
            return new BuilderWithTableName.BuilderAddColumnWithName(Builder.this.myRelease, this.myVersion, theColumnName, null, this);
        }

        @Override
        public void addTask(BaseTask theTask) {
            if (theTask instanceof AddColumnTask) {
                this.myTask.addAddColumnTask((AddColumnTask)theTask);
            } else {
                super.addTask(theTask);
            }
        }

        public BuilderCompleteTask withFlags() {
            return new BuilderCompleteTask(this.myTask);
        }
    }
}

