/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTask;
import java.sql.SQLException;

public class MigrateColumnClobTypeToTextTypeTask
extends BaseTableColumnTask {
    private final String myFromColumName;
    private final String myToColumName;

    public MigrateColumnClobTypeToTextTypeTask(String theProductVersion, String theSchemaVersion, String theTableName, String theFromColumName, String theToColumName) {
        super(theProductVersion, theSchemaVersion);
        this.myFromColumName = theFromColumName;
        this.myToColumName = theToColumName;
        this.setTableName(theTableName);
    }

    @Override
    public void validate() {
        this.setDescription("Migrating CLob (oid) from colum  " + this.myFromColumName + " to " + this.myToColumName + ".TEXT for table " + this.getTableName() + " (only affects Postgresql)");
    }

    @Override
    protected void doExecute() throws SQLException {
        String sql = this.buildSqlStatement();
        this.executeSql(this.getTableName(), sql, new Object[0]);
    }

    String buildSqlStatement() {
        String retVal;
        String tableName = this.getTableName().toLowerCase();
        String fromColumName = this.myFromColumName.toLowerCase();
        String toColumName = this.myToColumName.toLowerCase();
        switch (this.getDriverType()) {
            case MYSQL_5_7: 
            case DERBY_EMBEDDED: 
            case ORACLE_12C: 
            case MARIADB_10_1: 
            case COCKROACHDB_21_1: 
            case H2_EMBEDDED: 
            case MSSQL_2012: {
                retVal = "update " + tableName + " set " + toColumName + " = " + fromColumName + " where " + fromColumName + " is not null";
                break;
            }
            case POSTGRES_9_4: {
                retVal = "update " + tableName + " set " + toColumName + " = convert_from(lo_get(" + fromColumName + "), 'UTF8') where " + fromColumName + " is not null";
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)2515));
            }
        }
        return retVal;
    }
}

