/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.sql.SQLException;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropPrimaryKeyTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(DropPrimaryKeyTask.class);

    public DropPrimaryKeyTask(String theProductVersion, String theSchemaVersion, String theTableName) {
        super(theProductVersion, theSchemaVersion);
        this.setTableName(theTableName);
    }

    @Nonnull
    private String generateSql() {
        ourLog.debug("DropPrimaryKeyTask.generateSql()");
        String primaryKeyNameSql = this.generatePrimaryKeyNameSql();
        String primaryKeyName = primaryKeyNameSql != null ? (String)this.newJdbcTemplate().queryForObject(primaryKeyNameSql, String.class, new Object[]{this.getTableNameWithDatabaseExpectedCase()}) : null;
        ourLog.debug("primaryKeyName: {} for driver: {}", primaryKeyName, (Object)this.getDriverType());
        return this.generateDropPrimaryKeySql(primaryKeyName);
    }

    private String getTableNameWithDatabaseExpectedCase() {
        if (DriverTypeEnum.ORACLE_12C == this.getDriverType()) {
            return this.getTableName().toUpperCase();
        }
        return this.getTableName().toLowerCase();
    }

    @Override
    protected void doExecute() throws SQLException {
        this.logInfo(ourLog, "Going to DROP the PRIMARY KEY on table {}", this.getTableName());
        this.executeSql(this.getTableName(), this.generateSql(), new Object[0]);
    }

    private String generateDropPrimaryKeySql(@Nullable String thePrimaryKeyName) {
        switch (this.getDriverType()) {
            case MARIADB_10_1: 
            case DERBY_EMBEDDED: 
            case H2_EMBEDDED: {
                String sqlH2 = "ALTER TABLE %s DROP PRIMARY KEY";
                return String.format("ALTER TABLE %s DROP PRIMARY KEY", this.getTableName());
            }
            case POSTGRES_9_4: 
            case ORACLE_12C: 
            case MSSQL_2012: 
            case MYSQL_5_7: {
                assert (thePrimaryKeyName != null);
                String sql = "ALTER TABLE %s DROP CONSTRAINT %s";
                return String.format("ALTER TABLE %s DROP CONSTRAINT %s", this.getTableName(), thePrimaryKeyName);
            }
        }
        throw new IllegalStateException(String.format("%s Unknown driver type: %s.  Cannot drop primary key: %s for task %s", new Object[]{Msg.code((int)2529), this.getDriverType(), this.getMigrationVersion(), this.getTableName()}));
    }

    @Nullable
    @Language(value="SQL")
    private String generatePrimaryKeyNameSql() {
        switch (this.getDriverType()) {
            case MARIADB_10_1: 
            case DERBY_EMBEDDED: 
            case H2_EMBEDDED: 
            case MYSQL_5_7: 
            case COCKROACHDB_21_1: {
                return null;
            }
            case POSTGRES_9_4: {
                return "SELECT constraint_name FROM information_schema.table_constraints WHERE table_schema = coalesce(current_schema(), 'public') AND constraint_type = 'PRIMARY KEY' AND table_name = ?";
            }
            case ORACLE_12C: {
                return "SELECT constraint_name FROM user_constraints WHERE constraint_type = 'P' AND table_name = ?";
            }
            case MSSQL_2012: {
                return "SELECT tc.constraint_name FROM information_schema.table_constraints tc JOIN information_schema.constraint_column_usage ccu ON tc.constraint_name = ccu.constraint_name WHERE tc.constraint_type = 'PRIMARY KEY' AND  tc.table_name = ?";
            }
        }
        throw new IllegalStateException(String.format("%s Unknown driver type: %s  Cannot find primary key to drop for task %s", new Object[]{Msg.code((int)2530), this.getDriverType(), this.getMigrationVersion()}));
    }
}

