/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import java.util.HashMap;
import java.util.Map;

public final class ColumnTypeToDriverTypeToSqlType {
    static Map<ColumnTypeEnum, Map<DriverTypeEnum, String>> myColumnTypeToDriverTypeToSqlType = new HashMap<ColumnTypeEnum, Map<DriverTypeEnum, String>>();

    private ColumnTypeToDriverTypeToSqlType() {
    }

    public static Map<ColumnTypeEnum, Map<DriverTypeEnum, String>> getColumnTypeToDriverTypeToSqlType() {
        return myColumnTypeToDriverTypeToSqlType;
    }

    private static void setColumnType(ColumnTypeEnum theColumnType, DriverTypeEnum theDriverType, String theColumnTypeSql) {
        Map columnSqlType = myColumnTypeToDriverTypeToSqlType.computeIfAbsent(theColumnType, k -> new HashMap());
        if (columnSqlType.containsKey((Object)theDriverType)) {
            throw new IllegalStateException(Msg.code((int)65) + "Duplicate key: " + String.valueOf((Object)theDriverType));
        }
        columnSqlType.put(theDriverType, theColumnTypeSql);
    }

    public static String toBooleanValue(DriverTypeEnum theDriverType, Boolean theBoolean) {
        switch (theDriverType) {
            case H2_EMBEDDED: 
            case DERBY_EMBEDDED: 
            case POSTGRES_9_4: {
                return theBoolean.toString();
            }
        }
        return theBoolean != false ? "1" : "0";
    }

    static {
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.INT, DriverTypeEnum.H2_EMBEDDED, "integer");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.INT, DriverTypeEnum.DERBY_EMBEDDED, "integer");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.INT, DriverTypeEnum.MARIADB_10_1, "integer");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.INT, DriverTypeEnum.MYSQL_5_7, "integer");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.INT, DriverTypeEnum.MSSQL_2012, "int");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.INT, DriverTypeEnum.ORACLE_12C, "number(10,0)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.INT, DriverTypeEnum.POSTGRES_9_4, "int4");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TINYINT, DriverTypeEnum.H2_EMBEDDED, "tinyint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TINYINT, DriverTypeEnum.DERBY_EMBEDDED, "smallint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TINYINT, DriverTypeEnum.MARIADB_10_1, "tinyint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TINYINT, DriverTypeEnum.MYSQL_5_7, "tinyint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TINYINT, DriverTypeEnum.MSSQL_2012, "smallint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TINYINT, DriverTypeEnum.ORACLE_12C, "number(3,0)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TINYINT, DriverTypeEnum.POSTGRES_9_4, "int2");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.FLOAT, DriverTypeEnum.H2_EMBEDDED, "float");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.FLOAT, DriverTypeEnum.DERBY_EMBEDDED, "float");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.FLOAT, DriverTypeEnum.MARIADB_10_1, "float");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.FLOAT, DriverTypeEnum.MYSQL_5_7, "float");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.FLOAT, DriverTypeEnum.MSSQL_2012, "float");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.FLOAT, DriverTypeEnum.ORACLE_12C, "float");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.FLOAT, DriverTypeEnum.POSTGRES_9_4, "float");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DOUBLE, DriverTypeEnum.H2_EMBEDDED, "double");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DOUBLE, DriverTypeEnum.DERBY_EMBEDDED, "double");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DOUBLE, DriverTypeEnum.MARIADB_10_1, "double precision");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DOUBLE, DriverTypeEnum.MYSQL_5_7, "double precision");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DOUBLE, DriverTypeEnum.MSSQL_2012, "double precision");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DOUBLE, DriverTypeEnum.ORACLE_12C, "double precision");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DOUBLE, DriverTypeEnum.POSTGRES_9_4, "double precision");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.LONG, DriverTypeEnum.H2_EMBEDDED, "bigint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.LONG, DriverTypeEnum.DERBY_EMBEDDED, "bigint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.LONG, DriverTypeEnum.MARIADB_10_1, "bigint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.LONG, DriverTypeEnum.MYSQL_5_7, "bigint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.LONG, DriverTypeEnum.MSSQL_2012, "bigint");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.LONG, DriverTypeEnum.ORACLE_12C, "number(19,0)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.LONG, DriverTypeEnum.POSTGRES_9_4, "int8");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.STRING, DriverTypeEnum.H2_EMBEDDED, "varchar(?)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.STRING, DriverTypeEnum.DERBY_EMBEDDED, "varchar(?)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.STRING, DriverTypeEnum.MARIADB_10_1, "varchar(?)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.STRING, DriverTypeEnum.MYSQL_5_7, "varchar(?)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.STRING, DriverTypeEnum.MSSQL_2012, "varchar(?)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.STRING, DriverTypeEnum.ORACLE_12C, "varchar2(?)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.STRING, DriverTypeEnum.POSTGRES_9_4, "varchar(?)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_TIMESTAMP, DriverTypeEnum.H2_EMBEDDED, "timestamp");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_TIMESTAMP, DriverTypeEnum.DERBY_EMBEDDED, "timestamp");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_TIMESTAMP, DriverTypeEnum.MARIADB_10_1, "datetime(6)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_TIMESTAMP, DriverTypeEnum.MYSQL_5_7, "datetime(6)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_TIMESTAMP, DriverTypeEnum.MSSQL_2012, "datetime2");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_TIMESTAMP, DriverTypeEnum.ORACLE_12C, "timestamp");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_TIMESTAMP, DriverTypeEnum.POSTGRES_9_4, "timestamp");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_ONLY, DriverTypeEnum.H2_EMBEDDED, "date");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_ONLY, DriverTypeEnum.DERBY_EMBEDDED, "date");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_ONLY, DriverTypeEnum.MARIADB_10_1, "date");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_ONLY, DriverTypeEnum.MYSQL_5_7, "date");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_ONLY, DriverTypeEnum.MSSQL_2012, "date");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_ONLY, DriverTypeEnum.ORACLE_12C, "date");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.DATE_ONLY, DriverTypeEnum.POSTGRES_9_4, "date");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BOOLEAN, DriverTypeEnum.H2_EMBEDDED, "boolean");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BOOLEAN, DriverTypeEnum.DERBY_EMBEDDED, "boolean");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BOOLEAN, DriverTypeEnum.MSSQL_2012, "bit");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BOOLEAN, DriverTypeEnum.MARIADB_10_1, "bit");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BOOLEAN, DriverTypeEnum.ORACLE_12C, "number(1,0)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BOOLEAN, DriverTypeEnum.POSTGRES_9_4, "boolean");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BOOLEAN, DriverTypeEnum.MYSQL_5_7, "bit");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BLOB, DriverTypeEnum.H2_EMBEDDED, "blob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BLOB, DriverTypeEnum.DERBY_EMBEDDED, "blob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BLOB, DriverTypeEnum.MARIADB_10_1, "longblob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BLOB, DriverTypeEnum.MYSQL_5_7, "longblob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BLOB, DriverTypeEnum.ORACLE_12C, "blob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BLOB, DriverTypeEnum.POSTGRES_9_4, "oid");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BLOB, DriverTypeEnum.MSSQL_2012, "varbinary(MAX)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.CLOB, DriverTypeEnum.H2_EMBEDDED, "clob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.CLOB, DriverTypeEnum.DERBY_EMBEDDED, "clob(100000)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.CLOB, DriverTypeEnum.MARIADB_10_1, "longtext");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.CLOB, DriverTypeEnum.MYSQL_5_7, "longtext");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.CLOB, DriverTypeEnum.ORACLE_12C, "clob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.CLOB, DriverTypeEnum.POSTGRES_9_4, "oid");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.CLOB, DriverTypeEnum.MSSQL_2012, "varchar(MAX)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TEXT, DriverTypeEnum.H2_EMBEDDED, "clob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TEXT, DriverTypeEnum.DERBY_EMBEDDED, "clob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TEXT, DriverTypeEnum.MARIADB_10_1, "longtext");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TEXT, DriverTypeEnum.MYSQL_5_7, "longtext");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TEXT, DriverTypeEnum.ORACLE_12C, "clob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TEXT, DriverTypeEnum.POSTGRES_9_4, "text");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.TEXT, DriverTypeEnum.MSSQL_2012, "varchar(MAX)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BINARY, DriverTypeEnum.H2_EMBEDDED, "blob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BINARY, DriverTypeEnum.DERBY_EMBEDDED, "blob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BINARY, DriverTypeEnum.MARIADB_10_1, "longblob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BINARY, DriverTypeEnum.MYSQL_5_7, "longblob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BINARY, DriverTypeEnum.ORACLE_12C, "blob");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BINARY, DriverTypeEnum.POSTGRES_9_4, "bytea");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BINARY, DriverTypeEnum.MSSQL_2012, "varbinary(MAX)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BIG_DECIMAL, DriverTypeEnum.H2_EMBEDDED, "numeric(38,2)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BIG_DECIMAL, DriverTypeEnum.DERBY_EMBEDDED, "decimal(31,2)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BIG_DECIMAL, DriverTypeEnum.MARIADB_10_1, "decimal(38,2)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BIG_DECIMAL, DriverTypeEnum.MYSQL_5_7, "decimal(38,2)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BIG_DECIMAL, DriverTypeEnum.ORACLE_12C, "number(38,2)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BIG_DECIMAL, DriverTypeEnum.POSTGRES_9_4, "numeric(38,2)");
        ColumnTypeToDriverTypeToSqlType.setColumnType(ColumnTypeEnum.BIG_DECIMAL, DriverTypeEnum.MSSQL_2012, "numeric(38,2)");
    }
}

