/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IBaseInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.executor.BaseInterceptorService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class CompositeInterceptorBroadcaster
implements IInterceptorBroadcaster {
    private final List<IInterceptorBroadcaster> myServices;

    private CompositeInterceptorBroadcaster(Collection<IInterceptorBroadcaster> theServices) {
        this.myServices = theServices.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean callHooks(Pointcut thePointcut, HookParams theParams) {
        assert (BaseInterceptorService.haveAppropriateParams((IPointcut)thePointcut, (HookParams)theParams));
        assert (thePointcut.getReturnType() == Void.TYPE || thePointcut.getReturnType() == thePointcut.getBooleanReturnTypeForEnum());
        List<IBaseInterceptorBroadcaster.IInvoker> invokers = this.getInvokersForPointcut(thePointcut);
        Object retVal = BaseInterceptorService.callInvokers((IPointcut)thePointcut, (HookParams)theParams, invokers);
        retVal = ObjectUtils.getIfNull((Object)retVal, (Object)true);
        return (Boolean)retVal;
    }

    public Object callHooksAndReturnObject(Pointcut thePointcut, HookParams theParams) {
        assert (BaseInterceptorService.haveAppropriateParams((IPointcut)thePointcut, (HookParams)theParams));
        assert (thePointcut.getReturnType() != Void.TYPE);
        List<IBaseInterceptorBroadcaster.IInvoker> invokers = this.getInvokersForPointcut(thePointcut);
        return BaseInterceptorService.callInvokers((IPointcut)thePointcut, (HookParams)theParams, invokers);
    }

    @Nonnull
    public List<IBaseInterceptorBroadcaster.IInvoker> getInvokersForPointcut(Pointcut thePointcut) {
        ArrayList<IBaseInterceptorBroadcaster.IInvoker> invokers = new ArrayList<IBaseInterceptorBroadcaster.IInvoker>();
        for (IInterceptorBroadcaster services : this.myServices) {
            if (!services.hasHooks((IPointcut)thePointcut)) continue;
            List serviceInvokers = services.getInvokersForPointcut((IPointcut)thePointcut);
            assert (serviceInvokers != null);
            invokers.addAll(serviceInvokers);
        }
        invokers.sort(Comparator.naturalOrder());
        return invokers;
    }

    public boolean hasHooks(Pointcut thePointcut) {
        for (IInterceptorBroadcaster service : this.myServices) {
            if (!service.hasHooks((IPointcut)thePointcut)) continue;
            return true;
        }
        return false;
    }

    public static IInterceptorBroadcaster newCompositeBroadcaster(IInterceptorBroadcaster ... theServices) {
        return new CompositeInterceptorBroadcaster(Arrays.asList(theServices));
    }

    public static IInterceptorBroadcaster newCompositeBroadcaster(@Nonnull IInterceptorBroadcaster theInterceptorBroadcaster, @Nullable RequestDetails theRequestDetails) {
        IInterceptorBroadcaster requestBroadcaster;
        assert (theInterceptorBroadcaster != null);
        if (theRequestDetails != null && (requestBroadcaster = theRequestDetails.getInterceptorBroadcaster()) != null) {
            return CompositeInterceptorBroadcaster.newCompositeBroadcaster(theInterceptorBroadcaster, requestBroadcaster);
        }
        return CompositeInterceptorBroadcaster.newCompositeBroadcaster(theInterceptorBroadcaster);
    }
}

