/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.method.RequestedPage;
import ca.uhn.fhir.rest.server.method.ResponseBundleRequest;
import ca.uhn.fhir.rest.server.method.ResponsePage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseBundleBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(ResponseBundleBuilder.class);
    private final boolean myIsOffsetModeHistory;

    public ResponseBundleBuilder(boolean theIsOffsetModeHistory) {
        this.myIsOffsetModeHistory = theIsOffsetModeHistory;
    }

    IBaseBundle buildResponseBundle(ResponseBundleRequest theResponseBundleRequest) {
        ResponsePage responsePage = this.buildResponsePage(theResponseBundleRequest);
        ResponseBundleBuilder.removeNulls(responsePage.getResourceList());
        ResponseBundleBuilder.validateIds(responsePage.getResourceList());
        BundleLinks links = this.buildLinks(theResponseBundleRequest, responsePage);
        return ResponseBundleBuilder.buildBundle(theResponseBundleRequest, responsePage, links);
    }

    private static IBaseBundle buildBundle(ResponseBundleRequest theResponseBundleRequest, ResponsePage pageResponse, BundleLinks links) {
        IRestfulServer<?> server = theResponseBundleRequest.server;
        FhirContext ctx = server.getFhirContext();
        IVersionSpecificBundleFactory bundleFactory = ctx.newBundleFactory();
        IBundleProvider bundleProvider = theResponseBundleRequest.bundleProvider;
        bundleFactory.addRootPropertiesToBundle(bundleProvider.getUuid(), links, bundleProvider.size(), bundleProvider.getPublished());
        bundleFactory.addResourcesToBundle(new ArrayList<IBaseResource>(pageResponse.getResourceList()), theResponseBundleRequest.bundleType, links.serverBase, server.getBundleInclusionRule(), theResponseBundleRequest.includes);
        IBaseBundle baseBundle = (IBaseBundle)bundleFactory.getResourceBundle();
        return baseBundle;
    }

    private ResponsePage buildResponsePage(ResponseBundleRequest theResponseBundleRequest) {
        List<IBaseResource> resourceList;
        int numToReturn;
        int pageSize;
        Integer bundleSize;
        IRestfulServer<?> server = theResponseBundleRequest.server;
        IBundleProvider bundleProvider = theResponseBundleRequest.bundleProvider;
        RequestedPage requestedPage = theResponseBundleRequest.requestedPage;
        ResponsePage.ResponsePageBuilder responsePageBuilder = new ResponsePage.ResponsePageBuilder();
        String searchId = null;
        Integer n = bundleSize = bundleProvider.containsAllResources() ? Integer.valueOf(bundleProvider.getResourceListComplete().size()) : bundleProvider.size();
        if (requestedPage.offset != null || !server.canStoreSearchResults()) {
            numToReturn = pageSize = ResponseBundleBuilder.offsetCalculatePageSize(server, requestedPage, bundleSize);
            resourceList = this.offsetBuildResourceList(bundleProvider, requestedPage, numToReturn, responsePageBuilder);
            RestfulServerUtils.validateResourceListNotNull(resourceList);
        } else {
            pageSize = ResponseBundleBuilder.pagingCalculatePageSize(requestedPage, server.getPagingProvider());
            numToReturn = bundleSize == null ? pageSize : Math.min(pageSize, bundleSize - theResponseBundleRequest.offset);
            resourceList = ResponseBundleBuilder.pagingBuildResourceList(theResponseBundleRequest, bundleProvider, numToReturn, responsePageBuilder);
            RestfulServerUtils.validateResourceListNotNull(resourceList);
            searchId = ResponseBundleBuilder.pagingBuildSearchId(theResponseBundleRequest, numToReturn, bundleProvider.size());
        }
        responsePageBuilder.setSearchId(searchId).setPageSize(pageSize).setNumToReturn(numToReturn).setBundleProvider(bundleProvider).setResources(resourceList);
        return responsePageBuilder.build();
    }

    private static String pagingBuildSearchId(ResponseBundleRequest theResponseBundleRequest, int theNumToReturn, Integer theNumTotalResults) {
        IPagingProvider pagingProvider = theResponseBundleRequest.server.getPagingProvider();
        String retval = null;
        if (theResponseBundleRequest.searchId != null) {
            retval = theResponseBundleRequest.searchId;
        } else if ((theNumTotalResults == null || theNumTotalResults > theNumToReturn) && StringUtils.isBlank((CharSequence)(retval = pagingProvider.storeResultList(theResponseBundleRequest.requestDetails, theResponseBundleRequest.bundleProvider)))) {
            ourLog.info("Found {} results but paging provider did not provide an ID to use for paging", (Object)theNumTotalResults);
            retval = null;
        }
        return retval;
    }

    private static List<IBaseResource> pagingBuildResourceList(ResponseBundleRequest theResponseBundleRequest, IBundleProvider theBundleProvider, int theNumToReturn, ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
        List<IBaseResource> retval = theNumToReturn > 0 || theBundleProvider.getCurrentPageId() != null ? theBundleProvider.getResources(theResponseBundleRequest.offset, theNumToReturn + theResponseBundleRequest.offset, theResponsePageBuilder) : Collections.emptyList();
        return retval;
    }

    private static int pagingCalculatePageSize(RequestedPage theRequestedPage, IPagingProvider thePagingProvider) {
        if (theRequestedPage.limit == null || theRequestedPage.limit.equals(0)) {
            return thePagingProvider.getDefaultPageSize();
        }
        return Math.min(thePagingProvider.getMaximumPageSize(), theRequestedPage.limit);
    }

    private List<IBaseResource> offsetBuildResourceList(IBundleProvider theBundleProvider, RequestedPage theRequestedPage, int theNumToReturn, ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
        List<IBaseResource> retval = theRequestedPage.offset != null && !this.myIsOffsetModeHistory || theBundleProvider.getCurrentPageOffset() != null ? theBundleProvider.getResources(0, Integer.MAX_VALUE, theResponsePageBuilder) : (theNumToReturn > 0 ? theBundleProvider.getResources(0, theNumToReturn, theResponsePageBuilder) : Collections.emptyList());
        return retval;
    }

    private static int offsetCalculatePageSize(IRestfulServer<?> server, RequestedPage theRequestedPage, Integer theNumTotalResults) {
        int retval = theRequestedPage.limit != null ? theRequestedPage.limit : (server.getDefaultPageSize() != null ? server.getDefaultPageSize() : (theNumTotalResults != null ? theNumTotalResults : Integer.MAX_VALUE));
        return retval;
    }

    private static void validateIds(List<IBaseResource> theResourceList) {
        for (IBaseResource next : theResourceList) {
            if (next.getIdElement() != null && !next.getIdElement().isEmpty() || next instanceof IBaseOperationOutcome) continue;
            throw new InternalErrorException(Msg.code((int)435) + "Server method returned resource of type[" + next.getClass().getSimpleName() + "] with no ID specified (IResource#setId(IdDt) must be called)");
        }
    }

    private static void removeNulls(List<IBaseResource> resourceList) {
        boolean hasNull = false;
        for (IBaseResource next : resourceList) {
            if (next != null) continue;
            hasNull = true;
            break;
        }
        if (hasNull) {
            resourceList.removeIf(Objects::isNull);
        }
    }

    private BundleLinks buildLinks(ResponseBundleRequest theResponseBundleRequest, ResponsePage theResponsePage) {
        IRestfulServer<?> server = theResponseBundleRequest.server;
        RequestedPage pageRequest = theResponseBundleRequest.requestedPage;
        BundleLinks retval = new BundleLinks(theResponseBundleRequest.requestDetails.getFhirServerBase(), theResponseBundleRequest.includes, RestfulServerUtils.prettyPrintResponse(server, theResponseBundleRequest.requestDetails), theResponseBundleRequest.bundleType);
        retval.setSelf(theResponseBundleRequest.linkSelf);
        theResponsePage.setUseOffsetPaging(pageRequest.offset != null || !server.canStoreSearchResults() && !this.isEverythingOperation(theResponseBundleRequest.requestDetails) || this.myIsOffsetModeHistory);
        theResponsePage.setResponseBundleRequest(theResponseBundleRequest);
        theResponsePage.setRequestedPage(pageRequest);
        theResponsePage.setNextPageIfNecessary(retval);
        theResponsePage.setPreviousPageIfNecessary(retval);
        return retval;
    }

    private boolean isEverythingOperation(RequestDetails theRequest) {
        return (theRequest.getRestOperationType() == RestOperationTypeEnum.EXTENDED_OPERATION_TYPE || theRequest.getRestOperationType() == RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE) && theRequest.getOperation() != null && theRequest.getOperation().equals("$everything");
    }
}

