/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.annotation.GraphQLQueryBody;
import ca.uhn.fhir.rest.annotation.GraphQLQueryUrl;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class GraphQLMethodBinding
extends OperationMethodBinding {
    private final Integer myIdParamIndex;
    private final Integer myQueryUrlParamIndex;
    private final Integer myQueryBodyParamIndex;
    private final RequestTypeEnum myMethodRequestType;

    public GraphQLMethodBinding(Method theMethod, RequestTypeEnum theMethodRequestType, FhirContext theContext, Object theProvider) {
        super(null, null, theMethod, theContext, theProvider, true, false, "$graphql", null, null, null, null, true);
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)theContext);
        this.myQueryUrlParamIndex = ParameterUtil.findParamAnnotationIndex((Method)theMethod, GraphQLQueryUrl.class);
        this.myQueryBodyParamIndex = ParameterUtil.findParamAnnotationIndex((Method)theMethod, GraphQLQueryBody.class);
        this.myMethodRequestType = theMethodRequestType;
    }

    @Override
    public String getResourceName() {
        return null;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.GRAPHQL_REQUEST;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType(RequestDetails theRequestDetails) {
        return this.getRestOperationType();
    }

    @Override
    protected Set<Class<?>> provideExpectedReturnTypes() {
        return Collections.singleton(String.class);
    }

    @Override
    public boolean isCanOperateAtServerLevel() {
        return true;
    }

    @Override
    public boolean isCanOperateAtTypeLevel() {
        return false;
    }

    @Override
    public boolean isCanOperateAtInstanceLevel() {
        return this.myIdParamIndex != null;
    }

    @Override
    public MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if ("$graphql".equals(theRequest.getOperation()) && this.myMethodRequestType.equals((Object)theRequest.getRequestType())) {
            return MethodMatchEnum.EXACT;
        }
        return MethodMatchEnum.NONE;
    }

    private String getQueryValue(Object[] methodParams) {
        switch (this.myMethodRequestType) {
            case POST: {
                Validate.notNull((Object)this.myQueryBodyParamIndex, (String)("GraphQL method does not have @" + GraphQLQueryBody.class.getSimpleName() + " parameter"), (Object[])new Object[0]);
                return (String)methodParams[this.myQueryBodyParamIndex];
            }
            case GET: {
                Validate.notNull((Object)this.myQueryUrlParamIndex, (String)("GraphQL method does not have @" + GraphQLQueryUrl.class.getSimpleName() + " parameter"), (Object[])new Object[0]);
                return (String)methodParams[this.myQueryUrlParamIndex];
            }
        }
        return null;
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        Object[] methodParams = this.createMethodParams(theRequest);
        if (this.myIdParamIndex != null) {
            methodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        String responseString = (String)this.invokeServerMethod(theRequest, methodParams);
        int statusCode = 200;
        String statusMessage = (String)Constants.HTTP_STATUS_NAMES.get(statusCode);
        String contentType = "application/json";
        String charset = "UTF-8";
        boolean respondGzip = theRequest.isRespondGzip();
        HttpServletRequest servletRequest = null;
        HttpServletResponse servletResponse = null;
        if (theRequest instanceof ServletRequestDetails) {
            servletRequest = ((ServletRequestDetails)theRequest).getServletRequest();
            servletResponse = ((ServletRequestDetails)theRequest).getServletResponse();
        }
        String graphQLQuery = this.getQueryValue(methodParams);
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(String.class, (Object)graphQLQuery).add(String.class, (Object)responseString).add(HttpServletRequest.class, (Object)servletRequest).add(HttpServletResponse.class, (Object)servletResponse);
        if (!theRequest.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SERVER_OUTGOING_GRAPHQL_RESPONSE, params)) {
            return null;
        }
        ResponseDetails responseDetails = new ResponseDetails(statusCode, null);
        params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(IBaseResource.class, null).add(ResponseDetails.class, (Object)responseDetails).add(HttpServletRequest.class, (Object)servletRequest).add(HttpServletResponse.class, (Object)servletResponse);
        if (!theRequest.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SERVER_OUTGOING_RESPONSE, params)) {
            return null;
        }
        Writer writer = theRequest.getResponse().getResponseWriter(responseDetails.getResponseCode(), contentType, charset, respondGzip);
        writer.write(responseString);
        writer.close();
        return null;
    }
}

