/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging.json;

import ca.uhn.fhir.model.api.IModelJson;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.messaging.MessageHeaders;

public class HapiMessageHeaders
implements IModelJson {
    public static final String RETRY_COUNT_KEY = "retryCount";
    public static final String FIRST_FAILURE_KEY = "firstFailureTimestamp";
    public static final String LAST_FAILURE_KEY = "lastFailureTimestamp";
    @JsonProperty(value="retryCount")
    private Integer myRetryCount = 0;
    @JsonProperty(value="firstFailureTimestamp")
    private Long myFirstFailureTimestamp;
    @JsonProperty(value="lastFailureTimestamp")
    private Long myLastFailureTimestamp;
    @JsonProperty(value="customHeaders")
    private final Map<String, Object> headers;

    public HapiMessageHeaders(Map<String, Object> theHeaders) {
        this.headers = theHeaders;
    }

    public HapiMessageHeaders() {
        this.headers = new HashMap<String, Object>();
    }

    public Integer getRetryCount() {
        if (Objects.isNull(this.myRetryCount)) {
            return 0;
        }
        return this.myRetryCount;
    }

    public Long getFirstFailureTimestamp() {
        return this.myFirstFailureTimestamp;
    }

    public Long getLastFailureTimestamp() {
        return this.myLastFailureTimestamp;
    }

    public void setRetryCount(Integer theRetryCount) {
        this.myRetryCount = theRetryCount;
    }

    public void setLastFailureTimestamp(Long theLastFailureTimestamp) {
        this.myLastFailureTimestamp = theLastFailureTimestamp;
    }

    public void setFirstFailureTimestamp(Long theFirstFailureTimestamp) {
        this.myFirstFailureTimestamp = theFirstFailureTimestamp;
    }

    public Map<String, Object> getCustomHeaders() {
        if (this.headers == null) {
            return new HashMap<String, Object>();
        }
        return this.headers;
    }

    public MessageHeaders toMessageHeaders() {
        HashMap<String, Object> returnedHeaders = new HashMap<String, Object>(this.headers);
        if (this.myRetryCount != null) {
            returnedHeaders.put(RETRY_COUNT_KEY, this.myRetryCount);
        }
        if (this.myFirstFailureTimestamp != null) {
            returnedHeaders.put(FIRST_FAILURE_KEY, this.myFirstFailureTimestamp);
        }
        if (this.myLastFailureTimestamp != null) {
            returnedHeaders.put(LAST_FAILURE_KEY, this.myLastFailureTimestamp);
        }
        return new MessageHeaders(returnedHeaders);
    }

    public void addCustomHeader(String theKey, Object theValue) {
        this.getCustomHeaders().put(theKey, theValue);
    }
}

