/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging.json;

import ca.uhn.fhir.interceptor.model.IDefaultPartitionSettings;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.messaging.IHasPayloadMessageKey;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.rest.server.messaging.IMessageDeliveryContext;
import ca.uhn.fhir.rest.server.messaging.RequestPartitionHeaderUtil;
import ca.uhn.fhir.rest.server.messaging.json.HapiMessageHeaders;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public abstract class BaseJsonMessage<T>
implements IMessage<T>,
Message<T>,
IModelJson,
IMessageDeliveryContext {
    @JsonProperty(value="headers")
    private HapiMessageHeaders myHeaders;

    public BaseJsonMessage() {
        this.setDefaultRetryHeaders();
    }

    protected void setDefaultRetryHeaders() {
        HapiMessageHeaders messageHeaders = new HapiMessageHeaders();
        this.setHeaders(messageHeaders);
    }

    @Nonnull
    public MessageHeaders getHeaders() {
        return this.getHapiHeaders().toMessageHeaders();
    }

    public HapiMessageHeaders getHapiHeaders() {
        if (Objects.isNull(this.myHeaders)) {
            this.setDefaultRetryHeaders();
        }
        return this.myHeaders;
    }

    public void setHeaders(HapiMessageHeaders theHeaders) {
        this.myHeaders = theHeaders;
    }

    @Override
    @Nonnull
    public String getMessageKey() {
        String payloadMessageKey;
        Object payload = this.getPayload();
        if (payload instanceof IHasPayloadMessageKey && (payloadMessageKey = ((IHasPayloadMessageKey)payload).getPayloadMessageKey()) != null) {
            return payloadMessageKey;
        }
        return IMessage.super.getMessageKey();
    }

    @Override
    public int getRetryCount() {
        return this.getHapiHeaders().getRetryCount();
    }

    public T getPayloadWithRequestPartitionIdSetFromHeader(IDefaultPartitionSettings theDefaultPartitionSettings) {
        RequestPartitionHeaderUtil.setRequestPartitionIdFromHeaderIfNotAlreadySet(this, theDefaultPartitionSettings);
        return this.getPayload();
    }

    public static <P> void addCustomHeaders(IMessage<P> theMessage, Map<String, ?> theCustomHeaders) {
        if (theMessage instanceof BaseJsonMessage) {
            BaseJsonMessage baseJsonMessage = (BaseJsonMessage)theMessage;
            baseJsonMessage.getHapiHeaders().getCustomHeaders().putAll(theCustomHeaders);
        }
    }
}

