/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public interface IMessage<T> {
    @Nonnull
    default public String getMessageKey() {
        return UUID.randomUUID().toString();
    }

    @Nonnull
    public Map<String, Object> getHeaders();

    default public <H> Optional<H> getHeader(String theHeaderName) {
        return Optional.ofNullable(this.getHeaders().get(theHeaderName));
    }

    public T getPayload();

    default public Map<String, String> getHeadersAsStrings() {
        return IMessage.convertHeaderValuesToStrings(this.getHeaders());
    }

    public static Map<String, String> convertHeaderValuesToStrings(Map<String, Object> theHeaders) {
        return theHeaders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }
}

