/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.rest.server.interceptor.validation.ValidationMessagePostProcessingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.validation.ValidationPostProcessingRuleJson;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import java.util.List;

@Interceptor
public class ValidationMessageUnknownCodeSystemPostProcessingInterceptor
extends ValidationMessagePostProcessingInterceptor {
    public ValidationMessageUnknownCodeSystemPostProcessingInterceptor(IValidationSupport.IssueSeverity theDesiredSeverityForUnknownCodeSystem) {
        ResultSeverityEnum desiredResultSeverity = ValidationMessageUnknownCodeSystemPostProcessingInterceptor.mapIssueSeverityToResultSeverityEnum(theDesiredSeverityForUnknownCodeSystem);
        super.addPostProcessingPatterns(new ValidationPostProcessingRuleJson("Terminology_TX_System_Unknown", null, List.of(ResultSeverityEnum.ERROR, ResultSeverityEnum.WARNING, ResultSeverityEnum.INFORMATION), List.of("Unknown Code System"), desiredResultSeverity), new ValidationPostProcessingRuleJson("Terminology_PassThrough_TX_Message", null, List.of(ResultSeverityEnum.ERROR, ResultSeverityEnum.WARNING, ResultSeverityEnum.INFORMATION), List.of("CodeSystem is unknown and can't be validated"), desiredResultSeverity), new ValidationPostProcessingRuleJson(null, String.format("%s|%s", "Terminology_PassThrough_TX_Message", "Terminology_TX_NoValid_12"), List.of(ResultSeverityEnum.ERROR, ResultSeverityEnum.WARNING, ResultSeverityEnum.INFORMATION), List.of("Unable to expand ValueSet because CodeSystem could not be found"), desiredResultSeverity));
    }

    private static ResultSeverityEnum mapIssueSeverityToResultSeverityEnum(IValidationSupport.IssueSeverity theIssueSeverity) {
        return switch (theIssueSeverity) {
            default -> throw new IncompatibleClassChangeError();
            case IValidationSupport.IssueSeverity.FATAL -> ResultSeverityEnum.FATAL;
            case IValidationSupport.IssueSeverity.ERROR -> ResultSeverityEnum.ERROR;
            case IValidationSupport.IssueSeverity.WARNING -> ResultSeverityEnum.WARNING;
            case IValidationSupport.IssueSeverity.INFORMATION, IValidationSupport.IssueSeverity.SUCCESS -> ResultSeverityEnum.INFORMATION;
        };
    }
}

