/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@Interceptor
public class ValidationMessageSuppressingInterceptor {
    private List<Pattern> mySuppressPatterns = new ArrayList<Pattern>();

    public ValidationMessageSuppressingInterceptor addMessageSuppressionPatterns(String ... thePatterns) {
        return this.addMessageSuppressionPatterns(Arrays.asList(thePatterns));
    }

    public ValidationMessageSuppressingInterceptor addMessageSuppressionPatterns(List<String> thePatterns) {
        for (String next : thePatterns) {
            if (!StringUtils.isNotBlank((CharSequence)next)) continue;
            Pattern pattern = Pattern.compile(next, 2);
            this.mySuppressPatterns.add(pattern);
        }
        return this;
    }

    @Hook(value=Pointcut.VALIDATION_COMPLETED)
    public ValidationResult handle(ValidationResult theResult) {
        List originalMessages = theResult.getMessages();
        ArrayList<SingleValidationMessage> newMessages = new ArrayList<SingleValidationMessage>(originalMessages.size());
        for (SingleValidationMessage message : originalMessages) {
            boolean shouldSuppress = false;
            for (Pattern nextSuppressPattern : this.mySuppressPatterns) {
                if (message.hasSliceMessages()) {
                    List sliceMessages = message.getSliceMessages();
                    List<String> filteredSliceMessages = this.filterSliceMessages(nextSuppressPattern, sliceMessages);
                    message.setSliceMessages(filteredSliceMessages);
                    if (!ObjectUtils.isEmpty(filteredSliceMessages)) continue;
                    shouldSuppress = true;
                    break;
                }
                String nextMessage = message.getMessage();
                if (!nextSuppressPattern.matcher(nextMessage).find()) continue;
                shouldSuppress = true;
                break;
            }
            if (shouldSuppress) continue;
            newMessages.add(message);
        }
        theResult.setMessages(newMessages);
        return null;
    }

    private List<String> filterSliceMessages(@Nonnull Pattern thePattern, @Nonnull List<String> theOriginalSliceMessages) {
        if (ObjectUtils.isEmpty(theOriginalSliceMessages)) {
            return Collections.emptyList();
        }
        ArrayList<String> filteredSliceMessages = new ArrayList<String>();
        for (String sliceMessage : theOriginalSliceMessages) {
            boolean shouldSuppress = thePattern.matcher(sliceMessage).find();
            if (shouldSuppress) continue;
            filteredSliceMessages.add(sliceMessage);
        }
        return filteredSliceMessages;
    }
}

