/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.consent;

import ca.uhn.fhir.rest.server.interceptor.consent.IConsentVote;
import java.util.stream.Stream;

public enum ConsentOperationStatusEnum implements IConsentVote
{
    REJECT,
    PROCEED,
    AUTHORIZED;


    int getPrecedence() {
        switch (this) {
            case REJECT: {
                return 2;
            }
            case AUTHORIZED: {
                return 1;
            }
        }
        return 0;
    }

    boolean isAbstain() {
        return this == PROCEED;
    }

    boolean isActiveVote() {
        return this != PROCEED;
    }

    @Override
    public ConsentOperationStatusEnum getStatus() {
        return this;
    }

    public static ConsentOperationStatusEnum serialReduce(Stream<ConsentOperationStatusEnum> theVoteStream) {
        return (ConsentOperationStatusEnum)((Object)IConsentVote.serialReduce(PROCEED, theVoteStream));
    }

    public static ConsentOperationStatusEnum parallelReduce(Stream<ConsentOperationStatusEnum> theVoteStream) {
        return (ConsentOperationStatusEnum)((Object)IConsentVote.parallelReduce(PROCEED, theVoteStream));
    }

    @Deprecated(forRemoval=true)
    public static ConsentOperationStatusEnum serialEvaluate(Stream<ConsentOperationStatusEnum> theVoteStream) {
        return ConsentOperationStatusEnum.serialReduce(theVoteStream);
    }

    @Deprecated(forRemoval=true)
    public static ConsentOperationStatusEnum parallelEvaluate(Stream<ConsentOperationStatusEnum> theVoteStream) {
        return ConsentOperationStatusEnum.parallelReduce(theVoteStream);
    }
}

