/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.interceptor.auth.AllowedCodeInValueSet;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizedList;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.ValidateUtil;
import ca.uhn.fhir.util.bundle.ModifiableBundleEntryParts;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;

public class SearchNarrowingInterceptor {
    public static final String POST_FILTERING_LIST_ATTRIBUTE_NAME = SearchNarrowingInterceptor.class.getName() + "_POST_FILTERING_LIST";
    private IValidationSupport myValidationSupport;
    private int myPostFilterLargeValueSetThreshold = 500;
    private boolean myNarrowConditionalUrls;

    public void setNarrowConditionalUrls(boolean theNarrowConditionalUrls) {
        this.myNarrowConditionalUrls = theNarrowConditionalUrls;
    }

    public void setPostFilterLargeValueSetThreshold(int thePostFilterLargeValueSetThreshold) {
        Validate.isTrue((thePostFilterLargeValueSetThreshold > 0 ? 1 : 0) != 0, (String)"thePostFilterLargeValueSetThreshold must be a positive integer", (Object[])new Object[0]);
        this.myPostFilterLargeValueSetThreshold = thePostFilterLargeValueSetThreshold;
    }

    public SearchNarrowingInterceptor setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        return this;
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_POST_PROCESSED)
    public void hookIncomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        RestOperationTypeEnum restOperationType = theRequestDetails.getRestOperationType();
        Validate.isTrue((restOperationType != RestOperationTypeEnum.SEARCH_SYSTEM ? 1 : 0) != 0);
        switch (restOperationType) {
            case EXTENDED_OPERATION_INSTANCE: 
            case EXTENDED_OPERATION_TYPE: {
                if (!"$everything".equals(theRequestDetails.getOperation())) break;
                this.narrowEverythingOperation(theRequestDetails);
                break;
            }
            case SEARCH_TYPE: {
                this.narrowTypeSearch(theRequestDetails);
                break;
            }
            case CREATE: {
                this.narrowIfNoneExistHeader(theRequestDetails);
                break;
            }
            case DELETE: 
            case UPDATE: 
            case PATCH: {
                this.narrowRequestUrl(theRequestDetails, restOperationType);
            }
        }
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void hookIncomingRequestPreHandled(ServletRequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        if (theRequestDetails.getRestOperationType() != null) {
            switch (theRequestDetails.getRestOperationType()) {
                case TRANSACTION: 
                case BATCH: {
                    IBaseBundle bundle = (IBaseBundle)theRequestDetails.getResource();
                    FhirContext ctx = theRequestDetails.getFhirContext();
                    BundleEntryUrlProcessor processor = new BundleEntryUrlProcessor(ctx, theRequestDetails);
                    BundleUtil.processAllEntries((FhirContext)ctx, (IBaseBundle)bundle, (Consumer)processor);
                }
            }
        }
    }

    protected AuthorizedList buildAuthorizedList(RequestDetails theRequestDetails) {
        return null;
    }

    private void narrowEverythingOperation(RequestDetails theRequestDetails) {
        AuthorizedList authorizedList = this.buildAuthorizedList(theRequestDetails);
        if (authorizedList != null) {
            this.buildParameterListForAuthorizedCodes(theRequestDetails, theRequestDetails.getResourceName(), authorizedList);
        }
    }

    private void narrowIfNoneExistHeader(RequestDetails theRequestDetails) {
        String newConditionalUrl;
        String ifNoneExist;
        if (this.myNarrowConditionalUrls && StringUtils.isNotBlank((CharSequence)(ifNoneExist = theRequestDetails.getHeader("If-None-Exist"))) && (newConditionalUrl = this.narrowConditionalUrlForCompartmentOnly(theRequestDetails, ifNoneExist, true, theRequestDetails.getResourceName())) != null) {
            theRequestDetails.setHeaders("If-None-Exist", List.of(newConditionalUrl));
        }
    }

    private void narrowRequestUrl(RequestDetails theRequestDetails, RestOperationTypeEnum theRestOperationType) {
        String newConditionalUrl;
        String conditionalUrl;
        if (this.myNarrowConditionalUrls && StringUtils.isNotBlank((CharSequence)(conditionalUrl = theRequestDetails.getConditionalUrl(theRestOperationType))) && (newConditionalUrl = this.narrowConditionalUrlForCompartmentOnly(theRequestDetails, conditionalUrl, false, theRequestDetails.getResourceName())) != null) {
            String newCompleteUrl = theRequestDetails.getCompleteUrl().substring(0, theRequestDetails.getCompleteUrl().indexOf(63) + 1) + newConditionalUrl;
            theRequestDetails.setCompleteUrl(newCompleteUrl);
        }
    }

    @Nullable
    private String narrowConditionalUrlForCompartmentOnly(RequestDetails theRequestDetails, @Nonnull String theConditionalUrl, boolean theIncludeUpToQuestionMarkInResponse, String theResourceName) {
        AuthorizedList authorizedList = this.buildAuthorizedList(theRequestDetails);
        return this.narrowConditionalUrl(theRequestDetails, theConditionalUrl, theIncludeUpToQuestionMarkInResponse, theResourceName, false, authorizedList);
    }

    @Nullable
    private String narrowConditionalUrl(RequestDetails theRequestDetails, @Nonnull String theConditionalUrl, boolean theIncludeUpToQuestionMarkInResponse, String theResourceName, boolean theNarrowCodes, AuthorizedList theAuthorizedList) {
        if (theAuthorizedList == null) {
            return null;
        }
        ListMultimap<String, String> parametersToAdd = this.buildParameterListForAuthorizedCompartment(theRequestDetails, theResourceName, theAuthorizedList);
        if (theNarrowCodes) {
            ListMultimap<String, String> parametersToAddForCodes = this.buildParameterListForAuthorizedCodes(theRequestDetails, theResourceName, theAuthorizedList);
            if (parametersToAdd == null) {
                parametersToAdd = parametersToAddForCodes;
            } else if (parametersToAddForCodes != null) {
                parametersToAdd.putAll(parametersToAddForCodes);
            }
        }
        String newConditionalUrl = null;
        if (parametersToAdd != null) {
            String query = theConditionalUrl;
            int qMarkIndex = theConditionalUrl.indexOf(63);
            if (qMarkIndex != -1) {
                query = theConditionalUrl.substring(qMarkIndex + 1);
            }
            Map inputParams = UrlUtil.parseQueryString((String)query);
            Map<String, String[]> newParameters = SearchNarrowingInterceptor.applyCompartmentParameters(parametersToAdd, true, inputParams);
            StringBuilder newUrl = new StringBuilder();
            if (theIncludeUpToQuestionMarkInResponse) {
                newUrl.append(qMarkIndex != -1 ? theConditionalUrl.substring(0, qMarkIndex + 1) : "?");
            }
            boolean first = true;
            for (Map.Entry<String, String[]> nextEntry : newParameters.entrySet()) {
                for (String nextValue : nextEntry.getValue()) {
                    if (!StringUtils.isNotBlank((CharSequence)nextValue)) continue;
                    if (first) {
                        first = false;
                    } else {
                        newUrl.append("&");
                    }
                    newUrl.append(UrlUtil.escapeUrlParam((String)nextEntry.getKey()));
                    newUrl.append("=");
                    newUrl.append(UrlUtil.escapeUrlParam((String)nextValue));
                }
            }
            newConditionalUrl = newUrl.toString();
        }
        return newConditionalUrl;
    }

    private void narrowTypeSearch(RequestDetails theRequestDetails) {
        ListMultimap<String, String> parameterToOrValues;
        if (this.shouldSkipNarrowing(theRequestDetails)) {
            return;
        }
        AuthorizedList authorizedList = this.buildAuthorizedList(theRequestDetails);
        if (authorizedList == null) {
            return;
        }
        String resourceName = theRequestDetails.getResourceName();
        ListMultimap<String, String> parametersToAdd = this.buildParameterListForAuthorizedCompartment(theRequestDetails, resourceName, authorizedList);
        if (parametersToAdd != null) {
            this.applyParametersToRequestDetails(theRequestDetails, parametersToAdd, true);
        }
        if ((parameterToOrValues = this.buildParameterListForAuthorizedCodes(theRequestDetails, resourceName, authorizedList)) != null) {
            this.applyParametersToRequestDetails(theRequestDetails, parameterToOrValues, false);
        }
    }

    @Nullable
    private ListMultimap<String, String> buildParameterListForAuthorizedCodes(RequestDetails theRequestDetails, String resourceName, AuthorizedList authorizedList) {
        List<AllowedCodeInValueSet> postFilteringList = SearchNarrowingInterceptor.getPostFilteringList(theRequestDetails);
        if (authorizedList.getAllowedCodeInValueSets() != null) {
            postFilteringList.addAll(authorizedList.getAllowedCodeInValueSets());
        }
        List<AllowedCodeInValueSet> allowedCodeInValueSet = authorizedList.getAllowedCodeInValueSets();
        ListMultimap<String, String> parameterToOrValues = null;
        if (allowedCodeInValueSet != null) {
            FhirContext context = theRequestDetails.getServer().getFhirContext();
            RuntimeResourceDefinition resourceDef = context.getResourceDefinition(resourceName);
            parameterToOrValues = this.processAllowedCodes(resourceDef, allowedCodeInValueSet);
        }
        return parameterToOrValues;
    }

    @Nullable
    private ListMultimap<String, String> buildParameterListForAuthorizedCompartment(RequestDetails theRequestDetails, String theResourceName, @Nullable AuthorizedList theAuthorizedList) {
        List<String> resources;
        if (theAuthorizedList == null) {
            return null;
        }
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        RuntimeResourceDefinition resDef = ctx.getResourceDefinition(theResourceName);
        List<String> compartments = theAuthorizedList.getAllowedCompartments();
        ListMultimap<String, String> parametersToAdd = null;
        if (compartments != null) {
            parametersToAdd = this.processResourcesOrCompartments(theRequestDetails, resDef, compartments, true, theResourceName);
        }
        if ((resources = theAuthorizedList.getAllowedInstances()) != null) {
            ListMultimap<String, String> parameterToOrValues = this.processResourcesOrCompartments(theRequestDetails, resDef, resources, false, theResourceName);
            if (parametersToAdd == null) {
                parametersToAdd = parameterToOrValues;
            } else if (parameterToOrValues != null) {
                parametersToAdd.putAll(parameterToOrValues);
            }
        }
        return parametersToAdd;
    }

    private boolean shouldSkipNarrowing(RequestDetails theRequestDetails) {
        return theRequestDetails.getRestOperationType() != RestOperationTypeEnum.SEARCH_TYPE && !"$everything".equalsIgnoreCase(theRequestDetails.getOperation());
    }

    private void applyParametersToRequestDetails(RequestDetails theRequestDetails, @Nullable ListMultimap<String, String> theParameterToOrValues, boolean thePatientIdMode) {
        Map<String, String[]> inputParameters = theRequestDetails.getParameters();
        if (theParameterToOrValues != null) {
            Map<String, String[]> newParameters = SearchNarrowingInterceptor.applyCompartmentParameters(theParameterToOrValues, thePatientIdMode, inputParameters);
            theRequestDetails.setParameters(newParameters);
        }
    }

    @Nullable
    private ListMultimap<String, String> processResourcesOrCompartments(RequestDetails theRequestDetails, RuntimeResourceDefinition theResDef, Collection<String> theResourcesOrCompartments, boolean theAreCompartments, String theResourceName) {
        ListMultimap retVal = null;
        String lastCompartmentName = null;
        String lastSearchParamName = null;
        for (String nextCompartment : theResourcesOrCompartments) {
            Validate.isTrue((StringUtils.countMatches((CharSequence)nextCompartment, (char)'/') == 1 ? 1 : 0) != 0, (String)"Invalid compartment name (must be in form \"ResourceType/xxx\": %s", (Object[])new Object[]{nextCompartment});
            String compartmentName = nextCompartment.substring(0, nextCompartment.indexOf(47));
            String searchParamName = null;
            if (compartmentName.equalsIgnoreCase(lastCompartmentName)) {
                searchParamName = lastSearchParamName;
            } else {
                if (compartmentName.equalsIgnoreCase(theResourceName)) {
                    searchParamName = "_id";
                } else if (theAreCompartments) {
                    searchParamName = this.selectBestSearchParameterForCompartment(theRequestDetails, theResDef, compartmentName);
                }
                lastCompartmentName = compartmentName;
                lastSearchParamName = searchParamName;
            }
            if (searchParamName == null) continue;
            if (retVal == null) {
                retVal = MultimapBuilder.hashKeys().arrayListValues().build();
            }
            retVal.put((Object)searchParamName, (Object)nextCompartment);
        }
        return retVal;
    }

    @Nullable
    private ListMultimap<String, String> processAllowedCodes(RuntimeResourceDefinition theResDef, List<AllowedCodeInValueSet> theAllowedCodeInValueSet) {
        ListMultimap retVal = null;
        for (AllowedCodeInValueSet next : theAllowedCodeInValueSet) {
            String resourceName = next.getResourceName();
            String valueSetUrl = next.getValueSetUrl();
            ValidateUtil.isNotBlankOrThrowIllegalArgument((String)resourceName, (String)"Resource name supplied by SearchNarrowingInterceptor must not be null");
            ValidateUtil.isNotBlankOrThrowIllegalArgument((String)valueSetUrl, (String)"ValueSet URL supplied by SearchNarrowingInterceptor must not be null");
            if (!resourceName.equals(theResDef.getName()) || this.shouldHandleThroughConsentService(valueSetUrl)) continue;
            String paramName = next.isNegate() ? next.getSearchParameterName() + ":not-in" : next.getSearchParameterName() + ":in";
            if (retVal == null) {
                retVal = MultimapBuilder.hashKeys().arrayListValues().build();
            }
            retVal.put((Object)paramName, (Object)valueSetUrl);
        }
        return retVal;
    }

    private boolean shouldHandleThroughConsentService(String theValueSetUrl) {
        if (this.myValidationSupport != null && this.myPostFilterLargeValueSetThreshold != -1) {
            ValidationSupportContext ctx = new ValidationSupportContext(this.myValidationSupport);
            ValueSetExpansionOptions options = new ValueSetExpansionOptions();
            options.setCount(this.myPostFilterLargeValueSetThreshold);
            options.setIncludeHierarchy(false);
            IValidationSupport.ValueSetExpansionOutcome outcome = this.myValidationSupport.expandValueSet(ctx, options, theValueSetUrl);
            if (outcome != null && outcome.getValueSet() != null) {
                FhirTerser terser = this.myValidationSupport.getFhirContext().newTerser();
                List contains = terser.getValues((IBase)outcome.getValueSet(), "ValueSet.expansion.contains");
                int codeCount = contains.size();
                return codeCount >= this.myPostFilterLargeValueSetThreshold;
            }
        }
        return false;
    }

    private String selectBestSearchParameterForCompartment(RequestDetails theRequestDetails, RuntimeResourceDefinition theResDef, String compartmentName) {
        String searchParamName = null;
        Set<String> queryParameters = theRequestDetails.getParameters().keySet();
        List searchParams = theResDef.getSearchParamsForCompartmentName(compartmentName);
        if (!searchParams.isEmpty()) {
            Optional<RuntimeSearchParam> synonymInUse;
            String primarySearchParamName;
            Optional<RuntimeSearchParam> primarySearchParam = searchParams.stream().filter(t -> t.getName().equalsIgnoreCase(compartmentName)).findFirst();
            searchParamName = primarySearchParam.isPresent() ? (queryParameters.contains(primarySearchParamName = primarySearchParam.get().getName()) ? primarySearchParamName : ((synonymInUse = this.findSynonyms(searchParams, primarySearchParam.get()).stream().filter(t -> queryParameters.contains(t.getName())).findFirst()).isPresent() ? synonymInUse.get().getName() : primarySearchParamName)) : ((RuntimeSearchParam)searchParams.get(0)).getName();
        }
        return searchParamName;
    }

    private List<RuntimeSearchParam> findSynonyms(List<RuntimeSearchParam> searchParams, RuntimeSearchParam primarySearchParam) {
        String primaryBasePath = this.getBasePath(primarySearchParam);
        return searchParams.stream().filter(t -> primaryBasePath.equals(this.getBasePath((RuntimeSearchParam)t))).collect(Collectors.toList());
    }

    private String getBasePath(RuntimeSearchParam searchParam) {
        int qualifierIndex = searchParam.getPath().indexOf(".where");
        if (qualifierIndex == -1) {
            return searchParam.getPath();
        }
        return searchParam.getPath().substring(0, qualifierIndex);
    }

    @Nonnull
    private static Map<String, String[]> applyCompartmentParameters(@Nonnull ListMultimap<String, String> theParameterToOrValues, boolean thePatientIdMode, Map<String, String[]> theInputParameters) {
        HashMap<String, String[]> newParameters = new HashMap<String, String[]>(theInputParameters);
        for (String nextParamName : theParameterToOrValues.keySet()) {
            int i;
            List nextAllowedValues = theParameterToOrValues.get((Object)nextParamName);
            if (!newParameters.containsKey(nextParamName)) {
                String nextValuesJoined = ParameterUtil.escapeAndJoinOrList((Collection)nextAllowedValues);
                String[] paramValues = new String[]{nextValuesJoined};
                newParameters.put(nextParamName, paramValues);
                continue;
            }
            String[] existingValues = (String[])newParameters.get(nextParamName);
            if (thePatientIdMode) {
                List nextAllowedValueIds = nextAllowedValues.stream().map(t -> t.lastIndexOf("/") > -1 ? t.substring(t.lastIndexOf("/") + 1) : t).collect(Collectors.toList());
                boolean restrictedExistingList = false;
                for (i = 0; i < existingValues.length; ++i) {
                    String nextExistingValue = existingValues[i];
                    QualifiedParamList nextRequestedValues = QualifiedParamList.splitQueryStringByCommasIgnoreEscape(null, (String)nextExistingValue);
                    List nextPermittedValues = ListUtils.union((List)ListUtils.intersection((List)nextRequestedValues, (List)nextAllowedValues), (List)ListUtils.intersection((List)nextRequestedValues, nextAllowedValueIds));
                    if (nextPermittedValues.isEmpty()) continue;
                    restrictedExistingList = true;
                    existingValues[i] = ParameterUtil.escapeAndJoinOrList((Collection)nextPermittedValues);
                }
                if (restrictedExistingList) continue;
                throw new ForbiddenOperationException(Msg.code((int)2026) + "Value not permitted for parameter " + UrlUtil.escapeUrlParam((String)nextParamName));
            }
            int existingValuesCount = existingValues.length;
            String[] newValues = Arrays.copyOf(existingValues, existingValuesCount + nextAllowedValues.size());
            for (i = 0; i < nextAllowedValues.size(); ++i) {
                newValues[existingValuesCount + i] = (String)nextAllowedValues.get(i);
            }
            newParameters.put(nextParamName, newValues);
        }
        return newParameters;
    }

    static List<AllowedCodeInValueSet> getPostFilteringList(RequestDetails theRequestDetails) {
        List<AllowedCodeInValueSet> retVal = SearchNarrowingInterceptor.getPostFilteringListOrNull(theRequestDetails);
        if (retVal == null) {
            retVal = new ArrayList<AllowedCodeInValueSet>();
            theRequestDetails.getUserData().put(POST_FILTERING_LIST_ATTRIBUTE_NAME, retVal);
        }
        return retVal;
    }

    static List<AllowedCodeInValueSet> getPostFilteringListOrNull(RequestDetails theRequestDetails) {
        return (List)theRequestDetails.getUserData().get(POST_FILTERING_LIST_ATTRIBUTE_NAME);
    }

    private class BundleEntryUrlProcessor
    implements Consumer<ModifiableBundleEntryParts> {
        private final FhirContext myFhirContext;
        private final ServletRequestDetails myRequestDetails;
        private final AuthorizedList myAuthorizedList;

        public BundleEntryUrlProcessor(FhirContext theFhirContext, ServletRequestDetails theRequestDetails) {
            this.myFhirContext = theFhirContext;
            this.myRequestDetails = theRequestDetails;
            this.myAuthorizedList = SearchNarrowingInterceptor.this.buildAuthorizedList(theRequestDetails);
        }

        @Override
        public void accept(ModifiableBundleEntryParts theModifiableBundleEntry) {
            if (this.myAuthorizedList == null) {
                return;
            }
            RequestTypeEnum method = theModifiableBundleEntry.getMethod();
            String requestUrl = theModifiableBundleEntry.getUrl();
            if (method != null && StringUtils.isNotBlank((CharSequence)requestUrl)) {
                String resourceType = UrlUtil.parseUrl((String)requestUrl).getResourceType();
                switch (method) {
                    case GET: {
                        String existingRequestUrl = theModifiableBundleEntry.getUrl();
                        Object newConditionalUrl = SearchNarrowingInterceptor.this.narrowConditionalUrl(this.myRequestDetails, existingRequestUrl, false, resourceType, true, this.myAuthorizedList);
                        if (!StringUtils.isNotBlank((CharSequence)newConditionalUrl)) break;
                        newConditionalUrl = resourceType + "?" + (String)newConditionalUrl;
                        theModifiableBundleEntry.setRequestUrl((String)newConditionalUrl);
                        break;
                    }
                    case POST: {
                        String newConditionalUrl;
                        String existingConditionalUrl;
                        if (!SearchNarrowingInterceptor.this.myNarrowConditionalUrls || !StringUtils.isNotBlank((CharSequence)(existingConditionalUrl = theModifiableBundleEntry.getConditionalUrl())) || !StringUtils.isNotBlank((CharSequence)(newConditionalUrl = SearchNarrowingInterceptor.this.narrowConditionalUrl(this.myRequestDetails, existingConditionalUrl, true, resourceType, false, this.myAuthorizedList)))) break;
                        theModifiableBundleEntry.setRequestIfNoneExist(newConditionalUrl);
                        break;
                    }
                    case PUT: 
                    case DELETE: 
                    case PATCH: {
                        String newConditionalUrl;
                        String existingConditionalUrl;
                        if (!SearchNarrowingInterceptor.this.myNarrowConditionalUrls || !StringUtils.isNotBlank((CharSequence)(existingConditionalUrl = theModifiableBundleEntry.getConditionalUrl())) || !StringUtils.isNotBlank((CharSequence)(newConditionalUrl = SearchNarrowingInterceptor.this.narrowConditionalUrl(this.myRequestDetails, existingConditionalUrl, true, resourceType, false, this.myAuthorizedList)))) break;
                        theModifiableBundleEntry.setRequestUrl(newConditionalUrl);
                    }
                }
            }
        }
    }
}

