/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationFlagsEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBulkExportImpl
extends BaseRule {
    private static final Logger ourLog = LoggerFactory.getLogger(RuleBulkExportImpl.class);
    private String myGroupId;
    private final Collection<String> myPatientIds = new ArrayList<String>();
    private boolean myAppliesToAllPatients;
    private BulkExportJobParameters.ExportStyle myWantExportStyle;
    private Collection<String> myResourceTypes;
    private boolean myWantAnyStyle;

    RuleBulkExportImpl(String theRuleName) {
        super(theRuleName);
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier, Set<AuthorizationFlagsEnum> theFlags, Pointcut thePointcut) {
        String actualGroupId;
        String expectedGroupId;
        if (thePointcut != Pointcut.STORAGE_INITIATE_BULK_EXPORT) {
            return null;
        }
        if (theRequestDetails == null) {
            return null;
        }
        BulkExportJobParameters inboundBulkExportRequestOptions = (BulkExportJobParameters)((Object)theRequestDetails.getUserData().get(AuthorizationInterceptor.REQUEST_ATTRIBUTE_BULK_DATA_EXPORT_OPTIONS));
        if (!this.myWantAnyStyle && inboundBulkExportRequestOptions.getExportStyle() != this.myWantExportStyle) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(this.myResourceTypes)) {
            if (CollectionUtils.isEmpty(inboundBulkExportRequestOptions.getResourceTypes())) {
                return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
            }
            if (!this.myResourceTypes.containsAll(inboundBulkExportRequestOptions.getResourceTypes())) {
                return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
            }
        }
        AuthorizationInterceptor.Verdict allowVerdict = this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, theRuleApplier);
        if (this.myWantAnyStyle || this.myWantExportStyle == BulkExportJobParameters.ExportStyle.SYSTEM) {
            return allowVerdict;
        }
        if (StringUtils.isNotBlank((CharSequence)this.myGroupId) && inboundBulkExportRequestOptions.getGroupId() != null && Objects.equals(expectedGroupId = new IdDt(this.myGroupId).toUnqualifiedVersionless().getValue(), actualGroupId = new IdDt(inboundBulkExportRequestOptions.getGroupId()).toUnqualifiedVersionless().getValue())) {
            return allowVerdict;
        }
        if (this.myWantExportStyle == BulkExportJobParameters.ExportStyle.PATIENT && this.myAppliesToAllPatients) {
            return allowVerdict;
        }
        if (CollectionUtils.isNotEmpty(this.myPatientIds)) {
            if (inboundBulkExportRequestOptions.getPatientIds().isEmpty()) {
                return null;
            }
            ourLog.debug("options.getPatientIds() != null");
            Set<String> requestedPatientIds = this.sanitizeIds(inboundBulkExportRequestOptions.getPatientIds());
            Set<String> permittedPatientIds = this.sanitizeIds(this.myPatientIds);
            if (permittedPatientIds.containsAll(requestedPatientIds)) {
                return allowVerdict;
            }
            return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
        }
        return null;
    }

    private Set<String> sanitizeIds(Collection<String> myPatientIds) {
        return myPatientIds.stream().map(id -> new IdDt(id).toUnqualifiedVersionless().getValue()).collect(Collectors.toSet());
    }

    public void setAppliesToGroupExportOnGroup(String theGroupId) {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.GROUP;
        this.myGroupId = theGroupId;
    }

    public void setAppliesToPatientExportOnGroup(String theGroupId) {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.PATIENT;
        this.myGroupId = theGroupId;
    }

    public void setAppliesToPatientExport(String thePatientId) {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.PATIENT;
        this.myPatientIds.add(thePatientId);
    }

    public void setAppliesToPatientExport(Collection<String> thePatientIds) {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.PATIENT;
        this.myPatientIds.addAll(thePatientIds);
    }

    public void setAppliesToPatientExportAllPatients() {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.PATIENT;
        this.myAppliesToAllPatients = true;
    }

    public void setAppliesToSystem() {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.SYSTEM;
    }

    public void setResourceTypes(Collection<String> theResourceTypes) {
        this.myResourceTypes = theResourceTypes;
    }

    public void setAppliesToAny() {
        this.myWantAnyStyle = true;
    }

    String getGroupId() {
        return this.myGroupId;
    }

    BulkExportJobParameters.ExportStyle getWantExportStyle() {
        return this.myWantExportStyle;
    }

    @VisibleForTesting
    Collection<String> getPatientIds() {
        return this.myPatientIds;
    }

    @VisibleForTesting
    Collection<String> getResourceTypes() {
        return this.myResourceTypes;
    }
}

