/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.server.method.ResponsePage;
import ca.uhn.fhir.util.BundleUtil;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class SimpleBundleProvider
implements IBundleProvider {
    private final List<? extends IBaseResource> myList;
    private final String myUuid;
    private Integer myPreferredPageSize;
    private Integer mySize;
    private IPrimitiveType<Date> myPublished = InstantDt.withCurrentTime();
    private Integer myCurrentPageOffset;
    private Integer myCurrentPageSize;
    private boolean myHasAllResources;
    private ResponsePage.ResponsePageBuilder myPageBuilder;
    private int myTotalResourcesRequestedReturned = -1;

    public SimpleBundleProvider(IBaseResource theResource) {
        this(Collections.singletonList(theResource));
    }

    public SimpleBundleProvider() {
        this(Collections.emptyList());
    }

    public SimpleBundleProvider(List<? extends IBaseResource> theList) {
        this(theList, null);
    }

    public SimpleBundleProvider(IBaseResource ... theList) {
        this(Arrays.asList(theList), null);
    }

    public SimpleBundleProvider(List<? extends IBaseResource> theList, String theUuid) {
        this.myList = theList;
        this.myUuid = theUuid;
        int size = 0;
        for (IBaseResource iBaseResource : theList) {
            if (iBaseResource == null || !BundleUtil.isMatchResource((IBaseResource)iBaseResource)) continue;
            ++size;
        }
        this.myHasAllResources = true;
        this.setSize(size);
    }

    public SimpleBundleProvider(int theSize) {
        this.myList = Collections.emptyList();
        this.myUuid = null;
        this.setSize(theSize);
    }

    @Override
    public Integer getCurrentPageOffset() {
        return this.myCurrentPageOffset;
    }

    public void setCurrentPageOffset(Integer theCurrentPageOffset) {
        this.myCurrentPageOffset = theCurrentPageOffset;
    }

    @Override
    public Integer getCurrentPageSize() {
        return this.myCurrentPageSize;
    }

    public void setCurrentPageSize(Integer theCurrentPageSize) {
        this.myCurrentPageSize = theCurrentPageSize;
    }

    protected List<? extends IBaseResource> getList() {
        return this.myList;
    }

    @Override
    public IPrimitiveType<Date> getPublished() {
        return this.myPublished;
    }

    public void setPublished(IPrimitiveType<Date> thePublished) {
        this.myPublished = thePublished;
    }

    @Override
    @Nonnull
    public List<IBaseResource> getResources(int theFromIndex, int theToIndex, @Nonnull ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
        theResponsePageBuilder.setTotalRequestedResourcesFetched(this.myTotalResourcesRequestedReturned);
        return this.myList.subList(Math.min(theFromIndex, this.myList.size()), Math.min(theToIndex, this.myList.size()));
    }

    @Override
    public String getUuid() {
        return this.myUuid;
    }

    public void setTotalResourcesRequestedReturned(int theAmount) {
        this.myTotalResourcesRequestedReturned = theAmount;
    }

    @Override
    public Integer preferredPageSize() {
        return this.myPreferredPageSize;
    }

    public void setPreferredPageSize(Integer thePreferredPageSize) {
        this.myPreferredPageSize = thePreferredPageSize;
    }

    public SimpleBundleProvider setSize(Integer theSize) {
        this.mySize = theSize;
        return this;
    }

    @Override
    public Integer size() {
        return this.mySize;
    }

    @Override
    public boolean containsAllResources() {
        return this.myHasAllResources;
    }

    @Override
    public List<IBaseResource> getResourceListComplete() {
        return this.myList.stream().map(r -> r).collect(Collectors.toList());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("mySize", (Object)this.mySize).toString();
    }
}

