/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.method.ResponsePage;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public interface IBundleProvider {
    default public String getCurrentPageId() {
        return null;
    }

    default public String getNextPageId() {
        return null;
    }

    default public String getPreviousPageId() {
        return null;
    }

    default public Integer getCurrentPageOffset() {
        return null;
    }

    default public Integer getCurrentPageSize() {
        return null;
    }

    public IPrimitiveType<Date> getPublished();

    @Nonnull
    default public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
        return this.getResources(theFromIndex, theToIndex, new ResponsePage.ResponsePageBuilder());
    }

    default public List<IBaseResource> getResources(int theFromIndex, int theToIndex, @Nonnull ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
        return this.getResources(theFromIndex, theToIndex);
    }

    @Nonnull
    default public List<IBaseResource> getAllResources() {
        int size;
        ArrayList<IBaseResource> retval = new ArrayList<IBaseResource>();
        Integer sizeI = this.size();
        if (sizeI == null) {
            throw new ConfigurationException(Msg.code((int)464) + "Attempt to request all resources from an asynchronous search result.  The SearchParameterMap for this search probably should have been synchronous.");
        }
        int n = size = this.containsAllResources() ? this.getResourceListComplete().size() : sizeI.intValue();
        if (size > 0) {
            retval.addAll(this.getResources(0, size));
        }
        return retval;
    }

    default public List<IBaseResource> getResourceListComplete() {
        return this.getAllResources();
    }

    @Nullable
    public String getUuid();

    public Integer preferredPageSize();

    @Nullable
    public Integer size();

    default public boolean containsAllResources() {
        return false;
    }

    default public boolean isEmpty() {
        Integer size = this.size();
        if (size != null) {
            return size == 0;
        }
        return this.getResources(0, 1).isEmpty();
    }

    default public int sizeOrThrowNpe() {
        Integer retVal = this.size();
        Validate.notNull((Object)retVal, (String)"size() returned null", (Object[])new Object[0]);
        return retVal;
    }

    default public List<String> getAllResourceIds() {
        return this.getAllResources().stream().map(resource -> resource.getIdElement().getIdPart()).collect(Collectors.toList());
    }
}

