/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class MatchUrlUtil {
    private MatchUrlUtil() {
    }

    public static List<NameValuePair> translateMatchUrl(String theMatchUrl) {
        String[] replacementList;
        String[] searchList;
        String matchUrl = theMatchUrl;
        int questionMarkIndex = matchUrl.indexOf(63);
        if (questionMarkIndex != -1) {
            matchUrl = matchUrl.substring(questionMarkIndex + 1);
        }
        if ((matchUrl = StringUtils.replaceEach((String)matchUrl, (String[])(searchList = new String[]{"|", "=>=", "=<=", "=>", "=<"}), (String[])(replacementList = new String[]{"%7C", "=%3E%3D", "=%3C%3D", "=%3E", "=%3C"}))).contains(" ")) {
            throw new InvalidRequestException(Msg.code((int)1744) + "Failed to parse match URL[" + theMatchUrl + "] - URL is invalid (must not contain spaces)");
        }
        List parameters = URLEncodedUtils.parse((String)matchUrl, (Charset)Constants.CHARSET_UTF8, (char[])new char[]{'&'});
        for (int i = 0; i < parameters.size(); ++i) {
            NameValuePair next = (NameValuePair)parameters.get(i);
            if (!next.getName().equals("email") || !next.getValue().contains(" ")) continue;
            BasicNameValuePair newPair = new BasicNameValuePair(next.getName(), next.getValue().replace(' ', '+'));
            parameters.set(i, newPair);
        }
        return parameters;
    }
}

