/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Elements;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import ca.uhn.fhir.util.DateUtils;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadMethodBinding
extends BaseResourceReturningMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(ReadMethodBinding.class);
    private Integer myIdIndex;
    private boolean mySupportsVersion;
    private Class<? extends IIdType> myIdParameterType;

    public ReadMethodBinding(Class<? extends IBaseResource> theAnnotatedResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theAnnotatedResourceType, theMethod, theContext, theProvider);
        Validate.notNull((Object)theMethod, (String)"Method must not be null", (Object[])new Object[0]);
        Integer idIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        this.mySupportsVersion = theMethod.getAnnotation(Read.class).version();
        this.myIdIndex = idIndex;
        if (this.myIdIndex == null) {
            throw new ConfigurationException(Msg.code((int)382) + "@" + Read.class.getSimpleName() + " method " + theMethod.getName() + " on type \"" + theMethod.getDeclaringClass().getName() + "\" does not have a parameter annotated with @" + IdParam.class.getSimpleName());
        }
        this.myIdParameterType = parameterTypes[this.myIdIndex];
        if (!IIdType.class.isAssignableFrom(this.myIdParameterType)) {
            throw new ConfigurationException(Msg.code((int)383) + "ID parameter must be of type IdDt or IdType - Found: " + String.valueOf(this.myIdParameterType));
        }
    }

    @Override
    public RestOperationTypeEnum getRestOperationType(RequestDetails theRequestDetails) {
        if (this.mySupportsVersion && theRequestDetails.getId().hasVersionIdPart()) {
            return RestOperationTypeEnum.VREAD;
        }
        return RestOperationTypeEnum.READ;
    }

    @Override
    public List<Class<?>> getAllowableParamAnnotations() {
        ArrayList retVal = new ArrayList();
        retVal.add(IdParam.class);
        retVal.add(Elements.class);
        return retVal;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return this.isVread() ? RestOperationTypeEnum.VREAD : RestOperationTypeEnum.READ;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (!theRequest.getResourceName().equals(this.getResourceName())) {
            return MethodMatchEnum.NONE;
        }
        for (String next : theRequest.getParameters().keySet()) {
            if (next.startsWith("_")) continue;
            return MethodMatchEnum.NONE;
        }
        if (theRequest.getId() == null) {
            return MethodMatchEnum.NONE;
        }
        if (!this.mySupportsVersion && theRequest.getId().hasVersionIdPart()) {
            return MethodMatchEnum.NONE;
        }
        if (StringUtils.isNotBlank((CharSequence)theRequest.getCompartmentName())) {
            return MethodMatchEnum.NONE;
        }
        if (theRequest.getRequestType() != RequestTypeEnum.GET && theRequest.getRequestType() != RequestTypeEnum.HEAD) {
            ourLog.trace("Method {} doesn't match because request type is not GET or HEAD: {}", (Object)theRequest.getId(), (Object)theRequest.getRequestType());
            return MethodMatchEnum.NONE;
        }
        if ("_history".equals(theRequest.getOperation())) {
            if (!this.mySupportsVersion) {
                return MethodMatchEnum.NONE;
            }
            if (!theRequest.getId().hasVersionIdPart()) {
                return MethodMatchEnum.NONE;
            }
        } else if (!StringUtils.isBlank((CharSequence)theRequest.getOperation())) {
            return MethodMatchEnum.NONE;
        }
        return MethodMatchEnum.EXACT;
    }

    @Override
    public IBundleProvider invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        IIdType requestId = theRequest.getId();
        FhirContext ctx = theRequest.getServer().getFhirContext();
        CharSequence[] invalidQueryStringParams = new String[]{"_contained", "_count", "_include", "_revinclude", "_sort", "_total"};
        ArrayList<String> invalidQueryStringParamsInRequest = new ArrayList<String>();
        Set<String> queryStringParamsInRequest = theRequest.getParameters().keySet();
        for (String queryStringParamName : queryStringParamsInRequest) {
            String lowercaseQueryStringParamName = queryStringParamName.toLowerCase();
            if (!StringUtils.startsWithAny((CharSequence)lowercaseQueryStringParamName, (CharSequence[])invalidQueryStringParams)) continue;
            invalidQueryStringParamsInRequest.add(queryStringParamName);
        }
        if (!invalidQueryStringParamsInRequest.isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)384) + ctx.getLocalizer().getMessage(ReadMethodBinding.class, "invalidParamsInRequest", new Object[]{invalidQueryStringParamsInRequest}));
        }
        theMethodParams[this.myIdIndex.intValue()] = ParameterUtil.convertIdToType((IIdType)requestId, this.myIdParameterType);
        Object response = this.invokeServerMethod(theRequest, theMethodParams);
        IBundleProvider retVal = this.toResourceList(response);
        if (Integer.valueOf(1).equals(retVal.size())) {
            String ifModifiedSince;
            String ifNoneMatch;
            List<IBaseResource> responseResources = retVal.getResources(0, 1);
            IBaseResource responseResource = responseResources.get(0);
            if (theRequest.getServer().getETagSupport() == ETagSupportEnum.ENABLED && StringUtils.isNotBlank((CharSequence)(ifNoneMatch = theRequest.getHeader(Constants.HEADER_IF_NONE_MATCH_LC)))) {
                ifNoneMatch = ParameterUtil.parseETagValue((String)ifNoneMatch);
                String versionIdPart = responseResource.getIdElement().getVersionIdPart();
                if (StringUtils.isBlank((CharSequence)versionIdPart)) {
                    versionIdPart = responseResource.getMeta().getVersionId();
                }
                if (ifNoneMatch.equals(versionIdPart)) {
                    ourLog.debug("Returning HTTP 304 because request specified {}={}", (Object)"If-None-Match", (Object)ifNoneMatch);
                    throw new NotModifiedException(Msg.code((int)385) + "Not Modified");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(ifModifiedSince = theRequest.getHeader(Constants.HEADER_IF_MODIFIED_SINCE_LC)))) {
                Date ifModifiedSinceDate = DateUtils.parseDate((String)ifModifiedSince);
                Date lastModified = null;
                if (responseResource instanceof IResource) {
                    InstantDt lastModifiedDt = (InstantDt)ResourceMetadataKeyEnum.UPDATED.get((IBaseResource)((IResource)responseResource));
                    if (lastModifiedDt != null) {
                        lastModified = (Date)lastModifiedDt.getValue();
                    }
                } else {
                    lastModified = responseResource.getMeta().getLastUpdated();
                }
                if (lastModified != null && lastModified.getTime() <= ifModifiedSinceDate.getTime()) {
                    ourLog.debug("Returning HTTP 304 because If-Modified-Since does not match");
                    throw new NotModifiedException(Msg.code((int)386) + "Not Modified");
                }
            }
        }
        return retVal;
    }

    public boolean isVread() {
        return this.mySupportsVersion;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }
}

