/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.IDefaultPartitionSettings;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Optional;

public final class RequestPartitionHeaderUtil {
    public static final String HTTP_HEADER_SOURCE_NAME = "header: X-Request-Partition-IDs";

    private RequestPartitionHeaderUtil() {
    }

    @Nullable
    public static RequestPartitionId fromHeader(@Nonnull String theSourceName, @Nullable String thePartitionHeaderValue, @Nullable IDefaultPartitionSettings theDefaultPartitionSettings) {
        return RequestPartitionHeaderUtil.fromHeader(theSourceName, thePartitionHeaderValue, false, theDefaultPartitionSettings);
    }

    @Nullable
    public static RequestPartitionId fromHeader(@Nullable String thePartitionHeaderValue, @Nullable IDefaultPartitionSettings theDefaultPartitionSettings) {
        return RequestPartitionHeaderUtil.fromHeader(HTTP_HEADER_SOURCE_NAME, thePartitionHeaderValue, false, theDefaultPartitionSettings);
    }

    @Nullable
    public static RequestPartitionId fromHeaderFirstPartitionOnly(@Nonnull String theSourceName, @Nullable String thePartitionHeaderValue, @Nullable IDefaultPartitionSettings theDefaultPartitionSettings) {
        return RequestPartitionHeaderUtil.fromHeader(theSourceName, thePartitionHeaderValue, true, theDefaultPartitionSettings);
    }

    @Nullable
    public static RequestPartitionId fromHeaderFirstPartitionOnly(@Nullable String thePartitionHeaderValue, @Nullable IDefaultPartitionSettings theDefaultPartitionSettings) {
        return RequestPartitionHeaderUtil.fromHeader(HTTP_HEADER_SOURCE_NAME, thePartitionHeaderValue, true, theDefaultPartitionSettings);
    }

    public static void validateHeader(String theSourceName, String thePartitionHeaderValue) {
        RequestPartitionHeaderUtil.fromHeader(theSourceName, thePartitionHeaderValue, new IDefaultPartitionSettings(){});
    }

    public static void validateHeader(String thePartitionHeaderValue) {
        RequestPartitionHeaderUtil.validateHeader(HTTP_HEADER_SOURCE_NAME, thePartitionHeaderValue);
    }

    @Nullable
    private static RequestPartitionId fromHeader(@Nonnull String theSourceName, @Nullable String thePartitionHeaderValue, boolean theIncludeOnlyTheFirst, @Nullable IDefaultPartitionSettings theDefaultPartitionSettings) {
        if (thePartitionHeaderValue == null) {
            return null;
        }
        String[] partitionIdStrings = thePartitionHeaderValue.split(",");
        ArrayList<Integer> partitionIds = new ArrayList<Integer>();
        for (String partitionIdString : partitionIdStrings) {
            String trimmedPartitionId = partitionIdString.trim();
            if (trimmedPartitionId.equals("_ALL")) {
                return RequestPartitionId.allPartitions();
            }
            Integer partitionId = RequestPartitionHeaderUtil.getPartitionId(theSourceName, theDefaultPartitionSettings, trimmedPartitionId);
            if (theIncludeOnlyTheFirst) {
                return RequestPartitionId.fromPartitionId((Integer)partitionId);
            }
            partitionIds.add(partitionId);
        }
        if (partitionIds.isEmpty()) {
            String msg = String.format("No partition IDs provided in %s", theSourceName);
            throw new InvalidRequestException(Msg.code((int)2645) + msg);
        }
        return RequestPartitionId.fromPartitionIds(partitionIds);
    }

    @Nullable
    private static Integer getPartitionId(@Nonnull String theSourceName, @Nullable IDefaultPartitionSettings theDefaultPartitionSettings, String trimmedPartitionId) {
        Integer partitionId;
        if (trimmedPartitionId.equals("DEFAULT")) {
            if (theDefaultPartitionSettings == null) {
                throw new InvalidRequestException(Msg.code((int)2722) + "Can only use DEFAULT partitionId in contexts where the default partition ID is defined.");
            }
            partitionId = theDefaultPartitionSettings.getDefaultPartitionId();
        } else {
            try {
                partitionId = Integer.parseInt(trimmedPartitionId);
            }
            catch (NumberFormatException e) {
                String msg = String.format("Invalid partition ID: '%s' provided in %s", trimmedPartitionId, theSourceName);
                throw new InvalidRequestException(Msg.code((int)2643) + msg);
            }
        }
        return partitionId;
    }

    public static <T> void setRequestPartitionIdFromHeaderIfNotAlreadySet(@Nonnull IMessage<T> theMessage, @Nullable IDefaultPartitionSettings theDefaultPartitionSettings) {
        T t = theMessage.getPayload();
        if (t instanceof BaseResourceMessage) {
            BaseResourceMessage baseResourceMessage = (BaseResourceMessage)t;
            if (baseResourceMessage.getPartitionId() != null) {
                return;
            }
            Optional oHeader = theMessage.getHeader("X-Request-Partition-IDs");
            if (oHeader.isEmpty()) {
                return;
            }
            RequestPartitionId headerPartitionId = RequestPartitionHeaderUtil.fromHeader((String)oHeader.get(), theDefaultPartitionSettings);
            baseResourceMessage.setPartitionId(headerPartitionId);
        }
    }
}

