/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.messaging.IResourceMessage;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;

public abstract class BaseResourceMessage
implements IResourceMessage,
IModelJson {
    @JsonProperty(value="operationType")
    protected OperationTypeEnum myOperationType;
    @JsonProperty(value="attributes")
    private Map<String, String> myAttributes;
    @JsonProperty(value="transactionId")
    private String myTransactionId;
    @JsonProperty(value="mediaType")
    private String myMediaType;
    @JsonProperty(value="messageKey")
    private String myPayloadMessageKey;

    public abstract RequestPartitionId getPartitionId();

    public abstract void setPartitionId(RequestPartitionId var1);

    public Optional<String> getAttribute(String theKey) {
        Validate.notBlank((CharSequence)theKey);
        if (this.myAttributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.myAttributes.get(theKey));
    }

    public void setAttribute(String theKey, String theValue) {
        Validate.notBlank((CharSequence)theKey);
        Objects.requireNonNull(theValue);
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<String, String>();
        }
        this.myAttributes.put(theKey, theValue);
    }

    public void copyAdditionalPropertiesFrom(BaseResourceMessage theMsg) {
        if (theMsg.myAttributes != null) {
            if (this.myAttributes == null) {
                this.myAttributes = new HashMap<String, String>();
            }
            this.myAttributes.putAll(theMsg.myAttributes);
        }
    }

    public OperationTypeEnum getOperationType() {
        return this.myOperationType;
    }

    public void setOperationType(OperationTypeEnum theOperationType) {
        this.myOperationType = theOperationType;
    }

    @Nullable
    public String getTransactionId() {
        return this.myTransactionId;
    }

    public void setTransactionId(String theTransactionId) {
        this.myTransactionId = theTransactionId;
    }

    public String getMediaType() {
        return this.myMediaType;
    }

    public void setMediaType(String theMediaType) {
        this.myMediaType = theMediaType;
    }

    @Override
    @Nullable
    public String getPayloadMessageKey() {
        return this.myPayloadMessageKey;
    }

    @Override
    public void setPayloadMessageKey(String thePayloadMessageKey) {
        this.myPayloadMessageKey = thePayloadMessageKey;
    }

    @VisibleForTesting
    public Map<String, String> getAttributes() {
        return (Map)ObjectUtils.defaultIfNull(this.myAttributes, Collections.emptyMap());
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        BaseResourceMessage that = (BaseResourceMessage)theO;
        return this.getOperationType() == that.getOperationType() && Objects.equals(this.getAttributes(), that.getAttributes()) && Objects.equals(this.getTransactionId(), that.getTransactionId()) && Objects.equals(this.getMediaType(), that.getMediaType()) && Objects.equals(this.getPayloadMessageKey(), that.getPayloadMessageKey());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getOperationType(), this.getAttributes(), this.getTransactionId(), this.getMediaType()});
    }

    public static enum OperationTypeEnum {
        CREATE(RestOperationTypeEnum.CREATE),
        UPDATE(RestOperationTypeEnum.UPDATE),
        DELETE(RestOperationTypeEnum.DELETE),
        MANUALLY_TRIGGERED(RestOperationTypeEnum.UPDATE),
        TRANSACTION(RestOperationTypeEnum.UPDATE);

        private final RestOperationTypeEnum myRestOperationTypeEnum;

        private OperationTypeEnum(RestOperationTypeEnum theRestOperationTypeEnum) {
            this.myRestOperationTypeEnum = theRestOperationTypeEnum;
        }

        public static OperationTypeEnum from(RestOperationTypeEnum theRestOperationType) {
            switch (theRestOperationType) {
                case CREATE: {
                    return CREATE;
                }
                case UPDATE: {
                    return UPDATE;
                }
                case DELETE: {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException(Msg.code((int)2348) + "Unsupported operation type: " + String.valueOf(theRestOperationType));
        }

        public RestOperationTypeEnum asRestOperationType() {
            return this.myRestOperationTypeEnum;
        }
    }
}

