/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ValidationPostProcessingRuleJson
implements IModelJson {
    @JsonProperty(value="msgId")
    private String myMsgId;
    private Pattern myMsgIdRegexPattern;
    @JsonProperty(value="oldSeverities", required=true)
    private Collection<ResultSeverityEnum> myOldSeverities;
    @JsonProperty(value="messageFragments")
    private Collection<String> myMessageFragments;
    @JsonProperty(value="newSeverity", required=true)
    private ResultSeverityEnum myNewSeverity;

    @JsonCreator
    public ValidationPostProcessingRuleJson(@JsonProperty(value="msgId") String theMsgId, @JsonProperty(value="msgIdRegex") String themsgIdRegex, @JsonProperty(value="oldSeverities") Collection<ResultSeverityEnum> theOldSeverities, @JsonProperty(value="messageFragments") Collection<String> theExtraMessageFragments, @JsonProperty(value="newSeverity") ResultSeverityEnum theNewSeverity) {
        this.validateParams(theMsgId, themsgIdRegex, theNewSeverity);
        this.myMsgId = theMsgId;
        if (StringUtils.isNotBlank((CharSequence)themsgIdRegex)) {
            this.myMsgIdRegexPattern = Pattern.compile(themsgIdRegex, 2);
        }
        this.myOldSeverities = CollectionUtils.emptyIfNull(theOldSeverities);
        this.myNewSeverity = theNewSeverity;
        this.myMessageFragments = CollectionUtils.emptyIfNull(theExtraMessageFragments);
    }

    private void validateParams(String theMsgId, String themsgIdRegex, ResultSeverityEnum theNewSeverity) {
        if (StringUtils.isBlank((CharSequence)theMsgId) && StringUtils.isBlank((CharSequence)themsgIdRegex)) {
            throw new InvalidParameterException(Msg.code((int)2705) + "One of 'msgId' and 'msgIdRegex' must be present");
        }
        if (StringUtils.isNotBlank((CharSequence)theMsgId) && StringUtils.isNotBlank((CharSequence)themsgIdRegex)) {
            throw new InvalidParameterException(Msg.code((int)2706) + "Only one of 'msgId' and 'msgIdRegex' must be present");
        }
        if (theNewSeverity == null) {
            throw new InvalidParameterException(Msg.code((int)2707) + "Parameter 'newSeverity' must be present");
        }
    }

    public String getMsgId() {
        return this.myMsgId;
    }

    public ResultSeverityEnum getNewSeverity() {
        return this.myNewSeverity;
    }

    public Collection<ResultSeverityEnum> getOldSeverities() {
        return this.myOldSeverities;
    }

    public Collection<String> getMessageFragments() {
        return this.myMessageFragments;
    }

    public Pattern getMsgIdRegexPattern() {
        return this.myMsgIdRegexPattern;
    }
}

