/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.server.interceptor.validation.ValidationPostProcessingRuleJson;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class ValidationMessagePostProcessingInterceptor {
    private final Logger ourLog = LoggerFactory.getLogger(ValidationMessagePostProcessingInterceptor.class);
    private final List<Rule> myRules = new ArrayList<Rule>();

    public ValidationMessagePostProcessingInterceptor addPostProcessingPatterns(ValidationPostProcessingRuleJson ... theJsonDefinitions) {
        return this.addPostProcessingPatterns(Arrays.asList(theJsonDefinitions));
    }

    public ValidationMessagePostProcessingInterceptor addPostProcessingPatterns(List<ValidationPostProcessingRuleJson> theJsonDefinitions) {
        this.myRules.addAll(theJsonDefinitions.stream().map(Rule::of).toList());
        return this;
    }

    @Hook(value=Pointcut.VALIDATION_COMPLETED)
    public ValidationResult handle(ValidationResult theResult) {
        ArrayList<SingleValidationMessage> newMessages = new ArrayList<SingleValidationMessage>(theResult.getMessages().size());
        int msgIdx = 0;
        for (SingleValidationMessage inputMessage : theResult.getMessages()) {
            Optional<Rule> firstMatchedDefinitionOpt = this.findFirstMatchedDefinition(inputMessage);
            msgIdx = this.logResult(inputMessage, msgIdx, firstMatchedDefinitionOpt);
            firstMatchedDefinitionOpt.ifPresent(theMatchedRule -> inputMessage.setSeverity(theMatchedRule.newSeverity()));
            newMessages.add(inputMessage);
        }
        return new ValidationResult(theResult.getContext(), newMessages);
    }

    private int logResult(SingleValidationMessage inputMessage, int msgIdx, Optional<Rule> firstMatchedDefinitionOpt) {
        this.ourLog.atDebug().setMessage("input message position: {} - matching result: {} - input messageId: {}").addArgument((Object)(++msgIdx)).addArgument((Object)firstMatchedDefinitionOpt.map(theRule -> System.lineSeparator() + "   matched rule: " + String.valueOf(theRule)).orElse("no rule matched")).addArgument((Object)inputMessage.getMessageId()).log();
        return msgIdx;
    }

    private Optional<Rule> findFirstMatchedDefinition(SingleValidationMessage theMessage) {
        return this.myRules.stream().filter(rule -> this.matchesMessageId(theMessage.getMessageId(), (Rule)rule)).filter(rule -> rule.oldSeverities.contains(theMessage.getSeverity())).filter(rule -> this.stringContainsAll(theMessage.getMessage(), rule.diagnosticFragmentsToMatch())).findFirst();
    }

    private boolean matchesMessageId(String theMessageId, Rule theRule) {
        boolean matched = theRule.messageId() != null && theRule.messageId.equals(theMessageId) || theRule.messagePattern != null && theRule.messagePattern.matcher(theMessageId).matches();
        this.ourLog.atTrace().setMessage("messageId match result: {} - input messageId: {} - matching rule: {}").addArgument((Object)matched).addArgument((Object)theMessageId).addArgument((Object)theRule).log();
        return matched;
    }

    private boolean stringContainsAll(String theMessage, Collection<String> theMatchingFragments) {
        return theMatchingFragments.stream().allMatch(theMessage::contains);
    }

    public record Rule(String messageId, Pattern messagePattern, Collection<ResultSeverityEnum> oldSeverities, Collection<String> diagnosticFragmentsToMatch, ResultSeverityEnum newSeverity) {
        public static Rule of(ValidationPostProcessingRuleJson theParamsDefinitionJson) {
            return new Rule(theParamsDefinitionJson.getMsgId(), theParamsDefinitionJson.getMsgIdRegexPattern(), theParamsDefinitionJson.getOldSeverities(), theParamsDefinitionJson.getMessageFragments(), theParamsDefinitionJson.getNewSeverity());
        }
    }
}

