/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.consent;

import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOutcome;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentContextServices;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentService;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleFilteringConsentService
implements IConsentService {
    private static final Logger ourLog = LoggerFactory.getLogger(RuleFilteringConsentService.class);
    private static final Pointcut CAN_SEE_POINTCUT = Pointcut.STORAGE_PREACCESS_RESOURCES;
    protected final IRuleApplier myRuleApplier;

    public RuleFilteringConsentService(IRuleApplier theRuleApplier) {
        this.myRuleApplier = theRuleApplier;
    }

    @Override
    public ConsentOutcome canSeeResource(RequestDetails theRequestDetails, IBaseResource theResource, IConsentContextServices theContextServices) {
        ourLog.trace("canSeeResource() {} {}", (Object)theRequestDetails, (Object)theResource);
        AuthorizationInterceptor.Verdict ruleResult = this.myRuleApplier.applyRulesAndReturnDecision(theRequestDetails.getRestOperationType(), theRequestDetails, null, null, theResource, CAN_SEE_POINTCUT);
        if (ruleResult.getDecision() == PolicyEnum.ALLOW) {
            return ConsentOutcome.PROCEED;
        }
        return ConsentOutcome.REJECT;
    }
}

