/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.consent;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOutcome;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentContextServices;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentService;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class MultiDelegateConsentService
implements IConsentService {
    private final Collection<IConsentService> myDelegates;
    private final Function<Stream<ConsentOutcome>, ConsentOutcome> myVoteCombiner;

    @Nonnull
    public static MultiDelegateConsentService withParallelVoting(@Nonnull List<IConsentService> theDelegateConsentServices) {
        return new MultiDelegateConsentService(ConsentOutcome::parallelReduce, theDelegateConsentServices);
    }

    @Nonnull
    public static MultiDelegateConsentService withSerialVoting(@Nonnull List<IConsentService> theDelegateConsentServices) {
        return new MultiDelegateConsentService(ConsentOutcome::serialReduce, theDelegateConsentServices);
    }

    private MultiDelegateConsentService(Function<Stream<ConsentOutcome>, ConsentOutcome> theVoteCombiner, Collection<IConsentService> theDelegates) {
        this.myVoteCombiner = theVoteCombiner;
        this.myDelegates = theDelegates;
    }

    @Override
    public ConsentOutcome startOperation(RequestDetails theRequestDetails, IConsentContextServices theContextServices) {
        return this.myVoteCombiner.apply(this.myDelegates.stream().map(nextDelegate -> nextDelegate.startOperation(theRequestDetails, theContextServices)));
    }

    @Override
    public boolean shouldProcessCanSeeResource(RequestDetails theRequestDetails, IConsentContextServices theContextServices) {
        return this.myDelegates.stream().map(nextDelegate -> nextDelegate.shouldProcessCanSeeResource(theRequestDetails, theContextServices)).filter(nextShould -> nextShould).findFirst().orElse(Boolean.FALSE);
    }

    @Override
    public ConsentOutcome canSeeResource(RequestDetails theRequestDetails, IBaseResource theResource, IConsentContextServices theContextServices) {
        return this.myVoteCombiner.apply(this.myDelegates.stream().map(nextDelegate -> nextDelegate.canSeeResource(theRequestDetails, theResource, theContextServices)));
    }

    @Override
    public ConsentOutcome willSeeResource(RequestDetails theRequestDetails, IBaseResource theResource, IConsentContextServices theContextServices) {
        return this.myVoteCombiner.apply(this.myDelegates.stream().map(nextDelegate -> nextDelegate.willSeeResource(theRequestDetails, theResource, theContextServices)));
    }

    public Collection<IConsentService> getDelegates() {
        return this.myDelegates;
    }
}

